/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;

public class FileUtils {
    public static boolean isXMLFile(String fileName) {
        IContentType contentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForXML.ContentTypeID_XML);
        return contentType.isAssociatedWith(fileName);
    }

    public static boolean isXMLFile(IFile file) {
        return FileUtils.isXMLFile(file.getName());
    }

    public static String getContentTypeId(IFile file) {
        IContentType contentType;
        block5: {
            IContentDescription contentDescription;
            block4: {
                try {
                    contentDescription = file.getContentDescription();
                    if (contentDescription != null) break block4;
                    return null;
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            contentType = contentDescription.getContentType();
            if (contentType != null) break block5;
            return null;
        }
        return contentType.getId();
    }
}

