/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.common.ivyfile;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivyde.common.ivyfile.IvyModuleDescriptorFile;
import org.apache.ivyde.common.model.IValueProvider;
import org.apache.ivyde.common.model.IvyBooleanTagAttribute;
import org.apache.ivyde.common.model.IvyFile;
import org.apache.ivyde.common.model.IvyModel;
import org.apache.ivyde.common.model.IvyModelSettings;
import org.apache.ivyde.common.model.IvyTag;
import org.apache.ivyde.common.model.IvyTagAttribute;
import org.apache.ivyde.common.model.ListValueProvider;

public class IvyModuleDescriptorModel
extends IvyModel {
    public IvyModuleDescriptorModel(IvyModelSettings settings) {
        super(settings);
        IvyTag ivyTag = new IvyTag("ivy-module", "root tag of ivy file");
        ivyTag.setDoc("Root tag of any ivy-file.");
        ivyTag.addAttribute(new IvyTagAttribute("version", "The version of the ivy file specification \nshould be '2.0' with current version of ivy", true));
        this.addTag(ivyTag);
        IValueProvider defaultOrganizationProvider = new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                return new String[]{IvyModuleDescriptorModel.this.getSettings().getDefaultOrganization()};
            }
        };
        IValueProvider defaultOrganizationURLProvider = new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                return new String[]{IvyModuleDescriptorModel.this.getSettings().getDefaultOrganizationURL()};
            }
        };
        IvyTagAttribute orgTagAttribute = new IvyTagAttribute("organisation", "the name of the organisation that is the owner of this module.", true);
        orgTagAttribute.setValueProvider(defaultOrganizationProvider);
        IvyTagAttribute statusTagAttribute = new IvyTagAttribute("status", "the status of this module.");
        statusTagAttribute.setValueProvider(new ListValueProvider(this.getDefault("status")));
        IvyTagAttribute pubTagAttribute = new IvyTagAttribute("publication", "the date of publication of this module. \nIt should be given in this format: yyyyMMddHHmmss");
        pubTagAttribute.setValueProvider(new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                return new String[]{Ivy.DATE_FORMAT.format(new Date())};
            }
        });
        IvyTagAttribute moduleTagAttribute = new IvyTagAttribute("module", "the name of the module described by this ivy file.", true);
        IValueProvider projectNameValueProvider = new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                return new String[]{ivyFile.getProjectName()};
            }
        };
        moduleTagAttribute.setValueProvider(projectNameValueProvider);
        IvyTag info = new IvyTag("info", "gives general information about the described module", new IvyTagAttribute[]{orgTagAttribute, moduleTagAttribute, new IvyTagAttribute("branch", "the branch of this module."), new IvyTagAttribute("revision", "the revision of this module."), statusTagAttribute, pubTagAttribute});
        this.addTag(info);
        IvyTag extend = new IvyTag("extends", "gives information about the parent module");
        IvyTagAttribute parentOrgAtt = new IvyTagAttribute("organisation", "the name of the organisation of the parent module.", false);
        parentOrgAtt.setValueProvider(new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                List ret = IvyModuleDescriptorModel.this.listDependencyTokenValues(att.getName(), ivyFile);
                ret.add(IvyModuleDescriptorModel.this.getSettings().getDefaultOrganization());
                String org = ((IvyModuleDescriptorFile)ivyFile).getOrganisation();
                if (org != null) {
                    ret.add(org);
                }
                return ret.toArray(new String[ret.size()]);
            }
        });
        extend.addAttribute(parentOrgAtt);
        IvyTagAttribute parentModuleAtt = new IvyTagAttribute("module", "the module name of the parent module", true);
        parentModuleAtt.setValueProvider(new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                List ret = IvyModuleDescriptorModel.this.listDependencyTokenValues(att.getName(), ivyFile);
                return ret.toArray(new String[ret.size()]);
            }
        });
        extend.addAttribute(parentModuleAtt);
        IvyTagAttribute parentRevAtt = new IvyTagAttribute("revision", "the revision of the parent module");
        extend.addAttribute(parentRevAtt);
        this.addTag(extend);
        info.addChildIvyTag(extend);
        IvyTag child = new IvyTag("license", "gives information about the licenses of the described module");
        child.addAttribute(new IvyTagAttribute("name", "the name of the license. \nTry to respect spelling when using a classical license.", true, new ListValueProvider(this.getDefault("license"))));
        child.addAttribute(new IvyTagAttribute("url", "an url pointing to the license text.", false));
        this.addTag(child);
        info.addChildIvyTag(child);
        child = new IvyTag("ivyauthor", "describes who has contributed to write the ivy file");
        child.addAttribute(new IvyTagAttribute("name", "the name of the author, as a person or a company.", true, defaultOrganizationProvider));
        child.addAttribute(new IvyTagAttribute("url", "an url pointing to where the author can be reached.", false, defaultOrganizationURLProvider));
        this.addTag(child);
        info.addChildIvyTag(child);
        child = new IvyTag("repository", "describes on which public repositories this module can be found");
        child.addAttribute(new IvyTagAttribute("name", "the name of the repository. \nTry to respect spelling for common repositories (ibiblio, ivyrep, ...)", true, new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                return new String[]{"ibiblio", "ivyrep"};
            }
        }));
        child.addAttribute(new IvyTagAttribute("url", "an url pointing to the repository.", true, new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                Map allAttsValues = ivyFile.getAllAttsValues();
                if (allAttsValues != null) {
                    String name = (String)allAttsValues.get("name");
                    if ("ibiblio".equals(name)) {
                        return new String[]{"http://www.ibiblio.org/maven/"};
                    }
                    if ("ivyrep".equals(name)) {
                        return new String[]{"http://www.jayasoft.fr/org/ivyrep/"};
                    }
                }
                return null;
            }
        }));
        IvyTagAttribute reppatternTagAttribute = new IvyTagAttribute("pattern", "an ivy pattern to find modules on this repository", false);
        reppatternTagAttribute.setValueProvider(new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                Map allAttsValues = ivyFile.getAllAttsValues();
                if (allAttsValues != null) {
                    String name = (String)allAttsValues.get("name");
                    if ("ibiblio".equals(name)) {
                        return new String[]{"[module]/[type]s/[artifact]-[revision].[ext]"};
                    }
                    if ("ivyrep".equals(name)) {
                        return new String[]{"[organisation]/[module]/[artifact]-[revision].[ext]"};
                    }
                }
                return null;
            }
        });
        child.addAttribute(reppatternTagAttribute);
        child.addAttribute(new IvyBooleanTagAttribute("ivys", "true if ivy file can be found on this repository", false));
        child.addAttribute(new IvyBooleanTagAttribute("artifacts", "true if module artifacts can be found on this repository", false));
        this.addTag(child);
        info.addChildIvyTag(child);
        child = new IvyTag("description", "gives general description about the module");
        child.addAttribute(new IvyTagAttribute("homepage", "the url of the homepage of the module", false, defaultOrganizationURLProvider));
        this.addTag(child);
        info.addChildIvyTag(child);
        ivyTag.addChildIvyTag(info);
        IvyTag configurations = new IvyTag("configurations", "container for configuration elements");
        IvyTag conf = new IvyTag("conf", "declares a configuration of this module");
        conf.addAttribute(new IvyTagAttribute("name", "the name of the declared configuration", true));
        conf.addAttribute(new IvyTagAttribute("description", "a short description for the declared configuration", false));
        IvyTagAttribute visibilityTagAttribute = new IvyTagAttribute("visibility", "the visibility of the declared configuration.\n'public' means that this configuration can be used by other modules, \nwhile 'private' means that this configuration is used only in the\nmodule itself, and is not exposed to other modules", false);
        visibilityTagAttribute.setValueProvider(new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                return new String[]{"public", "private"};
            }
        });
        conf.addAttribute(visibilityTagAttribute);
        IvyTagAttribute confExtTagAttribute = new IvyTagAttribute("extends", "a comma separated list of configurations of this module \nthat the current configuration extends", false);
        IValueProvider masterConfsValueProvider = new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                StringBuffer base = new StringBuffer();
                String qualifier = ivyFile.getAttributeValueQualifier();
                int comma = qualifier.lastIndexOf(",") + 1;
                base.append(qualifier.substring(0, comma));
                qualifier = qualifier.substring(comma);
                while (qualifier.length() > 0 && qualifier.charAt(0) == ' ') {
                    base.append(' ');
                    qualifier = qualifier.substring(1);
                }
                String[] confs = ((IvyModuleDescriptorFile)ivyFile).getConfigurationNames();
                int i = 0;
                while (i < confs.length) {
                    confs[i] = base + confs[i];
                    ++i;
                }
                return confs;
            }
        };
        IValueProvider masterConfValueProvider = new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                return ((IvyModuleDescriptorFile)ivyFile).getConfigurationNames();
            }
        };
        confExtTagAttribute.setValueProvider(masterConfsValueProvider);
        conf.addAttribute(confExtTagAttribute);
        IvyTagAttribute deprecatedTagAttribute = new IvyTagAttribute("deprecated", "indicates that this conf has been deprecated \nby giving the date of the deprecation. \nIt should be given in this format: yyyyMMddHHmmss", false);
        deprecatedTagAttribute.setValueProvider(new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                return new String[]{Ivy.DATE_FORMAT.format(new Date())};
            }
        });
        conf.addAttribute(deprecatedTagAttribute);
        configurations.addChildIvyTag(conf);
        ArrayList<IvyTag> allConf = new ArrayList<IvyTag>();
        allConf.add(conf);
        this.addTag(conf.getName(), allConf);
        ivyTag.addChildIvyTag(configurations);
        this.addTag(configurations);
        IvyTag publications = new IvyTag("publications", "container for published artifact elements");
        IvyTag artifact = new IvyTag("artifact", "declares a published artifact for this module");
        artifact.addAttribute(new IvyTagAttribute("name", "the name of the published artifact. This name must not include revision.", true, projectNameValueProvider));
        artifact.addAttribute(new IvyTagAttribute("type", "the type of the published artifact. \nIt's usually its extension, but not necessarily. \nFor instance, ivy files are of type 'ivy' but have 'xml' extension", true, new ListValueProvider(this.getDefault("type"))));
        artifact.addAttribute(new IvyTagAttribute("ext", "the extension of the published artifact", false, new ListValueProvider(this.getDefault("ext"))));
        artifact.addAttribute(new IvyTagAttribute("conf", "comma separated list of public configurations in which this artifact\nis published. '*' wildcard can be used to designate all public\nconfigurations of this module", false, masterConfsValueProvider));
        IvyTag conf2 = new IvyTag("conf", "indicates a public configuration in which this artifact is published");
        conf2.addAttribute(new IvyTagAttribute("name", "the name of a module public configuration in which this artifact\nis published. '*' wildcard can be used to designate all\npublic configurations of this module", true, masterConfValueProvider));
        allConf.add(conf2);
        artifact.addChildIvyTag(conf2);
        publications.addChildIvyTag(artifact);
        this.addTag(publications);
        this.addTag(artifact);
        ivyTag.addChildIvyTag(publications);
        IvyTag dependencies = new IvyTag("dependencies", "container for dependency elements");
        IvyTag dependency = new IvyTag("dependency", "declares a dependency for this module"){

            public String[] getPossibleValuesForAttribute(String att, IvyFile ivyfile) {
                String[] r = super.getPossibleValuesForAttribute(att, ivyfile);
                if (r == null) {
                    List ret = IvyModuleDescriptorModel.this.listDependencyTokenValues(att, ivyfile);
                    return ret.toArray(new String[ret.size()]);
                }
                return r;
            }
        };
        IvyTagAttribute orgAtt = new IvyTagAttribute("org", "the name of the organisation of the dependency.", false);
        orgAtt.setValueProvider(new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                List ret = IvyModuleDescriptorModel.this.listDependencyTokenValues(att.getName(), ivyFile);
                ret.add(IvyModuleDescriptorModel.this.getSettings().getDefaultOrganization());
                String org = ((IvyModuleDescriptorFile)ivyFile).getOrganisation();
                if (org != null) {
                    ret.add(org);
                }
                return ret.toArray(new String[ret.size()]);
            }
        });
        dependency.addAttribute(orgAtt);
        IvyTagAttribute module = new IvyTagAttribute("name", "the module name of the dependency", true);
        module.setValueProvider(new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                List ret = IvyModuleDescriptorModel.this.listDependencyTokenValues(att.getName(), ivyFile);
                return ret.toArray(new String[ret.size()]);
            }
        });
        dependency.addAttribute(module);
        IvyTagAttribute branch = new IvyTagAttribute("branch", "the branch of the dependency. \nDo not set if not needed.", false);
        branch.setValueProvider(new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                List ret = IvyModuleDescriptorModel.this.listDependencyTokenValues(att.getName(), ivyFile);
                return ret.toArray(new String[ret.size()]);
            }
        });
        dependency.addAttribute(branch);
        IvyTagAttribute rev = new IvyTagAttribute("rev", "the revision of the dependency. \nUse 'latest.integration' to get the latest version of the dependency. \nYou can also end the revision asked with a '+' to get the latest matching revision.", true);
        rev.setValueProvider(new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                List ret = IvyModuleDescriptorModel.this.listDependencyTokenValues(att.getName(), ivyFile);
                ret.add("latest.integration");
                return ret.toArray(new String[ret.size()]);
            }
        });
        dependency.addAttribute(rev);
        dependency.addAttribute(new IvyBooleanTagAttribute("force", "a boolean to give an indication to conflict manager \nthat this dependency should be forced to this revision", false));
        dependency.addAttribute(new IvyBooleanTagAttribute("transitive", "a boolean indicating if this dependency should be resolved transitively or not", false));
        IvyTagAttribute confAtt = new IvyTagAttribute("conf", "an inline mapping configuration spec", false);
        dependency.addAttribute(confAtt);
        confAtt.setValueProvider(new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                String qualifier = ivyFile.getAttributeValueQualifier();
                int index = qualifier.lastIndexOf(59) + 1;
                StringBuffer base = new StringBuffer(qualifier.substring(0, index));
                int arrowIndex = (qualifier = qualifier.substring(index)).indexOf("->");
                if (arrowIndex > -1) {
                    String org = ((IvyModuleDescriptorFile)ivyFile).getDependencyOrganisation();
                    Map otherAttValues = ivyFile.getAllAttsValues();
                    if (org != null && otherAttValues != null && otherAttValues.get("name") != null && otherAttValues.get("rev") != null) {
                        otherAttValues.remove("org");
                        String branch = (String)otherAttValues.remove("branch");
                        otherAttValues.remove("conf");
                        otherAttValues.remove("force");
                        otherAttValues.remove("transitive");
                        otherAttValues.remove("changing");
                        return this.getDependencyConfs(org, (String)otherAttValues.remove("name"), branch, (String)otherAttValues.remove("rev"), otherAttValues, qualifier, base, arrowIndex);
                    }
                } else {
                    return this.getMasterConfs(ivyFile, qualifier, base, arrowIndex);
                }
                return null;
            }

            private String[] getMasterConfs(IvyFile ivyFile, String qualifier, StringBuffer base, int arrowIndex) {
                int comma = qualifier.lastIndexOf(",") + 1;
                base.append(qualifier.substring(0, comma));
                qualifier = qualifier.substring(comma);
                while (qualifier.length() > 0 && qualifier.charAt(0) == ' ') {
                    base.append(' ');
                    qualifier = qualifier.substring(1);
                }
                String[] confs = ((IvyModuleDescriptorFile)ivyFile).getConfigurationNames();
                int i = 0;
                while (i < confs.length) {
                    confs[i] = base + confs[i];
                    ++i;
                }
                ArrayList<String> ret = new ArrayList<String>(Arrays.asList(confs));
                ret.add("*");
                return ret.toArray(new String[ret.size()]);
            }

            private String[] getDependencyConfs(String org, String name, String branch, String rev, Map otherAtts, String qualifier, StringBuffer base, int arrowIndex) {
                ResolvedModuleRevision dep;
                ModuleRevisionId mrid;
                block8: {
                    DependencyResolver resolver;
                    DefaultDependencyDescriptor ddd;
                    ResolveData data;
                    block7: {
                        Ivy ivy = IvyModuleDescriptorModel.this.getIvy();
                        if (ivy == null) {
                            return null;
                        }
                        base.append(qualifier.substring(0, arrowIndex + 2));
                        qualifier = qualifier.substring(arrowIndex + 2);
                        int comma = qualifier.lastIndexOf(",") + 1;
                        base.append(qualifier.substring(0, comma));
                        qualifier = qualifier.substring(comma);
                        while (qualifier.length() > 0 && qualifier.charAt(0) == ' ') {
                            base.append(' ');
                            qualifier = qualifier.substring(1);
                        }
                        data = new ResolveData(ivy.getResolveEngine(), new ResolveOptions());
                        mrid = ModuleRevisionId.newInstance((String)org, (String)name, (String)branch, (String)rev, (Map)otherAtts);
                        ddd = new DefaultDependencyDescriptor(mrid, false);
                        resolver = ivy.getSettings().getResolver(mrid);
                        if (resolver != null) break block7;
                        return null;
                    }
                    dep = resolver.getDependency((DependencyDescriptor)ddd, data);
                    if (dep != null) break block8;
                    return null;
                }
                try {
                    String[] confs = dep.getDescriptor().getConfigurationsNames();
                    int i = 0;
                    while (i < confs.length) {
                        confs[i] = base + confs[i];
                        ++i;
                    }
                    ArrayList<String> ret = new ArrayList<String>(Arrays.asList(confs));
                    ret.add("*");
                    return ret.toArray(new String[ret.size()]);
                }
                catch (ParseException e) {
                    IvyModuleDescriptorModel.this.getSettings().logError("The dependencies of " + mrid + " could not be parsed", e);
                    return null;
                }
            }
        });
        IvyTag conf3 = new IvyTag("conf", "defines configuration mapping has sub element");
        conf3.addAttribute(new IvyTagAttribute("name", "the name of the master configuration to map. \n'*' wildcard can be used to designate all configurations of this module", true, masterConfValueProvider));
        conf3.addAttribute(new IvyTagAttribute("mapped", "a comma separated list of dependency configurations \nto which this master configuration should be mapped", false, new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                Map otherAttValues;
                String org;
                Ivy ivy = IvyModuleDescriptorModel.this.getIvy();
                int[] indexes = ivyFile.getParentTagIndex();
                if (indexes != null && ivy != null && (org = ((IvyModuleDescriptorFile)ivyFile).getDependencyOrganisation(otherAttValues = ivyFile.getAllAttsValues(indexes[0] + 1))) != null && otherAttValues != null && otherAttValues.get("name") != null && otherAttValues.get("rev") != null) {
                    StringBuffer base = new StringBuffer();
                    String qualifier = ivyFile.getAttributeValueQualifier();
                    int comma = qualifier.lastIndexOf(",") + 1;
                    base.append(qualifier.substring(0, comma));
                    qualifier = qualifier.substring(comma);
                    while (qualifier.length() > 0 && qualifier.charAt(0) == ' ') {
                        base.append(' ');
                        qualifier = qualifier.substring(1);
                    }
                    ResolveData data = new ResolveData(ivy.getResolveEngine(), new ResolveOptions());
                    ModuleRevisionId mrid = ModuleRevisionId.newInstance((String)org, (String)((String)otherAttValues.get("name")), (String)((String)otherAttValues.get("rev")));
                    DefaultDependencyDescriptor ddd = new DefaultDependencyDescriptor(mrid, false);
                    try {
                        String[] confs = ivy.getSettings().getResolver(mrid).getDependency((DependencyDescriptor)ddd, data).getDescriptor().getConfigurationsNames();
                        int i = 0;
                        while (i < confs.length) {
                            confs[i] = base + confs[i];
                            ++i;
                        }
                        ArrayList<String> ret = new ArrayList<String>(Arrays.asList(confs));
                        ret.add("*");
                        return ret.toArray(new String[ret.size()]);
                    }
                    catch (ParseException e) {
                        IvyModuleDescriptorModel.this.getSettings().logError("The dependencies of " + mrid + " could not be parsed", e);
                        return new String[]{"*"};
                    }
                }
                return new String[]{"*"};
            }
        }));
        allConf.add(conf3);
        IvyTag mapped = new IvyTag("mapped", "map dependency configurations for this master configuration");
        mapped.addAttribute(new IvyTagAttribute("name", "the name of the dependency configuration mapped. \n'*' wildcard can be used to designate all configurations of this module", true, new IValueProvider(){

            public String[] getValuesfor(IvyTagAttribute att, IvyFile ivyFile) {
                Ivy ivy = IvyModuleDescriptorModel.this.getIvy();
                int[] indexes = ivyFile.getParentTagIndex();
                if (indexes == null || ivy == null) {
                    return new String[]{"*"};
                }
                if ((indexes = ivyFile.getParentTagIndex(indexes[0])) == null) {
                    return new String[]{"*"};
                }
                Map otherAttValues = ivyFile.getAllAttsValues(indexes[0] + 1);
                String org = ((IvyModuleDescriptorFile)ivyFile).getDependencyOrganisation(otherAttValues);
                if (org == null || otherAttValues == null || otherAttValues.get("name") == null || otherAttValues.get("rev") == null) {
                    return new String[]{"*"};
                }
                ResolveData data = new ResolveData(ivy.getResolveEngine(), new ResolveOptions());
                ModuleRevisionId mrid = ModuleRevisionId.newInstance((String)org, (String)((String)otherAttValues.get("name")), (String)((String)otherAttValues.get("rev")));
                DefaultDependencyDescriptor ddd = new DefaultDependencyDescriptor(mrid, false);
                try {
                    String[] confs = ivy.getSettings().getResolver(mrid).getDependency((DependencyDescriptor)ddd, data).getDescriptor().getConfigurationsNames();
                    ArrayList<String> ret = new ArrayList<String>(Arrays.asList(confs));
                    ret.add("*");
                    return ret.toArray(new String[ret.size()]);
                }
                catch (ParseException e) {
                    IvyModuleDescriptorModel.this.getSettings().logError("The dependencies of " + mrid + " could not be parsed", e);
                    return new String[]{"*"};
                }
            }
        }));
        conf3.addChildIvyTag(mapped);
        this.addTag(mapped);
        String[] matcherNames = new String[]{};
        Ivy ivy = this.getIvy();
        if (ivy != null) {
            matcherNames = ivy.getSettings().getMatcherNames().toArray(new String[0]);
        }
        ListValueProvider matcherNamesProvider = new ListValueProvider(matcherNames);
        IvyTag artifact2 = new IvyTag("artifact", "defines artifacts restriction \nuse only if you do not control dependency ivy file");
        artifact2.addAttribute(new IvyTagAttribute("name", "the name of an artifact of the \ndependency module to add to the include list, \nor a regexp matching this name", false));
        artifact2.addAttribute(new IvyTagAttribute("type", "the type of the artifact of the \ndependency module to add to the include list, \nor a regexp matching this name", false, new ListValueProvider(this.getDefault("type"))));
        artifact2.addAttribute(new IvyTagAttribute("ext", "the extension of the artifact of the \ndependency module to add to the include list, \nor a regexp matching this name", false, new ListValueProvider(this.getDefault("ext"))));
        artifact2.addAttribute(new IvyTagAttribute("url", "an url where this artifact can be found \nif it isn't present at the standard \nlocation in the repository", false));
        artifact2.addAttribute(new IvyTagAttribute("conf", "comma separated list of the master configurations \nin which this artifact should be included. \n'*' wildcard can be used to designate all configurations of this module", false, masterConfsValueProvider));
        IvyTag conf4 = new IvyTag("conf", "configuration in which the artifact should be included");
        conf4.addAttribute(new IvyTagAttribute("name", "the name of the master configuration in which \nthe enclosing artifact should be included", true, masterConfValueProvider));
        allConf.add(conf4);
        artifact2.addChildIvyTag(conf4);
        this.addTag(artifact2);
        IvyTag include = new IvyTag("include", "defines artifacts restriction \nuse only if you do not control dependency ivy file");
        include.addAttribute(new IvyTagAttribute("name", "the name of an artifact of the \ndependency module to add to the include list, \nor a regexp matching this name", false));
        include.addAttribute(new IvyTagAttribute("type", "the type of the artifact of the \ndependency module to add to the include list, \nor a regexp matching this name", false, new ListValueProvider(this.getDefault("type"))));
        include.addAttribute(new IvyTagAttribute("ext", "the extension of the artifact of the \ndependency module to add to the include list, \nor a regexp matching this name", false, new ListValueProvider(this.getDefault("ext"))));
        include.addAttribute(new IvyTagAttribute("matcher", "the matcher to use to match the modules to include", false, matcherNamesProvider));
        include.addAttribute(new IvyTagAttribute("conf", "comma separated list of the master configurations \nin which this artifact should be included. \n'*' wildcard can be used to designate all configurations of this module", false, masterConfsValueProvider));
        IvyTag conf5 = new IvyTag("conf", "configuration in which the artifact should be included");
        conf5.addAttribute(new IvyTagAttribute("name", "the name of the master configuration in which \nthe enclosing artifact should be included", true, masterConfValueProvider));
        include.addChildIvyTag(conf5);
        this.addTag(include);
        allConf.add(conf5);
        IvyTag exclude = new IvyTag("exclude", "defines artifacts restriction \nuse only if you do not control dependency ivy file");
        exclude.addAttribute(new IvyTagAttribute("org", "the organisation of the dependency \nmodule or artifact to exclude, \nor a pattern matching this organisation", false));
        exclude.addAttribute(new IvyTagAttribute("module", "the name of the dependency \nmodule or the artifact to exclude, \nor a pattern matching this module name", false));
        exclude.addAttribute(new IvyTagAttribute("name", "the name of an artifact of the \ndependency module to add to the exclude list, \nor a pattern matching this name", false));
        exclude.addAttribute(new IvyTagAttribute("type", "the type of the artifact of the \ndependency module to add to the exclude list, \nor a pattern matching this name", false, new ListValueProvider(this.getDefault("type"))));
        exclude.addAttribute(new IvyTagAttribute("ext", "the extension of the artifact of the \ndependency module to add to the exclude list, \nor a pattern matching this name", false, new ListValueProvider(this.getDefault("ext"))));
        exclude.addAttribute(new IvyTagAttribute("matcher", "the matcher to use to match the modules to include", false, matcherNamesProvider));
        exclude.addAttribute(new IvyTagAttribute("conf", "comma separated list of the master configurations \nin which this artifact should be excluded. \n'*' wildcard can be used to designate all configurations of this module", false, masterConfsValueProvider));
        IvyTag conf6 = new IvyTag("conf", "configuration in which the artifact should be excluded");
        conf6.addAttribute(new IvyTagAttribute("name", "the name of the master configuration in which \nthe enclosing artifact should be excluded", true, masterConfValueProvider));
        allConf.add(conf6);
        exclude.addChildIvyTag(conf6);
        this.addTag(exclude);
        dependency.addChildIvyTag(conf3);
        dependency.addChildIvyTag(artifact2);
        dependency.addChildIvyTag(include);
        dependency.addChildIvyTag(exclude);
        dependencies.addChildIvyTag(dependency);
        ivyTag.addChildIvyTag(dependencies);
        this.addTag(dependency);
        this.addTag(dependencies);
        IvyTag conflicts = new IvyTag("conflicts", "conflicts managers definition section");
        IvyTag manager = new IvyTag("manager", "declares a conflict manager for this module");
        manager.addAttribute(new IvyTagAttribute("org", "the name, or a regexp matching the name of organisation \nto which this conflict manager should apply", false));
        manager.addAttribute(new IvyTagAttribute("module", "the name, or a regexp matching the name of module \nto which this conflict manager should apply", false));
        manager.addAttribute(new IvyTagAttribute("name", "the name of the conflict manager to use", false));
        manager.addAttribute(new IvyTagAttribute("rev", "a comma separated list of revisions this conflict manager should select", false));
        manager.addAttribute(new IvyTagAttribute("matcher", "the matcher to use to match the modules for which \nthe conflict manager should be used", false));
        conflicts.addChildIvyTag(manager);
        ivyTag.addChildIvyTag(conflicts);
        this.addTag(conflicts);
        this.addTag(manager);
    }

    protected String getRootIvyTagName() {
        return "ivy-module";
    }

    List listDependencyTokenValues(String att, IvyFile ivyfile) {
        Map allAttsValues = ivyfile.getAllAttsValues();
        String org = ((IvyModuleDescriptorFile)ivyfile).getOrganisation();
        if (org != null && !allAttsValues.containsKey("org")) {
            allAttsValues.put("org", org);
        }
        return this.listDependencyTokenValues(att, allAttsValues);
    }

    private List listDependencyTokenValues(String att, Map otherAttValues) {
        ArrayList<String> ret = new ArrayList<String>();
        Ivy ivy = this.getIvy();
        if (ivy != null) {
            this.replaceToken(otherAttValues, "org", "organisation");
            this.replaceToken(otherAttValues, "name", "module");
            this.replaceToken(otherAttValues, "rev", "revision");
            if (!otherAttValues.containsKey("branch")) {
                otherAttValues.put("branch", ivy.getSettings().getDefaultBranch());
            }
            String stdAtt = this.standardiseDependencyAttribute(att);
            otherAttValues.remove(stdAtt);
            String[] revs = ivy.listTokenValues(stdAtt, otherAttValues);
            if (revs != null) {
                ret.addAll(Arrays.asList(revs));
            }
        }
        return ret;
    }

    private void replaceToken(Map otherAttValues, String oldToken, String newToken) {
        String val = (String)otherAttValues.remove(oldToken);
        if (val != null) {
            otherAttValues.put(newToken, val);
        }
    }

    private String standardiseDependencyAttribute(String att) {
        if ("org".equals(att)) {
            return "organisation";
        }
        if ("name".equals(att)) {
            return "module";
        }
        if ("rev".equals(att)) {
            return "revision";
        }
        return att;
    }

    public IvyFile newIvyFile(String name, String content, int documentOffset) {
        return new IvyModuleDescriptorFile(this.getSettings(), name, content, documentOffset);
    }
}

