/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.cpcontainer;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerConfiguration;
import org.apache.ivyde.eclipse.cp.RetrieveSetup;
import org.apache.ivyde.internal.eclipse.IvyDEMessage;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerMapper;
import org.apache.ivyde.internal.eclipse.resolve.IvyResolver;
import org.apache.ivyde.internal.eclipse.resolve.ResolveResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;

public class ClasspathEntriesResolver
extends IvyResolver {
    private final IvyClasspathContainerConfiguration conf;
    private IClasspathEntry[] classpathEntries = null;
    private ResolveReport resolveReport;

    public ClasspathEntriesResolver(IvyClasspathContainerImpl ivycp, boolean usePreviousResolveIfExist) {
        super(ivycp.getConf().getIvyXmlPath(), ivycp.getConf().getConfs(), ivycp.getConf().getJavaProject() == null ? null : ivycp.getConf().getJavaProject().getProject());
        this.conf = ivycp.getConf();
        this.setUsePreviousResolveIfExist(ivycp.getConf().getInheritedAdvancedSetup().isUseExtendedResolveId());
        this.setUsePreviousResolveIfExist(usePreviousResolveIfExist);
        this.setTransitiveResolve(this.conf.getInheritedClasspathSetup().isTransitiveResolve());
        if (this.conf.getInheritedClasspathSetup().isRetrievedClasspath()) {
            RetrieveSetup setup = this.conf.getInheritedClasspathSetup().getRetrieveSetup();
            this.setRetrievePattern(setup.getRetrievePattern());
            this.setRetrieveSync(setup.isRetrieveSync());
            this.setRetrieveTypes(setup.getRetrieveTypes());
        }
    }

    protected void postResolveOrRefresh(Ivy ivy, ModuleDescriptor md, ResolveResult resolveResult, IProgressMonitor monitor) throws IOException {
        IvyClasspathContainerMapper mapper = new IvyClasspathContainerMapper(monitor, ivy, this.conf, resolveResult);
        this.warnIfDuplicates(ivy, mapper, resolveResult.getArtifactReports());
        this.classpathEntries = mapper.map();
        this.resolveReport = resolveResult.getReport();
    }

    public IClasspathEntry[] getClasspathEntries() {
        return this.classpathEntries;
    }

    public ResolveReport getResolveReport() {
        return this.resolveReport;
    }

    private void warnIfDuplicates(Ivy ivy, IvyClasspathContainerMapper mapper, Set artifactReports) {
        ArtifactDownloadReport[] reports = artifactReports.toArray(new ArtifactDownloadReport[0]);
        HashSet<ModuleId> duplicates = new HashSet<ModuleId>();
        int i = 0;
        while (i < reports.length - 1) {
            if (mapper.accept(reports[i].getArtifact())) {
                ModuleRevisionId mrid1 = reports[i].getArtifact().getModuleRevisionId();
                int j = i + 1;
                while (j < reports.length) {
                    if (mapper.accept(reports[j].getArtifact())) {
                        ModuleRevisionId mrid2 = reports[j].getArtifact().getModuleRevisionId();
                        if (mrid1.getModuleId().equals((Object)mrid2.getModuleId()) && !mrid1.getRevision().equals(mrid2.getRevision())) {
                            duplicates.add(mrid1.getModuleId());
                            break;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (duplicates.isEmpty()) {
            return;
        }
        StringBuffer buffer = new StringBuffer("There are some duplicates entries due to conflicts between the resolved configurations " + this.conf.getConfs());
        buffer.append(":\n  - ");
        Iterator it = duplicates.iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
            if (!it.hasNext()) continue;
            buffer.append("\n  - ");
        }
        IvyDEMessage.warn(buffer.toString());
    }
}

