/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.cpcontainer;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import org.apache.ivyde.eclipse.IvyNatureHelper;
import org.apache.ivyde.eclipse.cp.AdvancedSetup;
import org.apache.ivyde.eclipse.cp.ClasspathSetup;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerConfiguration;
import org.apache.ivyde.eclipse.cp.MappingSetup;
import org.apache.ivyde.eclipse.cp.RetrieveSetup;
import org.apache.ivyde.eclipse.cp.SettingsSetup;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathUtil;
import org.apache.ivyde.internal.eclipse.retrieve.RetrieveSetupManager;
import org.apache.ivyde.internal.eclipse.retrieve.StandaloneRetrieveSetup;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;

public final class IvyClasspathContainerConfAdapter {
    private static final String UTF8_ERROR = "The UTF-8 encoding support is required is decode the path of the container.";
    private static final String PROJECT_SCHEME_PREFIX = "project://";
    private static final int PROJECT_SCHEME_PREFIX_LENGTH = "project://".length();

    private IvyClasspathContainerConfAdapter() {
    }

    public static void load(IvyClasspathContainerConfiguration conf, IPath path, IClasspathAttribute[] attributes) {
        if (path.segmentCount() > 2) {
            IvyClasspathContainerConfAdapter.loadV0(conf, path);
        } else {
            IvyClasspathContainerConfAdapter.loadV1(conf, path);
        }
        conf.setAttributes(attributes);
        if (conf.getJavaProject() != null) {
            IvyNatureHelper.addNature(conf.getJavaProject().getProject());
        }
    }

    private static void loadV0(IvyClasspathContainerConfiguration conf, IPath path) {
        conf.setIvyXmlPath(path.removeFirstSegments(1).removeLastSegments(1).toString());
        List<String> confs = IvyClasspathUtil.split(path.lastSegment());
        if (confs.isEmpty()) {
            confs = Collections.singletonList("*");
        }
        conf.setConfs(confs);
    }

    private static void loadV1(IvyClasspathContainerConfiguration conf, IPath path) {
        SettingsSetup settingsSetup = conf.getIvySettingsSetup();
        ClasspathSetup classpathSetup = conf.getClasspathSetup();
        MappingSetup mappingSetup = conf.getMappingSetup();
        AdvancedSetup advancedSetup = conf.getAdvancedSetup();
        String url = path.segment(1).substring(1);
        String[] parameters = url.split("&");
        conf.setAdvancedProjectSpecific(false);
        conf.setSettingsProjectSpecific(false);
        String ivyXmlPath = "ivy.xml";
        boolean doStandaloneRetrieve = false;
        boolean isRetrieveProjectSpecific = false;
        RetrieveSetup standaloneRetrieveSetup = new RetrieveSetup();
        int i = 0;
        while (i < parameters.length) {
            String[] parameter = parameters[i].split("=");
            if (parameter != null && parameter.length != 0) {
                String value;
                try {
                    value = parameter.length > 1 ? URLDecoder.decode(parameter[1], "UTF-8") : "";
                }
                catch (UnsupportedEncodingException e) {
                    IvyPlugin.logError(UTF8_ERROR, e);
                    throw new RuntimeException(UTF8_ERROR, e);
                }
                if (parameter[0].equals("project")) {
                    if (conf.getJavaProject() == null && value.trim().length() != 0) {
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        IProject project = root.getProject(value.trim());
                        IJavaProject javaProject = JavaCore.create((IProject)project);
                        conf.setProject(javaProject);
                    }
                } else if (parameter[0].equals("ivyXmlPath")) {
                    ivyXmlPath = value;
                    conf.setIvyXmlPath(value);
                } else if (parameter[0].equals("confs")) {
                    List<String> confs = IvyClasspathUtil.split(value);
                    if (confs.isEmpty()) {
                        confs = Collections.singletonList("*");
                    }
                    conf.setConfs(confs);
                } else if (parameter[0].equals("ivySettingsPath")) {
                    settingsSetup.setIvySettingsPath(IvyClasspathContainerConfAdapter.readOldSettings(conf, value));
                    conf.setSettingsProjectSpecific(true);
                } else if (parameter[0].equals("loadSettingsOnDemand")) {
                    settingsSetup.setLoadSettingsOnDemand(Boolean.valueOf(value));
                    conf.setSettingsProjectSpecific(true);
                } else if (parameter[0].equals("ivyUserDir")) {
                    settingsSetup.setIvyUserDir(value);
                    conf.setSettingsProjectSpecific(true);
                } else if (parameter[0].equals("propertyFiles")) {
                    settingsSetup.setPropertyFiles(IvyClasspathUtil.split(value));
                    conf.setSettingsProjectSpecific(true);
                } else if (parameter[0].equals("acceptedTypes")) {
                    classpathSetup.setAcceptedTypes(IvyClasspathUtil.split(value));
                    conf.setClassthProjectSpecific(true);
                } else if (parameter[0].equals("sourceTypes")) {
                    mappingSetup.setSourceTypes(IvyClasspathUtil.split(value));
                    conf.setMappingProjectSpecific(true);
                } else if (parameter[0].equals("javadocTypes")) {
                    mappingSetup.setJavadocTypes(IvyClasspathUtil.split(value));
                    conf.setMappingProjectSpecific(true);
                } else if (parameter[0].equals("sourceSuffixes")) {
                    mappingSetup.setSourceSuffixes(IvyClasspathUtil.split(value));
                    conf.setMappingProjectSpecific(true);
                } else if (parameter[0].equals("javadocSuffixes")) {
                    mappingSetup.setJavadocSuffixes(IvyClasspathUtil.split(value));
                    conf.setMappingProjectSpecific(true);
                } else if (parameter[0].equals("alphaOrder")) {
                    classpathSetup.setAlphaOrder(Boolean.valueOf(value));
                    conf.setClassthProjectSpecific(true);
                } else if (parameter[0].equals("resolveInWorkspace")) {
                    classpathSetup.setResolveInWorkspace(Boolean.valueOf(value));
                    conf.setClassthProjectSpecific(true);
                } else if (parameter[0].equals("transitiveResolve")) {
                    classpathSetup.setTransitiveResolve(Boolean.valueOf(value));
                    conf.setClassthProjectSpecific(true);
                } else if (parameter[0].equals("readOSGiMetadata")) {
                    classpathSetup.setReadOSGiMetadata(Boolean.valueOf(value));
                    conf.setClassthProjectSpecific(true);
                } else if (parameter[0].equals("resolveBeforeLaunch")) {
                    advancedSetup.setResolveBeforeLaunch(Boolean.valueOf(value));
                    conf.setAdvancedProjectSpecific(true);
                } else if (parameter[0].equals("retrievedClasspath")) {
                    classpathSetup.setRetrievedClasspath(Boolean.valueOf(value));
                    conf.setClassthProjectSpecific(true);
                } else if (parameter[0].equals("retrievedClasspathPattern")) {
                    classpathSetup.getRetrieveSetup().setRetrievePattern(value);
                    conf.setClassthProjectSpecific(true);
                } else if (parameter[0].equals("retrievedClasspathSync")) {
                    classpathSetup.getRetrieveSetup().setRetrieveSync(Boolean.valueOf(value));
                    conf.setClassthProjectSpecific(true);
                } else if (parameter[0].equals("retrievedClasspathTypes")) {
                    classpathSetup.getRetrieveSetup().setRetrieveTypes(value);
                    conf.setClassthProjectSpecific(true);
                } else if (parameter[0].equals("mapIfOnlyOneSource")) {
                    mappingSetup.setMapIfOnlyOneSource(Boolean.valueOf(value));
                    conf.setMappingProjectSpecific(true);
                } else if (parameter[0].equals("mapIfOnlyOneJavadoc")) {
                    mappingSetup.setMapIfOnlyOneJavadoc(Boolean.valueOf(value));
                    conf.setMappingProjectSpecific(true);
                } else if (parameter[0].equals("doRetrieve")) {
                    doStandaloneRetrieve = Boolean.valueOf(value);
                    isRetrieveProjectSpecific = true;
                } else if (parameter[0].equals("retrievePattern")) {
                    standaloneRetrieveSetup.setRetrievePattern(value);
                    isRetrieveProjectSpecific = true;
                } else if (parameter[0].equals("retrieveSync")) {
                    standaloneRetrieveSetup.setRetrieveSync(Boolean.valueOf(value));
                    isRetrieveProjectSpecific = true;
                } else if (parameter[0].equals("retrieveConfs")) {
                    standaloneRetrieveSetup.setRetrieveConfs(value);
                    isRetrieveProjectSpecific = true;
                } else if (parameter[0].equals("retrieveTypes")) {
                    standaloneRetrieveSetup.setRetrieveTypes(value);
                    isRetrieveProjectSpecific = true;
                } else if (parameter[0].equals("useExtendedResolveId")) {
                    advancedSetup.setUseExtendedResolveId(Boolean.valueOf(value));
                    conf.setAdvancedProjectSpecific(true);
                }
            }
            ++i;
        }
        if (conf.isAdvancedProjectSpecific()) {
            IvyClasspathContainerConfAdapter.checkNonNullConf(conf);
        }
        IvyClasspathContainerConfAdapter.convertOldRetrieveConf(conf, isRetrieveProjectSpecific, doStandaloneRetrieve, standaloneRetrieveSetup, settingsSetup, ivyXmlPath);
    }

    private static void convertOldRetrieveConf(IvyClasspathContainerConfiguration conf, boolean isRetrieveProjectSpecific, boolean doStandaloneRetrieve, RetrieveSetup retrieveSetup, SettingsSetup settingsSetup, String ivyXmlPath) {
        List retrieveSetups;
        if (conf.getJavaProject() == null) {
            return;
        }
        StandaloneRetrieveSetup setup = new StandaloneRetrieveSetup();
        setup.setName("dependencies");
        setup.setSettingsSetup(settingsSetup);
        setup.setIvyXmlPath(ivyXmlPath);
        setup.setSettingsProjectSpecific(conf.isSettingsProjectSpecific());
        setup.setProject(conf.getJavaProject().getProject());
        IPreferenceStore prefStore = IvyPlugin.getDefault().getPreferenceStore();
        if (isRetrieveProjectSpecific) {
            if (!doStandaloneRetrieve) {
                return;
            }
        } else {
            if (!prefStore.getBoolean("do.retrieve")) {
                return;
            }
            retrieveSetup = new RetrieveSetup();
            retrieveSetup.setRetrieveConfs(prefStore.getString("retrieve.confs"));
            retrieveSetup.setRetrievePattern(prefStore.getString("retrieve.pattern"));
            retrieveSetup.setRetrieveSync(prefStore.getBoolean("retrieve.sync"));
            retrieveSetup.setRetrieveTypes(prefStore.getString("retrieve.types"));
        }
        if (retrieveSetup.getRetrievePattern() == null) {
            retrieveSetup.setRetrievePattern(prefStore.getString("retrieve.pattern"));
        }
        setup.setRetrieveSetup(retrieveSetup);
        RetrieveSetupManager manager = IvyPlugin.getDefault().getRetrieveSetupManager();
        IProject project = conf.getJavaProject().getProject();
        try {
            retrieveSetups = manager.getSetup(project);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        retrieveSetups.add(setup);
        try {
            manager.save(project, retrieveSetups);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String readOldSettings(IvyClasspathContainerConfiguration conf, String value) {
        if (conf.getJavaProject() == null) {
            return value;
        }
        if (value.startsWith(PROJECT_SCHEME_PREFIX)) {
            String path = value.substring(PROJECT_SCHEME_PREFIX_LENGTH);
            if (path.startsWith("/")) {
                path = String.valueOf(conf.getJavaProject().getProject().getName()) + path;
            }
            return "${workspace_loc:" + path + "}";
        }
        if (value.startsWith("file://./") || value.startsWith("file:./")) {
            value = value.charAt(5) == '/' ? value.substring(8) : value.substring(6);
            return "${workspace_loc:" + conf.getJavaProject().getProject().getName() + value + "}";
        }
        return value;
    }

    private static void checkNonNullConf(IvyClasspathContainerConfiguration conf) {
        ClasspathSetup classpathSetup = conf.getClasspathSetup();
        ClasspathSetup prefStoreClasspathSetup = IvyPlugin.getPreferenceStoreHelper().getClasspathSetup();
        MappingSetup mappingSetup = conf.getMappingSetup();
        SettingsSetup settingsSetup = conf.getIvySettingsSetup();
        MappingSetup prefStoreMappingSetup = IvyPlugin.getPreferenceStoreHelper().getMappingSetup();
        if (settingsSetup.getRawIvyUserDir() == null) {
            settingsSetup.setIvyUserDir(IvyPlugin.getPreferenceStoreHelper().getSettingsSetup().getRawIvyUserDir());
        }
        if (settingsSetup.getRawPropertyFiles() == null) {
            settingsSetup.setPropertyFiles(IvyPlugin.getPreferenceStoreHelper().getSettingsSetup().getRawPropertyFiles());
        }
        if (classpathSetup.getAcceptedTypes() == null) {
            classpathSetup.setAcceptedTypes(prefStoreClasspathSetup.getAcceptedTypes());
        }
        if (mappingSetup.getSourceTypes() == null) {
            mappingSetup.setSourceTypes(prefStoreMappingSetup.getSourceTypes());
        }
        if (mappingSetup.getJavadocTypes() == null) {
            mappingSetup.setJavadocTypes(prefStoreMappingSetup.getJavadocTypes());
        }
        if (mappingSetup.getSourceSuffixes() == null) {
            mappingSetup.setSourceSuffixes(prefStoreMappingSetup.getSourceSuffixes());
        }
        if (mappingSetup.getJavadocSuffixes() == null) {
            mappingSetup.setJavadocSuffixes(prefStoreMappingSetup.getJavadocSuffixes());
        }
    }

    public static IPath getPath(IvyClasspathContainerConfiguration conf) {
        StringBuffer path = new StringBuffer();
        path.append('?');
        IJavaProject javaProject = conf.getJavaProject();
        try {
            Object setup;
            path.append("project=");
            if (javaProject != null) {
                path.append(URLEncoder.encode(javaProject.getElementName(), "UTF-8"));
            }
            path.append("&ivyXmlPath=");
            path.append(URLEncoder.encode(conf.getIvyXmlPath(), "UTF-8"));
            IvyClasspathContainerConfAdapter.append(path, "confs", conf.getConfs());
            if (conf.isSettingsProjectSpecific()) {
                setup = conf.getIvySettingsSetup();
                IvyClasspathContainerConfAdapter.append(path, "ivySettingsPath", ((SettingsSetup)setup).getRawIvySettingsPath());
                IvyClasspathContainerConfAdapter.append(path, "loadSettingsOnDemand", ((SettingsSetup)setup).isLoadSettingsOnDemand());
                IvyClasspathContainerConfAdapter.append(path, "ivyUserDir", ((SettingsSetup)setup).getRawIvyUserDir());
                IvyClasspathContainerConfAdapter.append(path, "propertyFiles", ((SettingsSetup)setup).getRawPropertyFiles());
            }
            if (conf.isClassthProjectSpecific()) {
                setup = conf.getClasspathSetup();
                IvyClasspathContainerConfAdapter.append(path, "acceptedTypes", ((ClasspathSetup)setup).getAcceptedTypes());
                IvyClasspathContainerConfAdapter.append(path, "alphaOrder", ((ClasspathSetup)setup).isAlphaOrder());
                IvyClasspathContainerConfAdapter.append(path, "resolveInWorkspace", ((ClasspathSetup)setup).isResolveInWorkspace());
                IvyClasspathContainerConfAdapter.append(path, "transitiveResolve", ((ClasspathSetup)setup).isTransitiveResolve());
                IvyClasspathContainerConfAdapter.append(path, "readOSGiMetadata", ((ClasspathSetup)setup).isReadOSGiMetadata());
                IvyClasspathContainerConfAdapter.append(path, "retrievedClasspath", ((ClasspathSetup)setup).isRetrievedClasspath());
                if (((ClasspathSetup)setup).isRetrievedClasspath()) {
                    RetrieveSetup retrieveSetup = ((ClasspathSetup)setup).getRetrieveSetup();
                    IvyClasspathContainerConfAdapter.append(path, "retrievedClasspathPattern", retrieveSetup.getRetrievePattern());
                    IvyClasspathContainerConfAdapter.append(path, "retrievedClasspathSync", retrieveSetup.isRetrieveSync());
                    IvyClasspathContainerConfAdapter.append(path, "retrievedClasspathTypes", retrieveSetup.getRetrieveTypes());
                }
            }
            if (conf.isMappingProjectSpecific()) {
                setup = conf.getMappingSetup();
                IvyClasspathContainerConfAdapter.append(path, "sourceTypes", ((MappingSetup)setup).getSourceTypes());
                IvyClasspathContainerConfAdapter.append(path, "javadocTypes", ((MappingSetup)setup).getJavadocTypes());
                IvyClasspathContainerConfAdapter.append(path, "sourceSuffixes", ((MappingSetup)setup).getSourceSuffixes());
                IvyClasspathContainerConfAdapter.append(path, "javadocSuffixes", ((MappingSetup)setup).getJavadocSuffixes());
                IvyClasspathContainerConfAdapter.append(path, "mapIfOnlyOneSource", ((MappingSetup)setup).isMapIfOnlyOneSource());
                IvyClasspathContainerConfAdapter.append(path, "mapIfOnlyOneJavadoc", ((MappingSetup)setup).isMapIfOnlyOneJavadoc());
            }
            if (conf.isAdvancedProjectSpecific()) {
                setup = conf.getAdvancedSetup();
                IvyClasspathContainerConfAdapter.append(path, "resolveBeforeLaunch", ((AdvancedSetup)setup).isResolveBeforeLaunch());
                IvyClasspathContainerConfAdapter.append(path, "useExtendedResolveId", ((AdvancedSetup)setup).isUseExtendedResolveId());
            }
        }
        catch (UnsupportedEncodingException e) {
            IvyPlugin.logError(UTF8_ERROR, e);
            throw new RuntimeException(UTF8_ERROR, e);
        }
        return new Path("org.apache.ivyde.eclipse.cpcontainer.IVYDE_CONTAINER").append(path.toString());
    }

    private static void append(StringBuffer path, String name, String value) throws UnsupportedEncodingException {
        path.append('&');
        path.append(name);
        path.append('=');
        path.append(URLEncoder.encode(value, "UTF-8"));
    }

    private static void append(StringBuffer path, String name, List values) throws UnsupportedEncodingException {
        IvyClasspathContainerConfAdapter.append(path, name, IvyClasspathUtil.concat(values));
    }

    private static void append(StringBuffer path, String name, boolean value) throws UnsupportedEncodingException {
        IvyClasspathContainerConfAdapter.append(path, name, Boolean.toString(value));
    }
}

