/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.cpcontainer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerHelper;
import org.apache.ivyde.internal.eclipse.IvyDEMessage;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerSerializer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Display;

public class IvyClasspathInitializer
extends ClasspathContainerInitializer {
    public static final int ON_STARTUP_NOTHING = 0;
    public static final int ON_STARTUP_REFRESH = 1;
    public static final int ON_STARTUP_RESOLVE = 2;

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        if (IvyClasspathContainerHelper.isIvyClasspathContainer(containerPath)) {
            IvyDEMessage.info("Initializing container " + containerPath);
            IClasspathContainer container = null;
            try {
                container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)project);
            }
            catch (JavaModelException ex) {
                IvyPlugin.logError("Unable to get container for " + containerPath.toString(), ex);
                return;
            }
            try {
                IClasspathAttribute[] attributes;
                boolean refresh = false;
                IvyClasspathContainerImpl ivycp = null;
                IClasspathEntry entry = IvyClasspathContainerHelper.getEntry(containerPath, project);
                if (entry != null) {
                    attributes = entry.getExtraAttributes();
                    entry.isExported();
                } else {
                    attributes = new IClasspathAttribute[]{};
                }
                if (container instanceof IvyClasspathContainerImpl) {
                    IvyDEMessage.debug("Container already configured");
                    ivycp = (IvyClasspathContainerImpl)container;
                } else if (container == null) {
                    IvyDEMessage.debug("No saved container");
                    IvyClasspathContainerSerializer serializer = IvyPlugin.getDefault().getIvyClasspathContainerSerializer();
                    Map ivycps = serializer.read(project);
                    if (ivycps != null) {
                        IvyDEMessage.debug("Found serialized containers");
                        ivycp = (IvyClasspathContainerImpl)ivycps.get(containerPath);
                    }
                    if (ivycp == null) {
                        IvyDEMessage.debug("No serialized containers match the expected container path");
                        ivycp = new IvyClasspathContainerImpl(project, containerPath, new IClasspathEntry[0], attributes);
                        refresh = true;
                    }
                } else {
                    IvyDEMessage.debug("Loading from a saved container");
                    ivycp = new IvyClasspathContainerImpl(project, containerPath, container.getClasspathEntries(), attributes);
                }
                IvyDEMessage.verbose("Setting container in JDT model");
                JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{ivycp}, null);
                int startupMode = IvyPlugin.getPreferenceStoreHelper().getResolveOnStartup();
                if (startupMode == 0) {
                    if (!refresh) {
                        IvyDEMessage.verbose("Doing nothing on startup");
                        return;
                    }
                } else {
                    boolean bl = refresh = startupMode == 1;
                }
                if (refresh) {
                    IvyDEMessage.info("Scheduling a refresh of the container");
                } else {
                    IvyDEMessage.info("Scheduling a resolve of the container");
                }
                ivycp.launchResolve(refresh, null);
            }
            catch (Exception ex) {
                Status status = new Status(4, "org.apache.ivyde.eclipse", 0, "Unable to set container for " + containerPath.toString(), (Throwable)ex);
                throw new CoreException((IStatus)status);
            }
        }
    }

    private void updateIvyDEContainerPath(final IJavaProject project, final IClasspathEntry entry, final IClasspathAttribute[] attributes, final boolean exported, final IPath updatedPath) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    IClasspathEntry newEntry = JavaCore.newContainerEntry((IPath)updatedPath, null, (IClasspathAttribute[])attributes, (boolean)exported);
                    IClasspathEntry[] entries = project.getRawClasspath();
                    ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>(Arrays.asList(entries));
                    int i = 0;
                    while (i < newEntries.size()) {
                        IClasspathEntry e = (IClasspathEntry)newEntries.get(i);
                        if (e == entry) {
                            newEntries.set(i, newEntry);
                            break;
                        }
                        ++i;
                    }
                    entries = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
                    project.setRawClasspath(entries, project.getOutputLocation(), null);
                }
                catch (JavaModelException e) {
                    IvyPlugin.logError("Unable to update the container path", e);
                }
            }
        });
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(final IPath containerPath, final IJavaProject project, final IClasspathContainer containerSuggestion) throws CoreException {
        new Job("IvyDE attachement updater"){

            protected IStatus run(IProgressMonitor monitor) {
                IvyPlugin.getDefault().getIvyAttachementManager().updateAttchements(project, containerPath, containerSuggestion);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        return containerPath;
    }
}

