/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class AbstractSetupTab {
    private Button projectSpecificButton;
    private Link mainGeneralSettingsLink;
    private Composite setupEditor;

    public AbstractSetupTab(final TabFolder tabs, String title, final String preferencePageId, IProject project) {
        TabItem tab = new TabItem(tabs, 0);
        tab.setText(title);
        Composite composite = new Composite((Composite)tabs, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite headerComposite = new Composite(composite, 0);
        headerComposite.setLayout((Layout)new GridLayout(2, false));
        headerComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.projectSpecificButton = new Button(headerComposite, 32);
        this.projectSpecificButton.setText("Enable project specific settings");
        this.projectSpecificButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractSetupTab.this.projectSpecificChanged();
            }
        });
        this.mainGeneralSettingsLink = new Link(headerComposite, 0);
        this.mainGeneralSettingsLink.setFont(headerComposite.getFont());
        this.mainGeneralSettingsLink.setText("<A>Configure Workspace Settings...</A>");
        this.mainGeneralSettingsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)tabs.getShell(), (String)preferencePageId, null, null);
                dialog.open();
            }
        });
        this.mainGeneralSettingsLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Label horizontalLine = new Label(headerComposite, 258);
        horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite configComposite = new Composite(composite, 0);
        configComposite.setLayout((Layout)new GridLayout());
        configComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setupEditor = this.createSetupEditor(configComposite, project);
        tab.setControl((Control)composite);
    }

    protected abstract Composite createSetupEditor(Composite var1, IProject var2);

    public void init(boolean isProjectSpecific) {
        if (isProjectSpecific) {
            this.projectSpecificButton.setSelection(true);
        } else {
            this.projectSpecificButton.setSelection(false);
            this.setupEditor.setEnabled(false);
        }
    }

    public boolean isProjectSpecific() {
        return this.projectSpecificButton.getSelection();
    }

    public void projectSpecificChanged() {
        boolean projectSpecific = this.projectSpecificButton.getSelection();
        this.mainGeneralSettingsLink.setEnabled(!projectSpecific);
        this.setupEditor.setEnabled(projectSpecific);
    }
}

