/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui.editors;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivyde.internal.eclipse.XMLHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.XMLContentDescriber;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IvySettingsContentDescriber
extends XMLContentDescriber
implements IExecutableExtension {
    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public int describe(InputStream input, IContentDescription description) throws IOException {
        if (super.describe(input, description) == 0) {
            return 0;
        }
        input.reset();
        return this.checkCriteria(new InputSource(input));
    }

    public int describe(Reader input, IContentDescription description) throws IOException {
        if (super.describe(input, description) == 0) {
            return 0;
        }
        input.reset();
        return this.checkCriteria(new InputSource(input));
    }

    private int checkCriteria(InputSource contents) throws IOException {
        IvySettingsHandler ivySettingsHandler = new IvySettingsHandler();
        try {
            XMLHelper.parse(contents, null, ivySettingsHandler, null, false);
        }
        catch (SAXException sAXException) {
            return 1;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String message = "Internal Error: XML parser configuration error during content description for Ivy files";
            throw new RuntimeException(message);
        }
        if (ivySettingsHandler.isIvySettings) {
            return 2;
        }
        return 1;
    }

    private static final class IvySettingsHandler
    extends DefaultHandler {
        boolean root = true;
        boolean isIvySettings;

        private IvySettingsHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!this.root) {
                return;
            }
            if ("ivysettings".equals(localName)) {
                this.isIvySettings = true;
            }
            this.root = false;
        }
    }
}

