/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service.xml;

import org.eclipse.epp.internal.mpc.core.service.Marketplace;
import org.eclipse.epp.internal.mpc.core.service.NodeListing;
import org.eclipse.epp.internal.mpc.core.service.xml.NodeContentHandler;
import org.eclipse.epp.internal.mpc.core.service.xml.UnmarshalContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeListingContentHandler<T extends NodeListing>
extends UnmarshalContentHandler {
    protected static final String NS_URI = "";
    private T model;
    private final String rootElementName;

    public NodeListingContentHandler(String rootElementName) {
        this.rootElementName = rootElementName;
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public T getModel() {
        return this.model;
    }

    protected abstract T createModel();

    @Override
    public void startElement(String uri, String localName, Attributes attributes) {
        if (localName.equals(this.getRootElementName())) {
            this.model = this.createModel();
            this.configureModel(this.model, attributes);
        } else if (localName.equals("node")) {
            NodeContentHandler childHandler = new NodeContentHandler();
            childHandler.setParentModel(this.model);
            childHandler.setParentHandler(this);
            childHandler.setUnmarshaller(this.getUnmarshaller());
            this.getUnmarshaller().setCurrentHandler(childHandler);
            childHandler.startElement(uri, localName, attributes);
        }
    }

    protected void configureModel(T model, Attributes attributes) {
        ((NodeListing)model).setCount(this.toInteger(attributes.getValue(NS_URI, "count")));
    }

    @Override
    public boolean endElement(String uri, String localName) throws SAXException {
        if (localName.equals(this.getRootElementName())) {
            if (this.parentModel instanceof Marketplace) {
                Marketplace marketplace = (Marketplace)this.parentModel;
                this.setMarketplaceResult(marketplace, this.model);
            }
            this.getUnmarshaller().setModel(this.model);
            this.model = null;
            this.getUnmarshaller().setCurrentHandler(this.parentHandler);
            if (this.parentHandler != null) {
                this.parentHandler.endElement(uri, localName);
            }
            return true;
        }
        localName.equals("node");
        return false;
    }

    protected abstract void setMarketplaceResult(Marketplace var1, T var2);
}

