/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.server.core.portal.PortalBundleFactory;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class AbstractPortalBundleFactory
implements PortalBundleFactory {
    private String bundleFactoryType;

    @Override
    public IPath canCreateFromPath(Map<String, Object> appServerProperties) {
        Path retval = null;
        String appServerPath = (String)appServerProperties.get("app.server.dir");
        String appServerParentPath = (String)appServerProperties.get("app.server.parent.dir");
        String appServerDeployPath = (String)appServerProperties.get("app.server.deploy.dir");
        String appServerGlobalLibPath = (String)appServerProperties.get("app.server.lib.global.dir");
        String appServerPortalPath = (String)appServerProperties.get("app.server.portal.dir");
        if (!(ServerUtil.verifyPath(appServerPath) && ServerUtil.verifyPath(appServerParentPath) && ServerUtil.verifyPath(appServerDeployPath) && ServerUtil.verifyPath(appServerPortalPath) && ServerUtil.verifyPath(appServerGlobalLibPath))) {
            return retval;
        }
        Path appServerLocation = new Path(appServerPath);
        Path liferayHomelocation = new Path(appServerParentPath);
        if (this.detectBundleDir((IPath)appServerLocation)) {
            retval = appServerLocation;
        } else if (this.detectLiferayHome((IPath)liferayHomelocation)) {
            File[] directories;
            File[] fileArray = directories = FileUtil.getDirectories((File)liferayHomelocation.toFile());
            int n = directories.length;
            int n2 = 0;
            while (n2 < n) {
                File directory = fileArray[n2];
                Path dirPath = new Path(directory.getAbsolutePath());
                if (this.detectBundleDir((IPath)dirPath)) {
                    retval = dirPath;
                    break;
                }
                ++n2;
            }
        }
        return retval;
    }

    @Override
    public IPath canCreateFromPath(IPath location) {
        IPath retval = null;
        if (this.detectBundleDir(location) && this.detectLiferayHome(location.append(".."))) {
            retval = location;
        } else if (this.detectLiferayHome(location)) {
            File[] directories;
            File[] fileArray = directories = FileUtil.getDirectories((File)location.toFile());
            int n = directories.length;
            int n2 = 0;
            while (n2 < n) {
                File directory = fileArray[n2];
                Path dirPath = new Path(directory.getAbsolutePath());
                if (this.detectBundleDir((IPath)dirPath)) {
                    retval = dirPath;
                    break;
                }
                ++n2;
            }
        }
        return retval;
    }

    private boolean detectLiferayHome(IPath path) {
        if (!path.toFile().exists()) {
            return false;
        }
        if (path.append("data").toFile().exists() && path.append("osgi").toFile().exists()) {
            return true;
        }
        return path.append("portal-ext.properties").toFile().exists() || path.append("portal-setup-wizard.properties").toFile().exists();
    }

    protected abstract boolean detectBundleDir(IPath var1);

    @Override
    public String getType() {
        return this.bundleFactoryType;
    }

    public void setBundleFactoryType(String type) {
        this.bundleFactoryType = type;
    }
}

