/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import aQute.remote.api.Agent;
import com.liferay.ide.core.IBundleProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.BundlePublishFullAdd;
import com.liferay.ide.server.core.portal.BundlePublishFullRemove;
import com.liferay.ide.server.core.portal.BundlePublishOperation;
import com.liferay.ide.server.core.portal.BundleSupervisor;
import com.liferay.ide.server.core.portal.PortalServerBehavior;
import com.liferay.ide.server.util.ServerUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.model.PublishTaskDelegate;
import org.osgi.framework.dto.BundleDTO;

public class PortalPublishTask
extends PublishTaskDelegate {
    private void addOperation(Class<? extends BundlePublishOperation> opClass, List<BundlePublishOperation> tasks, IServer server, IModule[] module, BundleSupervisor supervisor, BundleDTO[] existingBundles) {
        for (BundlePublishOperation task : tasks) {
            if (!((Object)((Object)task)).getClass().equals(opClass)) continue;
            task.addModule(module);
            return;
        }
        try {
            BundlePublishOperation op = opClass.getConstructor(IServer.class, IModule[].class, BundleSupervisor.class, BundleDTO[].class).newInstance(new Object[]{server, module, supervisor, existingBundles});
            tasks.add(op);
        }
        catch (Exception e) {
            LiferayServerCore.logError("Unable to add bundle operation", e);
        }
    }

    public PublishOperation[] getTasks(IServer server, int kind, List modules, List kindList) {
        ArrayList<BundlePublishOperation> tasks = new ArrayList<BundlePublishOperation>();
        PortalServerBehavior serverBehavior = (PortalServerBehavior)server.loadAdapter(PortalServerBehavior.class, null);
        BundleDTO[] existingBundles = new BundleDTO[]{};
        BundleSupervisor supervisor = null;
        if (server.getServerState() == 2) {
            supervisor = serverBehavior.getBundleSupervisor();
            try {
                existingBundles = ((Agent)supervisor.getAgent()).getBundles(new long[0]).toArray(new BundleDTO[0]);
            }
            catch (Exception exception) {}
        }
        if (supervisor == null) {
            return tasks.toArray(new PublishOperation[0]);
        }
        if (!CoreUtil.isNullOrEmpty((List)modules)) {
            int size = modules.size();
            int i = 0;
            while (i < size) {
                IModule[] module = (IModule[])modules.get(i);
                Integer deltaKind = (Integer)kindList.get(i);
                block2 : switch (kind) {
                    case 1: 
                    case 2: 
                    case 3: {
                        IProject project = module[0].getProject();
                        switch (deltaKind) {
                            case 1: 
                            case 2: {
                                this.addOperation(BundlePublishFullAdd.class, tasks, server, module, supervisor, existingBundles);
                                break;
                            }
                            case 3: {
                                this.addOperation(BundlePublishFullRemove.class, tasks, server, module, supervisor, existingBundles);
                                break;
                            }
                            case 0: {
                                IBundleProject bundleProject = (IBundleProject)LiferayCore.create(IBundleProject.class, (Object)project);
                                if (bundleProject == null) break block2;
                                try {
                                    if (!this.isUserRedeploy(serverBehavior, module[0]) && ServerUtil.bsnExists(bundleProject.getSymbolicName(), existingBundles)) break block2;
                                    this.addOperation(BundlePublishFullAdd.class, tasks, server, module, supervisor, existingBundles);
                                }
                                catch (CoreException e) {
                                    LiferayServerCore.logError("Unable to get bsn for project " + project.getName(), e);
                                }
                                break block2;
                            }
                            default: {
                                System.out.println("Unhandled deltaKind " + deltaKind);
                                break;
                            }
                        }
                        break;
                    }
                    default: {
                        System.out.println("Unhandled kind " + kind);
                    }
                }
                ++i;
            }
        }
        return tasks.toArray(new PublishOperation[0]);
    }

    public PublishOperation[] getTasks(IServer server, List modules) {
        return super.getTasks(server, modules);
    }

    private boolean isUserRedeploy(PortalServerBehavior serverBehavior, IModule module) {
        if (serverBehavior.getInfo() != null) {
            Object moduleInfo = serverBehavior.getInfo().getAdapter(IModule.class);
            return module.equals(moduleInfo);
        }
        return false;
    }
}

