/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaProjectSourceContainer;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaSourcePathComputer;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class PortalSourcePathComputerDelegate
extends JavaSourcePathComputer {
    public static final String ID = "";

    public String getId() {
        return ID;
    }

    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        ArrayList<ISourceContainer> containers = new ArrayList<ISourceContainer>();
        ISourcePathComputer webprojectComputer = DebugPlugin.getDefault().getLaunchManager().getSourcePathComputer("com.liferay.ide.server.tomcat.portalSourcePathComputer");
        if (webprojectComputer != null) {
            Object[] webcontainers = webprojectComputer.computeSourceContainers(configuration, monitor);
            if (!CoreUtil.isNullOrEmpty((Object[])webcontainers)) {
                Collections.addAll(containers, webcontainers);
            }
        } else {
            Object[] defaultContainers = super.computeSourceContainers(configuration, monitor);
            if (!CoreUtil.isNullOrEmpty((Object[])defaultContainers)) {
                Collections.addAll(containers, defaultContainers);
            }
        }
        this.collectPortalContainers(containers, configuration, monitor);
        return containers.toArray(new ISourceContainer[0]);
    }

    private void collectPortalContainers(List<ISourceContainer> collect, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        HashMap<IProject, ISourceContainer> containers = new HashMap<IProject, ISourceContainer>();
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        IModule[] modules = server.getModules();
        int i = 0;
        while (i < modules.length) {
            IProject project = modules[i].getProject();
            ILiferayProject lrproject = LiferayCore.create((Object)project);
            if (lrproject != null && lrproject.getSourceFolders() != null && containers.get(project) == null) {
                this.putProject(containers, project);
            }
            ++i;
        }
        IProject[] iProjectArray = CoreUtil.getAllProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILiferayProject lrproject;
            IProject project = iProjectArray[n2];
            if (containers.get(project) == null && (lrproject = LiferayCore.create((Object)project)).getSourceFolders() != null) {
                this.putProject(containers, project);
            }
            ++n2;
        }
        if (containers.size() > 0) {
            collect.addAll(containers.values());
        }
    }

    private void putProject(Map<IProject, ISourceContainer> containers, IProject project) {
        containers.put(project, (ISourceContainer)new JavaProjectSourceContainer(JavaCore.create((IProject)project)));
    }
}

