/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.util;

import com.liferay.ide.core.util.CoreUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.launching.IVMInstallType;

public class JavaUtil {
    public static final String EXT_JAR = ".jar";

    public static String createUniqueId(IVMInstallType vmType) {
        String id = null;
        while (vmType.findVMInstall(id = String.valueOf(System.currentTimeMillis())) != null) {
        }
        return id;
    }

    public static String getJarProperty(File systemJarFile, String propertyName) {
        if (systemJarFile.canRead()) {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (ZipFile jar = new ZipFile(systemJarFile);){
                    ZipEntry manifest = jar.getEntry("META-INF/MANIFEST.MF");
                    Properties props = new Properties();
                    props.load(jar.getInputStream(manifest));
                    String value = (String)props.get(propertyName);
                    return value;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public static String getManifestProperty(File manifestFile, String propertyName) {
        try {
            String contents = CoreUtil.readStreamToString((InputStream)new FileInputStream(manifestFile));
            if (contents != null) {
                Manifest mf = new Manifest(new ByteArrayInputStream(contents.getBytes()));
                Attributes a = mf.getMainAttributes();
                String val = a.getValue(propertyName);
                return val;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public static String getManifestPropFromFolderJars(File location, String mainFolder, String property) {
        File f = new File(location, mainFolder);
        if (f.exists()) {
            File[] children = f.listFiles();
            int i = 0;
            while (i < children.length) {
                if (children[i].getName().endsWith(EXT_JAR)) {
                    return JavaUtil.getJarProperty(children[i], property);
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean scanFolderJarsForManifestProp(File location, String mainFolder, String property, String propPrefix) {
        String value = JavaUtil.getManifestPropFromFolderJars(location, mainFolder, property);
        return value != null && value.trim().startsWith(propPrefix);
    }
}

