/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class CompositeOutputStream
extends OutputStream {
    private OutputStream[] streams;

    public CompositeOutputStream(OutputStream ... streams) {
        if (streams == null) {
            throw new NullPointerException();
        }
        this.streams = streams;
    }

    public synchronized void write(int i) throws IOException {
        OutputStream[] outputStreamArray = this.streams;
        int n = this.streams.length;
        int n2 = 0;
        while (n2 < n) {
            OutputStream stream = outputStreamArray[n2];
            stream.write(i);
            ++n2;
        }
    }

    public synchronized void write(byte[] bytes) throws IOException {
        OutputStream[] outputStreamArray = this.streams;
        int n = this.streams.length;
        int n2 = 0;
        while (n2 < n) {
            OutputStream stream = outputStreamArray[n2];
            stream.write(bytes);
            ++n2;
        }
    }

    public synchronized void write(byte[] bytes, int off, int len) throws IOException {
        OutputStream[] outputStreamArray = this.streams;
        int n = this.streams.length;
        int n2 = 0;
        while (n2 < n) {
            OutputStream stream = outputStreamArray[n2];
            stream.write(bytes, off, len);
            ++n2;
        }
    }

    public synchronized void flush() throws IOException {
        OutputStream[] outputStreamArray = this.streams;
        int n = this.streams.length;
        int n2 = 0;
        while (n2 < n) {
            OutputStream stream = outputStreamArray[n2];
            stream.flush();
            ++n2;
        }
    }

    public synchronized void close() throws IOException {
        OutputStream[] outputStreamArray = this.streams;
        int n = this.streams.length;
        int n2 = 0;
        while (n2 < n) {
            OutputStream stream = outputStreamArray[n2];
            stream.close();
            ++n2;
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, Arrays.toString(this.streams));
    }
}

