/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import java.util.ArrayList;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.RuntimeType;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeContentProvider;

public class RuntimeTypeTreeContentProvider
extends AbstractTreeContentProvider {
    protected boolean creation;
    protected String type;
    protected String version;
    protected String runtimeTypeId;

    public RuntimeTypeTreeContentProvider(boolean creation) {
        this.creation = creation;
    }

    public RuntimeTypeTreeContentProvider(boolean creation, String type, String version, String runtimeTypeId) {
        super(false);
        this.type = type;
        this.version = version;
        this.runtimeTypeId = runtimeTypeId;
        this.creation = creation;
        this.fillTree();
    }

    public void fillTree() {
        this.clean();
        ArrayList<AbstractTreeContentProvider.TreeElement> list = new ArrayList<AbstractTreeContentProvider.TreeElement>();
        IRuntimeType[] runtimeTypes = ServerUtil.getRuntimeTypes((String)this.type, (String)this.version, (String)this.runtimeTypeId);
        if (runtimeTypes != null) {
            int size = runtimeTypes.length;
            int i = 0;
            while (i < size) {
                block6: {
                    IRuntimeType runtimeType = runtimeTypes[i];
                    if (!this.creation || runtimeType.canCreate()) {
                        block5: {
                            try {
                                if (((RuntimeType)runtimeType).supportsManualCreation()) break block5;
                                break block6;
                            }
                            catch (Exception exception) {}
                        }
                        AbstractTreeContentProvider.TreeElement ele = this.getOrCreate(list, runtimeType.getVendor());
                        ele.contents.add(runtimeType);
                        this.elementToParentMap.put(runtimeType, ele);
                    }
                }
                ++i;
            }
        }
        this.elements = list.toArray();
    }
}

