/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.internal.utility.ContentTypeTools;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.JpaEntityGeneratorDatabaseAnnotationNameBuilder;
import org.eclipse.jpt.jpa.core.JpaFactory;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaPlatformProvider;
import org.eclipse.jpt.jpa.core.JpaPlatformVariation;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaResourceDefinition;
import org.eclipse.jpt.jpa.core.JpaResourceModelProvider;
import org.eclipse.jpt.jpa.core.context.java.DefaultJavaAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.java.JavaManagedTypeDefinition;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMappingDefinition;
import org.eclipse.jpt.jpa.core.internal.GenericEntityGeneratorDatabaseAnnotationNameBuilder;
import org.eclipse.jpt.jpa.db.ConnectionProfileFactory;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaPlatform
implements JpaPlatform {
    private final JpaPlatform.Config config;
    private final JpaPlatform.Version jpaVersion;
    private final JpaFactory jpaFactory;
    private final AnnotationProvider annotationProvider;
    private final JpaPlatformProvider platformProvider;
    private final JpaPlatformVariation jpaVariation;
    private final JPQLGrammar jpqlGrammar;

    public GenericJpaPlatform(JpaPlatform.Config config, JpaPlatform.Version jpaVersion, JpaFactory jpaFactory, AnnotationProvider annotationProvider, JpaPlatformProvider platformProvider, JpaPlatformVariation jpaVariation, JPQLGrammar jpqlGrammar) {
        this.config = config;
        this.jpaVersion = jpaVersion;
        this.jpaFactory = jpaFactory;
        this.annotationProvider = annotationProvider;
        this.jpaVariation = jpaVariation;
        this.platformProvider = platformProvider;
        this.jpqlGrammar = jpqlGrammar;
    }

    @Override
    public String getId() {
        return this.config.getId();
    }

    @Override
    public JpaPlatform.Config getConfig() {
        return this.config;
    }

    @Override
    public JpaPlatform.Version getJpaVersion() {
        return this.jpaVersion;
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (CharSequence)this.getId());
    }

    @Override
    public JpaFactory getJpaFactory() {
        return this.jpaFactory;
    }

    protected JpaPlatformProvider getPlatformProvider() {
        return this.platformProvider;
    }

    @Override
    public JpaFile buildJpaFile(JpaProject jpaProject, IFile file) {
        IContentType contentType = this.getContentType(file);
        return contentType == null ? null : this.buildJpaFile(jpaProject, file, contentType);
    }

    @Override
    public IContentType getContentType(IFile file) {
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(file.getName());
        if (contentType != null && contentType.equals(JavaResourceCompilationUnit.CONTENT_TYPE)) {
            return contentType;
        }
        return ContentTypeTools.contentType((IFile)file);
    }

    protected JpaFile buildJpaFile(JpaProject jpaProject, IFile file, IContentType contentType) {
        JptResourceModel resourceModel = this.buildResourceModel(jpaProject, file, contentType);
        return resourceModel == null ? null : this.jpaFactory.buildJpaFile(jpaProject, file, contentType, resourceModel);
    }

    protected JptResourceModel buildResourceModel(JpaProject jpaProject, IFile file, IContentType contentType) {
        JpaResourceModelProvider provider = this.getResourceModelProvider(contentType);
        return provider == null ? null : provider.buildResourceModel(jpaProject, file);
    }

    protected JpaResourceModelProvider getResourceModelProvider(IContentType contentType) {
        for (JpaResourceModelProvider provider : this.platformProvider.getResourceModelProviders()) {
            if (!contentType.equals(provider.getContentType())) continue;
            return provider;
        }
        return null;
    }

    @Override
    public AnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    @Override
    public AnnotationEditFormatter getAnnotationEditFormatter() {
        return DefaultAnnotationEditFormatter.instance();
    }

    @Override
    public Iterable<JavaManagedTypeDefinition> getJavaManagedTypeDefinitions() {
        return this.platformProvider.getJavaManagedTypeDefinitions();
    }

    @Override
    public Iterable<JavaTypeMappingDefinition> getJavaTypeMappingDefinitions() {
        return this.platformProvider.getJavaTypeMappingDefinitions();
    }

    @Override
    public Iterable<JavaAttributeMappingDefinition> getSpecifiedJavaAttributeMappingDefinitions() {
        return this.platformProvider.getSpecifiedJavaAttributeMappingDefinitions();
    }

    @Override
    public Iterable<DefaultJavaAttributeMappingDefinition> getDefaultJavaAttributeMappingDefinitions() {
        return this.platformProvider.getDefaultJavaAttributeMappingDefinitions();
    }

    @Override
    public boolean supportsResourceType(JptResourceType resourceType) {
        return this.getResourceDefinition_(resourceType) != null;
    }

    @Override
    public JpaResourceDefinition getResourceDefinition(JptResourceType resourceType) {
        JpaResourceDefinition definition = this.getResourceDefinition_(resourceType);
        if (definition == null) {
            throw new IllegalArgumentException("Illegal resource type: " + resourceType);
        }
        return definition;
    }

    protected JpaResourceDefinition getResourceDefinition_(JptResourceType resourceType) {
        for (JpaResourceDefinition resourceDefinition : this.platformProvider.getResourceDefinitions()) {
            if (!resourceDefinition.getResourceType().equals(resourceType)) continue;
            return resourceDefinition;
        }
        return null;
    }

    @Override
    public JptResourceType getMostRecentSupportedResourceType(IContentType contentType) {
        for (JptResourceType resourceType : this.platformProvider.getMostRecentSupportedResourceTypes()) {
            if (!resourceType.getContentType().equals(contentType)) continue;
            return resourceType;
        }
        throw new IllegalArgumentException(contentType.toString());
    }

    @Override
    public ConnectionProfileFactory getConnectionProfileFactory() {
        return this.config.getJpaPlatformManager().getJpaWorkspace().getConnectionProfileFactory();
    }

    @Override
    public JpaEntityGeneratorDatabaseAnnotationNameBuilder getEntityGeneratorDatabaseAnnotationNameBuilder() {
        return GenericEntityGeneratorDatabaseAnnotationNameBuilder.instance();
    }

    @Override
    public JpaPlatformVariation getJpaVariation() {
        return this.jpaVariation;
    }

    public Object getAdapter(Class adapter) {
        return PlatformTools.getAdapter((Object)this, (Class)adapter);
    }

    @Override
    public JPQLGrammar getJpqlGrammar() {
        return this.jpqlGrammar;
    }
}

