/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.vaadin.core.dd;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.portlet.core.PluginPropertiesConfiguration;
import com.liferay.ide.portlet.core.PortletCore;
import com.liferay.ide.portlet.core.dd.PluginPackagesDescriptorHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class VaadinPluginPackageDescriptorHelper
extends PluginPackagesDescriptorHelper {
    public VaadinPluginPackageDescriptorHelper() {
    }

    public VaadinPluginPackageDescriptorHelper(IProject project) {
        super(project);
    }

    public IStatus addNewPortlet(IDataModel dataModel) {
        if (this.canAddNewPortlet(dataModel)) {
            return this.addPortalDependency("portal-dependency-jars", "vaadin.jar");
        }
        return Status.OK_STATUS;
    }

    public IStatus addPortalDependency(String propertyName, String value) {
        if (CoreUtil.isNullOrEmpty((String)value)) {
            return Status.OK_STATUS;
        }
        try {
            String[] existingValues;
            IFile pluginPackageFile = this.getDescriptorFile();
            if (!pluginPackageFile.exists()) {
                IStatus warning = PortletCore.createWarningStatus((String)"No liferay-plugin-package.properties file in the project.");
                PortletCore.getDefault().getLog().log(warning);
                return Status.OK_STATUS;
            }
            File osfile = new File(pluginPackageFile.getLocation().toOSString());
            PluginPropertiesConfiguration pluginPackageProperties = new PluginPropertiesConfiguration();
            pluginPackageProperties.load(osfile);
            String existingDeps = pluginPackageProperties.getString(propertyName, "");
            String[] stringArray = existingValues = existingDeps.split(",");
            int n = existingValues.length;
            int n2 = 0;
            while (n2 < n) {
                String existingValue = stringArray[n2];
                if (value.equals(existingValue)) {
                    return Status.OK_STATUS;
                }
                ++n2;
            }
            String newPortalDeps = null;
            newPortalDeps = CoreUtil.isNullOrEmpty((String)existingDeps) ? value : String.valueOf(existingDeps) + "," + value;
            pluginPackageProperties.setProperty(propertyName, (Object)newPortalDeps);
            try (FileWriter output = new FileWriter(osfile);){
                pluginPackageProperties.save((Writer)output);
            }
            pluginPackageFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            PortletCore.logError((Exception)e);
            return PortletCore.createErrorStatus((String)"Could not add dependency in liferay-plugin-package.properties");
        }
        return Status.OK_STATUS;
    }

    private boolean canAddNewPortlet(IDataModel dataModel) {
        return dataModel.getID().contains("NewVaadinPortlet");
    }
}

