/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.discovery.internal.model;

import java.net.URI;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.server.discovery.internal.Activator;
import org.eclipse.wst.server.discovery.internal.ExtensionUtility;
import org.eclipse.wst.server.discovery.internal.model.IServerExtension;
import org.osgi.framework.BundleContext;

public class Extension
implements IServerExtension {
    private IInstallableUnit iu;
    private URI uri;
    private ProvisioningContext provContext;
    private IProvisioningPlan plan;

    public Extension(IInstallableUnit iu, URI uri) {
        this.iu = iu;
        this.uri = uri;
    }

    public String getName() {
        return this.iu.getProperty("org.eclipse.equinox.p2.name", null);
    }

    public String getDescription() {
        return this.iu.getProperty("org.eclipse.equinox.p2.description", null);
    }

    public Image getImage() {
        return null;
    }

    public String getLicense() {
        Collection licenses = this.iu.getLicenses(null);
        if (licenses == null || licenses.isEmpty()) {
            return "";
        }
        return ((ILicense)licenses.iterator().next()).getBody();
    }

    public String getProvider() {
        return this.iu.getProperty("org.eclipse.equinox.p2.provider", null);
    }

    public String getId() {
        return this.iu.getId();
    }

    public Version getVersion() {
        return this.iu.getVersion();
    }

    public IStatus install(IProgressMonitor monitor) {
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        IProvisioningPlan plan = this.getProvisioningPlan(true, monitor);
        if (!plan.getStatus().isOK()) {
            return plan.getStatus();
        }
        IEngine engine = (IEngine)ExtensionUtility.getService(bundleContext, IEngine.SERVICE_NAME);
        return engine.perform(plan, PhaseSetFactory.createDefaultPhaseSet(), monitor);
    }

    public IInstallableUnit[] getIUs() {
        return new IInstallableUnit[]{this.iu};
    }

    public IProvisioningPlan getProvisioningPlan(boolean explain, IProgressMonitor monitor) {
        if (this.plan != null) {
            return this.plan;
        }
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        IPlanner planner = (IPlanner)ExtensionUtility.getService(bundleContext, IPlanner.SERVICE_NAME);
        IProfileRegistry profileRegistry = (IProfileRegistry)ExtensionUtility.getService(bundleContext, IProfileRegistry.SERVICE_NAME);
        IProfile profile = profileRegistry.getProfile("_SELF_");
        IProfile[] profiles = profileRegistry.getProfiles();
        if (profile == null) {
            int i = 0;
            while (i < profiles.length) {
                if (profiles[i].getProfileId().equals("_SELF_")) {
                    profile = profiles[i];
                    break;
                }
                ++i;
            }
        }
        if (profile == null) {
            return null;
        }
        IProfileChangeRequest pcr = planner.createChangeRequest(profile);
        pcr.add(this.iu);
        IProvisioningAgent agent = ExtensionUtility.getAgent(bundleContext);
        if (agent == null) {
            return null;
        }
        URI[] knownRepositories = null;
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (manager != null) {
            manager.addRepository(this.uri);
            knownRepositories = manager.getKnownRepositories(0);
            if (knownRepositories == null) {
                knownRepositories = new URI[]{this.uri};
            }
        } else {
            knownRepositories = new URI[]{this.uri};
        }
        this.provContext = new ProvisioningContext(agent);
        this.provContext.setMetadataRepositories(knownRepositories);
        this.provContext.setArtifactRepositories(knownRepositories);
        if (!explain) {
            this.provContext.setProperty("org.eclipse.equinox.p2.director.explain", "false");
        }
        this.provContext.setProperty("org.eclipse.equinox.p2.director.followRepositoryReferences", "true");
        this.plan = planner.getProvisioningPlan(pcr, this.provContext, monitor);
        return this.plan;
    }

    public String getURI() {
        return this.uri.toString();
    }

    public String getServerId() {
        return this.iu.getProperty("serverId", null);
    }
}

