/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import org.eclipse.sapphire.Length;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.internal.LengthFactsServiceForValue;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValidationService;

public final class LengthValidationServiceForValue
extends ValidationService {
    private int min;
    private int max;

    @Override
    protected void initValidationService() {
        PropertyDef property = this.context(PropertyDef.class);
        Length lengthAnnotation = property.getAnnotation(Length.class);
        this.min = lengthAnnotation.min();
        this.max = lengthAnnotation.max();
    }

    @Override
    protected Status compute() {
        String text = this.context(Value.class).text();
        if (text != null) {
            int length = text.length();
            if (length < this.min) {
                String msg = LengthFactsServiceForValue.minLengthStatement.format(this.min);
                return Status.createErrorStatus(msg);
            }
            if (length > this.max) {
                String msg = LengthFactsServiceForValue.maxLengthStatement.format(this.max);
                return Status.createErrorStatus(msg);
            }
        }
        return Status.createOkStatus();
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            if (property != null) {
                Length annotation = property.getAnnotation(Length.class);
                return annotation != null && (annotation.min() > 0 || annotation.max() < Integer.MAX_VALUE);
            }
            return false;
        }
    }
}

