/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.indexing;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wst.xml.search.editor.internal.indexing.XMLReferencesFileVisitor;

public class XMLReferencesIndexManager {
    static final boolean DEBUG;
    public static XMLReferencesIndexManager INSTANCE;
    private Map<IProject, Map<String, Collection<IFile>>> indexedFiles = new HashMap<IProject, Map<String, Collection<IFile>>>();

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.xml.search.editor/debug/indexmanager");
        DEBUG = value != null && value.equalsIgnoreCase("true");
        INSTANCE = new XMLReferencesIndexManager();
    }

    public static XMLReferencesIndexManager getDefault() {
        return INSTANCE;
    }

    public Collection<IFile> getIndexedFiles(IProject project, String contentTypeId, IProgressMonitor monitor) {
        this.indexFilesIfNeeded(project, monitor);
        Map<String, Collection<IFile>> files = this.indexedFiles.get(project);
        if (files == null) {
            return Collections.emptyList();
        }
        Collection<IFile> f = files.get(contentTypeId);
        if (f == null) {
            return Collections.emptyList();
        }
        return f;
    }

    private void indexFilesIfNeeded(IProject project, IProgressMonitor monitor) {
        Map<String, Collection<IFile>> files = this.indexedFiles.get(project);
        if (files == null) {
            files = new HashMap<String, Collection<IFile>>();
            this.run(project, files, monitor);
            this.indexedFiles.put(project, files);
        }
    }

    public void flushIndexedFiles(IJavaProject javaProject) {
        if (javaProject == null) {
            this.indexedFiles.clear();
        } else {
            IProject[] referencingProjects;
            IProject project = javaProject.getProject();
            this.indexedFiles.remove(project);
            IProject[] iProjectArray = referencingProjects = project.getReferencingProjects();
            int n = referencingProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject referencingProject = iProjectArray[n2];
                this.indexedFiles.remove(referencingProject);
                ++n2;
            }
        }
    }

    public void initialize() {
    }

    public void destroy() {
    }

    private IStatus run(IProject project, Map<String, Collection<IFile>> files, IProgressMonitor monitor) {
        long start;
        IStatus status;
        block11: {
            status = Status.OK_STATUS;
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (DEBUG) {
                System.out.println(" ^ IndexWorkspaceJob started: ");
            }
            Thread.currentThread().setPriority(10);
            start = System.currentTimeMillis();
            try {
                try {
                    XMLReferencesFileVisitor visitor = new XMLReferencesFileVisitor(files, monitor);
                    if (project != null) {
                        project.accept((IResourceProxyVisitor)visitor, 2);
                    } else {
                        ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)visitor, 2);
                    }
                }
                catch (CoreException e) {
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                    monitor.done();
                    break block11;
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                throw throwable;
            }
            monitor.done();
        }
        long finish = System.currentTimeMillis();
        if (DEBUG) {
            System.out.println(" ^ IndexWorkspaceJob finished\n   total time running: " + (finish - start));
        }
        return status;
    }
}

