/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.jdt.search;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.PatternQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.wst.xml.search.core.IXMLSearchDOMNodeCollector;
import org.eclipse.wst.xml.search.core.SimpleXMLSearchEngine;
import org.eclipse.wst.xml.search.core.queryspecifications.IXMLQuerySpecification;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.editor.internal.indexing.XMLReferencesIndexManager;
import org.eclipse.wst.xml.search.editor.internal.jdt.search.JDTSearchDOMNodeCollector;
import org.eclipse.wst.xml.search.editor.internal.jdt.search.XMLUIParticipant;
import org.eclipse.wst.xml.search.editor.internal.references.XMLReferencesManager;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.eclipse.wst.xml.search.editor.references.IXMLReferencePath;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.validators.IXMLReferenceValidator2;
import org.eclipse.wst.xml.search.editor.util.XMLQuerySpecificationUtil;

public class XMLReferenceJavaSearchParticipant
implements IQueryParticipant {
    private IMatchPresentation uiParticipant;

    public int estimateTicks(QuerySpecification query) {
        if (this.isValid(query)) {
            return 50;
        }
        return 0;
    }

    public synchronized IMatchPresentation getUIParticipant() {
        if (this.uiParticipant == null) {
            this.uiParticipant = new XMLUIParticipant();
        }
        return this.uiParticipant;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void search(ISearchRequestor requestor, QuerySpecification query, IProgressMonitor monitor) throws CoreException {
        if (!this.isValid(query)) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 11);
        try {
            IJavaProject javaProject = null;
            String className = null;
            String methodName = null;
            if (query instanceof ElementQuerySpecification) {
                ElementQuerySpecification elementQuery = (ElementQuerySpecification)query;
                IJavaElement element = elementQuery.getElement();
                if (!(element instanceof IMember)) return;
                IMember member = (IMember)element;
                javaProject = member.getJavaProject();
                if (member.getElementType() == 7) {
                    IType type = (IType)member;
                    className = type.getFullyQualifiedName('.');
                } else if (member.getElementType() == 9) {
                    IMethod method = (IMethod)member;
                    methodName = method.getElementName();
                    className = method.getDeclaringType().getFullyQualifiedName('.');
                }
            } else if (query instanceof PatternQuerySpecification) {
                PatternQuerySpecification patternQuery = (PatternQuerySpecification)query;
                if (patternQuery.getSearchFor() == 1) {
                    methodName = patternQuery.getPattern();
                } else {
                    className = patternQuery.getPattern();
                }
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
            if (className == null && methodName == null) {
                return;
            }
            IXMLReferenceTo.ToType toType = !StringUtils.isEmpty((String)methodName) ? IXMLReferenceTo.ToType.JAVA_METHOD : IXMLReferenceTo.ToType.JAVA;
            Collection<IXMLReference> references = XMLReferencesManager.getInstance().getXMLReferencesForToType(toType);
            if (references.size() < 1) {
                return;
            }
            XMLReferencesIndexManager.getDefault().flushIndexedFiles(javaProject);
            this.searchXMLReferences(query.getScope(), requestor, className, methodName, javaProject, references, toType, new SubProgressMonitor(monitor, 7));
            return;
        }
        finally {
            monitor.done();
        }
    }

    private void searchXMLReferences(IJavaSearchScope scope, ISearchRequestor requestor, String className, String methodName, IJavaProject javaProject, Collection<IXMLReference> references, IXMLReferenceTo.ToType toType, SubProgressMonitor monitor) {
        if (javaProject != null) {
            this.search(requestor, className, methodName, javaProject.getProject(), references, toType, (IProgressMonitor)monitor);
        }
    }

    private void search(ISearchRequestor requestor, String className, String methodName, IProject project, Collection<IXMLReference> references, IXMLReferenceTo.ToType toType, IProgressMonitor monitor) {
        IXMLSearchDOMNodeCollector collector = null;
        String contentTypeId = null;
        String javaTypeName = null;
        Set<IProject> projects = this.createProjects(project);
        for (IXMLReference reference : references) {
            String[] contentTypeIds = reference.getContentTypeIds();
            int i = 0;
            while (i < contentTypeIds.length) {
                contentTypeId = contentTypeIds[i];
                javaTypeName = toType == IXMLReferenceTo.ToType.JAVA ? className : methodName;
                collector = this.search(requestor, javaTypeName, monitor, project, collector, contentTypeId, reference);
                for (IProject p : projects) {
                    collector = this.search(requestor, javaTypeName, monitor, p, collector, contentTypeId, reference);
                }
                ++i;
            }
        }
    }

    private Set<IProject> createProjects(IProject project) {
        HashSet<IProject> projects = new HashSet<IProject>();
        this.addProjects(projects, project);
        return projects;
    }

    private void addProjects(Set<IProject> projects, IProject project) {
        if (!projects.contains(project)) {
            projects.add(project);
            IProject[] referencingProjects = project.getReferencingProjects();
            int i = 0;
            while (i < referencingProjects.length) {
                this.addProjects(projects, referencingProjects[i]);
                ++i;
            }
        }
    }

    private IXMLSearchDOMNodeCollector search(ISearchRequestor requestor, String javaTypeName, IProgressMonitor monitor, IProject project, IXMLSearchDOMNodeCollector collector, String contentTypeId, IXMLReference reference) {
        IXMLReferenceValidator2 validator;
        if (reference.getValidator() instanceof IXMLReferenceValidator2 && !(validator = (IXMLReferenceValidator2)((Object)reference.getValidator())).isValidTarget(project)) {
            return collector;
        }
        Collection<IFile> indexedFiles = XMLReferencesIndexManager.getDefault().getIndexedFiles(project, contentTypeId, monitor);
        if (indexedFiles != null && indexedFiles.size() > 0) {
            String query;
            IXMLReferencePath referencePath;
            IXMLQuerySpecification xmlQuerySpecification;
            if (collector == null) {
                collector = new JDTSearchDOMNodeCollector(requestor);
            }
            if ((xmlQuerySpecification = XMLQuerySpecificationUtil.getQuerySpecification(referencePath = reference.getFrom())) != null && (query = referencePath.getQuery(null, javaTypeName, xmlQuerySpecification.getEqualsStringQueryBuilder(), true)) != null) {
                SimpleXMLSearchEngine.getDefault().search(indexedFiles.toArray(new IResource[indexedFiles.size()]), xmlQuerySpecification.getRequestor(), xmlQuerySpecification.getVisitor(), query, null, null, collector, null, null, monitor);
            }
        }
        return collector;
    }

    private boolean isValid(QuerySpecification query) {
        switch (query.getLimitTo()) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                return false;
            }
        }
        if (query instanceof ElementQuerySpecification) {
            IJavaElement element = ((ElementQuerySpecification)query).getElement();
            return element.getElementType() == 7 || element.getElementType() == 9;
        }
        if (query instanceof PatternQuerySpecification) {
            PatternQuerySpecification patternQuery = (PatternQuerySpecification)query;
            switch (patternQuery.getSearchFor()) {
                case -1: 
                case 0: 
                case 1: 
                case 5: 
                case 10: {
                    return true;
                }
            }
        }
        return false;
    }
}

