/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.references;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.xml.search.editor.internal.references.XMLReferencesManager;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.eclipse.wst.xml.search.editor.references.IXMLReferencePath;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.filters.IXMLReferenceFilter;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class XMLReferenceContainer {
    private static final String TEXT_KEY = "text()";
    private final String contentTypeId;
    private final Collection<IXMLReference> allReferences;
    private final Map<String, Collection<IXMLReferencePath>> referencesById;
    private final Map<String, Collection<IXMLReference>> fromReferencesByTargetNode;
    private Map<String, Collection<IXMLReference>> fromReferencesWithFilterByTargetNode;
    private final Map<String, Collection<IXMLReference>> toReferencesByTargetNode;

    public XMLReferenceContainer(String contentTypeId) {
        this.contentTypeId = contentTypeId;
        this.allReferences = new ArrayList<IXMLReference>();
        this.referencesById = new HashMap<String, Collection<IXMLReferencePath>>();
        this.fromReferencesByTargetNode = new HashMap<String, Collection<IXMLReference>>();
        this.fromReferencesWithFilterByTargetNode = null;
        this.toReferencesByTargetNode = new HashMap<String, Collection<IXMLReference>>();
    }

    public Collection<IXMLReference> getAllXMLReferences() {
        return this.allReferences;
    }

    public Collection<IXMLReference> getXMLReferences(Node node, XMLReferencesManager.Direction direction) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                String attrName = ((Attr)node).getName();
                int indexPrefix = attrName.indexOf(":");
                if (indexPrefix != -1) {
                    attrName = attrName.substring(indexPrefix + 1, attrName.length());
                }
                String key = this.getKey(attrName, null, node.getNamespaceURI());
                return this.getXMLReferences(node, key, direction);
            }
            case 1: 
            case 3: {
                return this.allReferences;
            }
        }
        return null;
    }

    private Collection<IXMLReference> getXMLReferences(Node node, String nodeName, XMLReferencesManager.Direction direction) {
        Collection<IXMLReference> filteredReferences;
        if (nodeName == null) {
            return null;
        }
        if (direction == XMLReferencesManager.Direction.TO) {
            return this.toReferencesByTargetNode.get(nodeName);
        }
        if (this.fromReferencesWithFilterByTargetNode == null) {
            return this.fromReferencesByTargetNode.get(nodeName);
        }
        ArrayList<IXMLReference> allReferences = new ArrayList<IXMLReference>(this.fromReferencesByTargetNode.size());
        this.fromReferencesByTargetNode.get(nodeName);
        Collection<IXMLReference> noFfilteredReferences = this.fromReferencesByTargetNode.get(nodeName);
        if (noFfilteredReferences != null) {
            allReferences.addAll(noFfilteredReferences);
        }
        if ((filteredReferences = this.fromReferencesWithFilterByTargetNode.get(nodeName)) != null) {
            for (IXMLReference reference : filteredReferences) {
                if (!reference.getFrom().getFilter().accept(node)) continue;
                allReferences.add(reference);
            }
        }
        return allReferences;
    }

    public Collection<IXMLReferencePath> getXMLReferencesByPathTo(String path) {
        return this.referencesById.get(path);
    }

    public String getContentTypeId() {
        return this.contentTypeId;
    }

    public void addReference(IXMLReference reference) {
        this.allReferences.add(reference);
        IXMLReferenceFilter filter = reference.getFrom().getFilter();
        if (filter != null) {
            if (this.fromReferencesWithFilterByTargetNode == null) {
                this.fromReferencesWithFilterByTargetNode = new HashMap<String, Collection<IXMLReference>>();
            }
            this.register(reference, reference.getFrom(), this.fromReferencesWithFilterByTargetNode);
        } else {
            this.register(reference, reference.getFrom(), this.fromReferencesByTargetNode);
        }
        List<IXMLReferenceTo> to = reference.getTo();
        for (IXMLReferenceTo referenceTo : to) {
            this.register(reference, referenceTo, this.toReferencesByTargetNode);
            if (referenceTo.getType() != IXMLReferenceTo.ToType.XML) continue;
            IXMLReferencePath referencePath = (IXMLReferencePath)referenceTo;
            Collection<IXMLReferencePath> refTo = this.referencesById.get(referencePath.getKeyPath());
            if (refTo == null) {
                refTo = new ArrayList<IXMLReferencePath>();
                this.referencesById.put(referencePath.getKeyPath(), refTo);
            }
            refTo.add(reference.getFrom());
        }
    }

    private void register(IXMLReference reference, IXMLReferenceTo referenceTo, Map<String, Collection<IXMLReference>> references) {
        if (referenceTo.getType() != IXMLReferenceTo.ToType.XML) {
            return;
        }
        IXMLReferencePath path = (IXMLReferencePath)referenceTo;
        String[] targetNodes = path.getTargetNodes();
        String targetNode = null;
        int i = 0;
        while (i < targetNodes.length) {
            Collection<IXMLReference> referencesByTargetNode;
            int index;
            targetNode = targetNodes[i];
            if (targetNode.startsWith("@")) {
                targetNode = targetNode.substring(1, targetNode.length());
            }
            if ((index = targetNode.indexOf(":")) != -1) {
                targetNode = targetNode.substring(index + 1, targetNode.length());
            }
            if ((referencesByTargetNode = references.get(targetNode)) == null) {
                referencesByTargetNode = new ArrayList<IXMLReference>();
                references.put(targetNode, referencesByTargetNode);
            }
            referencesByTargetNode.add(reference);
            ++i;
        }
    }

    public Collection<IXMLReference> getAllReferencesWithOneReferenceTo(IXMLReferenceTo.ToType toType) {
        ArrayList<IXMLReference> allTo = new ArrayList<IXMLReference>();
        Collection<Collection<IXMLReference>> allreferences = this.fromReferencesByTargetNode.values();
        for (Collection<IXMLReference> collection : allreferences) {
            for (IXMLReference reference : collection) {
                if (!this.hasReferenceTo(reference, toType)) continue;
                allTo.add(reference);
            }
        }
        if (this.fromReferencesWithFilterByTargetNode != null) {
            allreferences = this.fromReferencesWithFilterByTargetNode.values();
            for (Collection<IXMLReference> collection : allreferences) {
                for (IXMLReference reference : collection) {
                    if (!this.hasReferenceTo(reference, toType)) continue;
                    allTo.add(reference);
                }
            }
        }
        return allTo;
    }

    private boolean hasReferenceTo(IXMLReference reference, IXMLReferenceTo.ToType toType) {
        List<IXMLReferenceTo> to = reference.getTo();
        for (IXMLReferenceTo referenceTo : to) {
            if (toType != referenceTo.getType()) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getContentTypeIdsForToType(IXMLReferenceTo.ToType toType) {
        ArrayList<String> contentTypeIds = new ArrayList<String>();
        Collection<Collection<IXMLReference>> allReferences = this.fromReferencesByTargetNode.values();
        this.getContentTypeIdsForToType(toType, contentTypeIds, allReferences);
        if (this.fromReferencesWithFilterByTargetNode != null) {
            allReferences = this.fromReferencesWithFilterByTargetNode.values();
            this.getContentTypeIdsForToType(toType, contentTypeIds, allReferences);
        }
        return contentTypeIds;
    }

    private void getContentTypeIdsForToType(IXMLReferenceTo.ToType toType, Collection<String> contentTypeIds, Collection<Collection<IXMLReference>> allReferences) {
        for (Collection<IXMLReference> references : allReferences) {
            for (IXMLReference reference : references) {
                if (!this.hasReferenceTo(reference, toType)) continue;
                String contentTypeId = null;
                int i = 0;
                while (i < reference.getContentTypeIds().length) {
                    contentTypeId = reference.getContentTypeIds()[i];
                    if (contentTypeIds.contains(contentTypeId)) {
                        contentTypeIds.add(contentTypeId);
                    }
                    ++i;
                }
            }
        }
    }

    public Collection<IXMLReference> getXMLReferencesForToType(IXMLReferenceTo.ToType toType) {
        ArrayList<IXMLReference> referencesForToType = new ArrayList<IXMLReference>();
        Collection<Collection<IXMLReference>> allReferences = this.fromReferencesByTargetNode.values();
        this.getXMLReferencesForToType(toType, referencesForToType, allReferences);
        if (this.fromReferencesWithFilterByTargetNode != null) {
            allReferences = this.fromReferencesWithFilterByTargetNode.values();
            this.getXMLReferencesForToType(toType, referencesForToType, allReferences);
        }
        return referencesForToType;
    }

    private void getXMLReferencesForToType(IXMLReferenceTo.ToType toType, Collection<IXMLReference> referencesForToType, Collection<Collection<IXMLReference>> allReferences) {
        for (Collection<IXMLReference> references : allReferences) {
            for (IXMLReference reference : references) {
                if (!this.hasReferenceTo(reference, toType)) continue;
                referencesForToType.add(reference);
            }
        }
    }

    private String getKey(String nodeName, String prefix, String namespaceURI) {
        if (prefix == null && namespaceURI == null) {
            return nodeName;
        }
        return nodeName;
    }
}

