/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.references.filters;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.search.core.AbstractRegistryManager;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.editor.internal.Trace;
import org.eclipse.wst.xml.search.editor.references.filters.IXMLReferenceFilter;

public class XMLReferenceFiltersManager
extends AbstractRegistryManager {
    private static final String CLASS_ATTR = "class";
    private static final String ID_ATTR = "id";
    private static final String FILTER_ELT = "filter";
    public static final XMLReferenceFiltersManager INSTANCE = new XMLReferenceFiltersManager();
    private static final String XML_REFERENCE_FILTERS_EXTENSION_POINT = "referenceFilters";
    private Map<String, IXMLReferenceFilter> filtersById = null;

    public static XMLReferenceFiltersManager getDefault() {
        return INSTANCE;
    }

    protected void handleExtensionDelta(IExtensionDelta delta) {
        if (this.filtersById == null) {
            return;
        }
        if (delta.getKind() == 1) {
            IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
            this.addXMLReferenceFilters(this.filtersById, cf);
        }
    }

    private synchronized void addXMLReferenceFilters(Map<String, IXMLReferenceFilter> providersById, IConfigurationElement[] cf) {
        String id = null;
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (FILTER_ELT.equals(ce.getName())) {
                id = ce.getAttribute(ID_ATTR);
                try {
                    IXMLReferenceFilter provider = (IXMLReferenceFilter)ce.createExecutableExtension(CLASS_ATTR);
                    providersById.put(id, provider);
                }
                catch (Throwable t) {
                    Trace.trace((byte)3, "  Could not load XML references filters for id: " + id, t);
                }
            }
            ++n2;
        }
    }

    public IXMLReferenceFilter getProvider(String referenceId) {
        if (StringUtils.isEmpty((String)referenceId)) {
            return null;
        }
        if (this.filtersById == null) {
            this.loadXMLReferenceFilters();
        }
        return this.filtersById.get(referenceId);
    }

    private synchronized void loadXMLReferenceFilters() {
        if (this.filtersById != null) {
            return;
        }
        HashMap<String, IXMLReferenceFilter> providersById = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.xml.search.editor", XML_REFERENCE_FILTERS_EXTENSION_POINT);
            providersById = new HashMap(cf.length);
            this.addXMLReferenceFilters(providersById, cf);
        } else {
            providersById = new HashMap<String, IXMLReferenceFilter>();
        }
        this.filtersById = providersById;
        super.addRegistryListenerIfNeeded();
    }

    protected String getExtensionPoint() {
        return XML_REFERENCE_FILTERS_EXTENSION_POINT;
    }

    protected String getPluginId() {
        return "org.eclipse.wst.xml.search.editor";
    }
}

