/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.style;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.editor.internal.XMLSearchEditorPlugin;
import org.eclipse.wst.xml.search.editor.internal.style.IReferencesStyleConstantsXML;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.eclipse.wst.xml.search.editor.references.XMLReferencesUtil;
import org.eclipse.wst.xml.ui.internal.style.LineStyleProviderForXML;
import org.w3c.dom.Node;

public class LineStyleProviderForXMLReferences
extends LineStyleProviderForXML
implements IReferencesStyleConstantsXML {
    private final ISourceViewer sourceViewer;

    public LineStyleProviderForXMLReferences(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    protected TextAttribute getAttributeFor(ITextRegionCollection collection, ITextRegion region) {
        if (!this.getXMLSearchEditorColorPreferences().getBoolean("enabledColor")) {
            return super.getAttributeFor(collection, region);
        }
        if (region == null) {
            return (TextAttribute)this.getTextAttributes().get("cdataText");
        }
        String type = region.getType();
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead(((StructuredTextViewer)this.sourceViewer).getDocument());
        try {
            IXMLReference reference;
            IDOMNode node;
            if (type == "XML_TAG_ATTRIBUTE_VALUE") {
                IXMLReference reference2;
                IDOMAttr attr;
                IDOMNode node2 = DOMUtils.getNodeByOffset((IStructuredModel)model, (int)collection.getStart());
                if (node2 != null && (attr = DOMUtils.getAttrByOffset((Node)node2, (int)(collection.getStart() + region.getStart()))) != null && (reference2 = XMLReferencesUtil.getXMLReference((Node)attr, model.getContentTypeIdentifier())) != null) {
                    TextAttribute textAttribute = (TextAttribute)this.getTextAttributes().get("tagReferencedAttributeValue");
                    return textAttribute;
                }
            } else if (type == "XML_CONTENT" && (node = DOMUtils.getNodeByOffset((IStructuredModel)model, (int)collection.getStart())) != null && node.getNodeType() == 3 && (reference = XMLReferencesUtil.getXMLReference((Node)node, model.getContentTypeIdentifier())) != null) {
                TextAttribute textAttribute = (TextAttribute)this.getTextAttributes().get("xmlReferencedContent");
                return textAttribute;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return super.getAttributeFor(collection, region);
    }

    protected void loadColors() {
        super.loadColors();
        this.addTextAttribute("tagReferencedAttributeValue");
        this.addTextAttribute("xmlReferencedContent");
    }

    protected void addTextAttribute(String colorKey) {
        String prefString;
        String[] stylePrefs;
        IPreferenceStore colorPreferences = null;
        colorPreferences = "tagReferencedAttributeValue".equals(colorKey) || "xmlReferencedContent".equals(colorKey) ? this.getXMLSearchEditorColorPreferences() : super.getColorPreferences();
        if (colorPreferences != null && (stylePrefs = ColorHelper.unpackStylePreferences((String)(prefString = colorPreferences.getString(colorKey)))) != null) {
            RGB foreground = ColorHelper.toRGB((String)stylePrefs[0]);
            RGB background = ColorHelper.toRGB((String)stylePrefs[1]);
            boolean bold = Boolean.valueOf(stylePrefs[2]);
            boolean italic = Boolean.valueOf(stylePrefs[3]);
            boolean strikethrough = Boolean.valueOf(stylePrefs[4]);
            boolean underline = Boolean.valueOf(stylePrefs[5]);
            int style = 0;
            if (bold) {
                style |= 1;
            }
            if (italic) {
                style |= 2;
            }
            if (strikethrough) {
                style |= 0x20000000;
            }
            if (underline) {
                style |= 0x40000000;
            }
            TextAttribute createTextAttribute = this.createTextAttribute(foreground, background, style);
            this.getTextAttributes().put(colorKey, createTextAttribute);
        }
    }

    protected IPreferenceStore getXMLSearchEditorColorPreferences() {
        return XMLSearchEditorPlugin.getDefault().getPreferenceStore();
    }

    protected void registerPreferenceManager() {
        super.registerPreferenceManager();
        IPreferenceStore pref = this.getXMLSearchEditorColorPreferences();
        if (pref != null) {
            pref.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        }
    }

    protected void unRegisterPreferenceManager() {
        super.unRegisterPreferenceManager();
        IPreferenceStore pref = this.getXMLSearchEditorColorPreferences();
        if (pref != null) {
            pref.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        }
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        String styleKey = null;
        if (event != null) {
            String prefKey = event.getProperty();
            if ("tagReferencedAttributeValue".equals(prefKey)) {
                styleKey = "tagReferencedAttributeValue";
            } else if ("xmlReferencedContent".equals(prefKey)) {
                styleKey = "xmlReferencedContent";
            } else if ("enabledColor".equals(prefKey) && this.fRecHighlighter != null) {
                this.fRecHighlighter.refreshDisplay();
            }
        }
        if (styleKey != null) {
            this.addTextAttribute(styleKey);
            if (this.fRecHighlighter != null) {
                this.fRecHighlighter.refreshDisplay();
            }
        } else {
            super.handlePropertyChange(event);
        }
    }
}

