/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.searchers.statics;

import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.search.core.statics.IStaticValue;
import org.eclipse.wst.xml.search.core.statics.IStaticValueCollector;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistAdditionalProposalInfoProvider;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistProposalRecorder;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToStatic;
import org.eclipse.wst.xml.search.editor.searchers.AbstractContentAssisitCollector;

public class ContentAssisitCollectorForStatics
extends AbstractContentAssisitCollector<IXMLReferenceToStatic>
implements IStaticValueCollector {
    public ContentAssisitCollectorForStatics(String forceBeforeText, String forceEndText, IXMLReferenceToStatic referencePath, IContentAssistProposalRecorder recorder) {
        super(forceBeforeText, forceEndText, referencePath, recorder);
    }

    public boolean add(IStaticValue value) {
        this.collect(this.recorder, value, (IXMLReferenceToStatic)this.referencePath);
        return false;
    }

    private void collect(IContentAssistProposalRecorder recorder, IStaticValue staticValue, IXMLReferenceToStatic referenceToStatic) {
        String value = staticValue.getKey();
        if (value == null) {
            return;
        }
        Image image = null;
        int relevance = 1000;
        String displayText = value;
        String replaceText = this.getReplaceText(value);
        String proposedObject = staticValue.getDescription();
        IContentAssistAdditionalProposalInfoProvider<?> provider = referenceToStatic.getAdditionalProposalInfoProvider();
        if (provider != null) {
            String newDisplayText = provider.getDisplayText(displayText, staticValue);
            if (!StringUtils.isEmpty((String)newDisplayText)) {
                displayText = newDisplayText;
            }
            image = provider.getImage(staticValue);
            proposedObject = provider.getTextInfo(staticValue);
        }
        int cursorPosition = this.getCursorPosition(value);
        recorder.recordProposal(image, relevance, displayText, replaceText, cursorPosition, proposedObject);
    }
}

