/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.searchers.xml;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistAdditionalProposalInfoProvider;
import org.eclipse.wst.xml.search.editor.contentassist.IContentAssistProposalRecorder;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToXML;
import org.eclipse.wst.xml.search.editor.searchers.IXMLSearcher;
import org.eclipse.wst.xml.search.editor.searchers.xml.ContentAssisitCollectorForXML;
import org.eclipse.wst.xml.search.editor.searchers.xml.HyperlinkCollectorForXML;
import org.eclipse.wst.xml.search.editor.searchers.xml.TextInfoForXML;
import org.eclipse.wst.xml.search.editor.searchers.xml.ValidationResultForXML;
import org.eclipse.wst.xml.search.editor.util.XMLSearcherForXMLUtils;
import org.eclipse.wst.xml.search.editor.validation.IValidationResult;

public class XMLSearcherForXML
implements IXMLSearcher {
    public static final IXMLSearcher INSTANCE = new XMLSearcherForXML();

    @Override
    public void searchForCompletion(Object selectedNode, String mathingString, String forceBeforeText, String forceEndText, IFile file, IXMLReferenceTo referenceTo, IContentAssistProposalRecorder recorder) {
        ContentAssisitCollectorForXML collector = new ContentAssisitCollectorForXML(forceBeforeText, forceEndText, (IXMLReferenceToXML)referenceTo, recorder);
        XMLSearcherForXMLUtils.search(selectedNode, mathingString, file, referenceTo, collector, true);
    }

    @Override
    public void searchForHyperlink(Object selectedNode, int offset, String mathingString, int startOffset, int endOffset, IFile file, IXMLReferenceTo referenceTo, IRegion hyperlinkRegion, List<IHyperlink> hyperLinks, ITextEditor textEditor) {
        HyperlinkCollectorForXML collector = new HyperlinkCollectorForXML(hyperlinkRegion, hyperLinks, startOffset, endOffset);
        XMLSearcherForXMLUtils.search(selectedNode, mathingString, file, referenceTo, collector, false);
    }

    @Override
    public IValidationResult searchForValidation(Object selectedNode, String mathingString, int startIndex, int endIndex, IFile file, IXMLReferenceTo referenceTo) {
        ValidationResultForXML collector = new ValidationResultForXML(mathingString, startIndex, endIndex);
        XMLSearcherForXMLUtils.search(selectedNode, mathingString, file, referenceTo, collector, false);
        return collector;
    }

    @Override
    public String searchForTextHover(Object selectedNode, int offset, String mathingString, int startIndex, int endIndex, IFile file, IXMLReferenceTo referenceTo) {
        IXMLReferenceToXML referenceToXML = (IXMLReferenceToXML)referenceTo;
        IContentAssistAdditionalProposalInfoProvider<IDOMNode> provider = referenceToXML.getAdditionalProposalInfoProvider();
        if (provider == null) {
            return null;
        }
        TextInfoForXML collector = new TextInfoForXML(provider);
        XMLSearcherForXMLUtils.search(selectedNode, mathingString, file, referenceTo, collector, false);
        return collector.getTextInfo();
    }
}

