/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.util;

import java.beans.Introspector;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.NamedMember;
import org.eclipse.wst.xml.search.core.queryspecifications.container.IMultiResourceProvider;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.editor.internal.Trace;
import org.eclipse.wst.xml.search.editor.internal.jdt.SuperTypeHierarchyCache;
import org.eclipse.wst.xml.search.editor.searchers.javamethod.requestor.IJavaMethodRequestor;

public class JdtUtils {
    public static IType[] EMPTY_TYPE = new IType[0];

    public static IJavaProject getJavaProject(IProject project) {
        if (project.isAccessible()) {
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
                }
            }
            catch (CoreException e) {
                Trace.trace((byte)3, "Error getting Java project for project '" + project.getName() + "'", e);
            }
        }
        return null;
    }

    public static IFolder getJavaProjectOutputFolder(IProject project) {
        IJavaProject javaProject = JdtUtils.getJavaProject(project);
        if (javaProject != null) {
            try {
                return ResourcesPlugin.getWorkspace().getRoot().getFolder(javaProject.getOutputLocation());
            }
            catch (JavaModelException e) {
                Trace.trace((byte)3, "Error getting Java project output for project '" + project.getName() + "'", e);
            }
        }
        return null;
    }

    public static IResource[] getJavaProjectSrcFolders(IProject project) {
        IJavaProject javaProject = JdtUtils.getJavaProject(project);
        if (javaProject != null) {
            try {
                ArrayList<IResource> sources = new ArrayList<IResource>();
                IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                IPackageFragmentRoot root = null;
                int i = 0;
                while (i < roots.length) {
                    root = roots[i];
                    if (root.getKind() == 1) {
                        sources.add(root.getCorrespondingResource());
                    }
                    ++i;
                }
                return sources.toArray(IMultiResourceProvider.EMPTY_RESOURCE);
            }
            catch (JavaModelException e) {
                Trace.trace((byte)3, "Error getting Java project src for project '" + project.getName() + "'", e);
            }
        }
        return null;
    }

    public static String getPackageName(IContainer container) {
        IJavaProject javaProject = JdtUtils.getJavaProject(container.getProject());
        if (javaProject != null) {
            String containerBasePath = container.getFullPath().toString();
            IResource[] srcs = JdtUtils.getJavaProjectSrcFolders(container.getProject());
            IResource src = null;
            int i = 0;
            while (i < srcs.length) {
                src = srcs[i];
                String srcBasePath = src.getFullPath().toString();
                if (containerBasePath.startsWith(srcBasePath)) {
                    String packageName = containerBasePath.substring(srcBasePath.length() + 1, containerBasePath.length());
                    return packageName.replaceAll("/", ".");
                }
                ++i;
            }
            return null;
        }
        return null;
    }

    public static IJarEntryResource getJavaResourceFileFromBinary(IProject project, String jarNamePattern, String packageName, String fileName) {
        IJavaProject javaProject = JdtUtils.getJavaProject(project);
        if (javaProject != null) {
            try {
                IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                IPackageFragmentRoot root = null;
                int i = 0;
                while (i < roots.length) {
                    root = roots[i];
                    if (root.getKind() == 2 && (StringUtils.isEmpty((String)jarNamePattern) || root.getElementName().startsWith(jarNamePattern))) {
                        Object[] nonJavaResources = null;
                        if (packageName != null) {
                            IPackageFragment fragment = root.getPackageFragment(packageName);
                            if (fragment != null) {
                                nonJavaResources = fragment.getNonJavaResources();
                            }
                        } else {
                            nonJavaResources = root.getNonJavaResources();
                        }
                        if (nonJavaResources != null) {
                            Object nonJavaResource = null;
                            int j = 0;
                            while (j < nonJavaResources.length) {
                                IJarEntryResource r;
                                nonJavaResource = nonJavaResources[j];
                                if (nonJavaResource instanceof IJarEntryResource && (r = (IJarEntryResource)nonJavaResource).isFile() && fileName.equals(r.getName())) {
                                    return r;
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                Trace.trace((byte)3, "Error getting Java project src for project '" + project.getName() + "'", e);
            }
        }
        return null;
    }

    public static IJarEntryResource[] getJavaResourcesFileFromBinary(IProject project, String jarNamePattern, String packageName, String fileName) {
        ArrayList<IJarEntryResource> files = new ArrayList<IJarEntryResource>();
        IJavaProject javaProject = JdtUtils.getJavaProject(project);
        if (javaProject != null) {
            try {
                IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                IPackageFragmentRoot root = null;
                int i = 0;
                while (i < roots.length) {
                    root = roots[i];
                    if (root.getKind() == 2 && (StringUtils.isEmpty((String)jarNamePattern) || root.getElementName().contains(jarNamePattern))) {
                        Object[] nonJavaResources = null;
                        if (packageName != null) {
                            IPackageFragment fragment = root.getPackageFragment(packageName);
                            if (fragment != null) {
                                nonJavaResources = fragment.getNonJavaResources();
                            }
                        } else {
                            nonJavaResources = root.getNonJavaResources();
                        }
                        if (nonJavaResources != null) {
                            Object nonJavaResource = null;
                            int j = 0;
                            while (j < nonJavaResources.length) {
                                IJarEntryResource r;
                                nonJavaResource = nonJavaResources[j];
                                if (nonJavaResource instanceof IJarEntryResource && (r = (IJarEntryResource)nonJavaResource).isFile() && r.getName().contains(fileName)) {
                                    files.add(r);
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                Trace.trace((byte)3, "Error getting Java project src for project '" + project.getName() + "'", e);
            }
        }
        return files.toArray(new IJarEntryResource[files.size()]);
    }

    public static IType getJavaType(IProject project, String className) {
        IJavaProject javaProject = JdtUtils.getJavaProject(project);
        if (className != null) {
            int pos = className.lastIndexOf(36);
            if (pos > 0) {
                className = className.replace('$', '.');
            }
            try {
                IType type = null;
                if (javaProject != null && (type = javaProject.findType(className, (IProgressMonitor)new NullProgressMonitor())) != null) {
                    return type;
                }
                IProject[] iProjectArray = project.getReferencedProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject refProject = iProjectArray[n2];
                    IJavaProject refJavaProject = JdtUtils.getJavaProject(refProject);
                    if (refJavaProject != null && (type = refJavaProject.findType(className)) != null) {
                        return type;
                    }
                    ++n2;
                }
                return null;
            }
            catch (CoreException e) {
                Trace.trace((byte)3, "Error getting Java type '" + className + "'", e);
            }
        }
        return null;
    }

    public static IType getSuperType(IType type) throws JavaModelException {
        if (type == null) {
            return null;
        }
        String name = type.getSuperclassName();
        if (name == null && !type.getFullyQualifiedName().equals(Object.class.getName())) {
            name = Object.class.getName();
        }
        if (name != null) {
            if (type.isBinary()) {
                return type.getJavaProject().findType(name);
            }
            String resolvedName = JdtUtils.resolveClassName(name, type);
            if (resolvedName != null) {
                return type.getJavaProject().findType(resolvedName);
            }
        }
        return null;
    }

    public static String resolveClassName(String className, IType type) {
        if (className == null || type == null) {
            return className;
        }
        className = className.replace('$', '.');
        String dotClassName = '.' + className;
        IProject project = type.getJavaProject().getProject();
        try {
            String packageName;
            String newClassName;
            if (className.startsWith("java.lang") && JdtUtils.getJavaType(project, className) != null) {
                return className;
            }
            if (!type.isBinary()) {
                int ix = className.lastIndexOf(46);
                String firstClassNameSegment = className;
                if (ix > 0) {
                    firstClassNameSegment = className.substring(0, ix);
                }
                IImportDeclaration[] iImportDeclarationArray = type.getCompilationUnit().getImports();
                int n = iImportDeclarationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String newClassName2;
                    IImportDeclaration importDeclaration = iImportDeclarationArray[n2];
                    String importName = importDeclaration.getElementName();
                    if (importDeclaration.isOnDemand()) {
                        newClassName2 = importName.substring(0, importName.length() - 1) + className;
                        if (JdtUtils.getJavaType(project, newClassName2) != null) {
                            return newClassName2;
                        }
                    } else {
                        if (importName.endsWith(dotClassName) && JdtUtils.getJavaType(project, importName) != null) {
                            return importName;
                        }
                        if (!className.equals(firstClassNameSegment) && importName.endsWith(firstClassNameSegment) && JdtUtils.getJavaType(project, newClassName2 = importName.substring(0, importName.lastIndexOf(46) + 1) + className) != null) {
                            return newClassName2;
                        }
                    }
                    ++n2;
                }
            }
            if (JdtUtils.getJavaType(project, newClassName = (packageName = type.getPackageFragment().getElementName()) + dotClassName) != null) {
                return newClassName;
            }
            if (JdtUtils.getJavaType(project, className) != null) {
                return className;
            }
            newClassName = "java.lang" + dotClassName;
            if (JdtUtils.getJavaType(project, newClassName) != null) {
                return newClassName;
            }
            String[][] fullInter = type.resolveType(className);
            if (fullInter != null && fullInter.length > 0) {
                return String.valueOf(fullInter[0][0]) + "." + fullInter[0][1];
            }
        }
        catch (JavaModelException e) {
            Trace.trace((byte)3, "Error resolveClassName'" + className + "'", e);
        }
        return className;
    }

    public static String[] getParameterTypesString(IMethod method) {
        try {
            String[] parameterQualifiedTypes = Signature.getParameterTypes((String)method.getSignature());
            int length = parameterQualifiedTypes != null ? parameterQualifiedTypes.length : 0;
            String[] parameterPackages = new String[length];
            int i = 0;
            while (i < length) {
                parameterQualifiedTypes[i] = parameterQualifiedTypes[i].replace('/', '.');
                parameterPackages[i] = Signature.getSignatureSimpleName((String)parameterQualifiedTypes[i]);
                ++i;
            }
            return parameterPackages;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static String getReturnTypeString(IMethod method, boolean classTypesOnly) {
        try {
            String qualifiedReturnType = Signature.getReturnType((String)method.getSignature());
            if (!classTypesOnly || qualifiedReturnType.startsWith("L") || qualifiedReturnType.startsWith("Q")) {
                return Signature.getSignatureSimpleName((String)qualifiedReturnType.replace('/', '.'));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static String getPropertyNameFromMethodName(IMethod method) {
        String replaceText;
        String methodName = method.getElementName();
        int index = methodName.lastIndexOf(46);
        if (index > 0) {
            methodName = methodName.substring(index + 1);
        }
        if ((replaceText = methodName.substring("set".length())) != null) {
            replaceText = Introspector.decapitalize(replaceText);
        }
        return replaceText;
    }

    public static IMethod findMethod(IType type, String methodNameToFind, IJavaMethodRequestor requestor) throws JavaModelException {
        if (type == null) {
            return null;
        }
        IMethod method = null;
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            method = methods[i];
            IStatus status = requestor.matchTotally(null, methodNameToFind, method);
            if (status != null && status.isOK()) {
                return method;
            }
            ++i;
        }
        return JdtUtils.findMethod(JdtUtils.getSuperType(type), methodNameToFind, requestor);
    }

    public static boolean doesImplement(IResource resource, IType type, IType superType) {
        if (resource == null || type == null || superType == null) {
            return false;
        }
        return JdtUtils.doesImplementWithJdt(resource, type, superType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean doesImplementWithJdt(IResource resource, IType type, IType interfaceType) {
        try {
            IType[] subTypes = SuperTypeHierarchyCache.getTypeHierarchy(interfaceType).getAllSubtypes(interfaceType);
            if (subTypes == null) return false;
            IType[] iTypeArray = subTypes;
            int n = subTypes.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IType subType = iTypeArray[n2];
                if (subType.equals(type)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Trace.trace((byte)3, "Error doesImplementWithJdt", e);
        }
        return false;
    }

    public static IType[] getImplementsType(IType type) {
        try {
            return SuperTypeHierarchyCache.getTypeHierarchy(type).getAllClasses();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static boolean isImplementsClass(IJavaElement javaElement, String className) throws JavaModelException {
        NamedMember method;
        IType type;
        Assert.isNotNull((Object)javaElement);
        if (javaElement != null && javaElement instanceof NamedMember && (type = (method = (NamedMember)javaElement).getDeclaringType()) != null) {
            if (type.getFullyQualifiedName().equals(className)) {
                return true;
            }
            return JdtUtils.hierarchyContainsComponent(type, className);
        }
        return false;
    }

    public static boolean hierarchyContainsComponent(IType type, String className) throws JavaModelException {
        Assert.isNotNull((Object)type);
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        if (hierarchy != null) {
            IType[] supertypes;
            IType[] iTypeArray = supertypes = hierarchy.getAllSupertypes(type);
            int n = supertypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType iType = iTypeArray[n2];
                if (iType.getFullyQualifiedName().equals(className)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

