/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.xml.search.editor.validation.AbstractValidator;

public abstract class AbstractTagValidator
extends AbstractValidator {
    @Override
    protected void doValidate(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter, IFile file, IStructuredModel model) {
        if (this.isStartTag(structuredDocumentRegion)) {
            this.doValidateStartTag(structuredDocumentRegion, reporter, file, model);
        } else if (this.isXMLContent(structuredDocumentRegion)) {
            this.doValidateXMLContent(structuredDocumentRegion, reporter, file, model);
        }
    }

    protected abstract void doValidateXMLContent(IStructuredDocumentRegion var1, IReporter var2, IFile var3, IStructuredModel var4);

    protected abstract void doValidateStartTag(IStructuredDocumentRegion var1, IReporter var2, IFile var3, IStructuredModel var4);

    private boolean isStartTag(IStructuredDocumentRegion structuredDocumentRegion) {
        if (structuredDocumentRegion == null || structuredDocumentRegion.isDeleted()) {
            return false;
        }
        return structuredDocumentRegion.getFirstRegion().getType() == "XML_TAG_OPEN";
    }

    private boolean isXMLContent(IStructuredDocumentRegion structuredDocumentRegion) {
        if (structuredDocumentRegion == null || structuredDocumentRegion.isDeleted()) {
            return false;
        }
        return structuredDocumentRegion.getFirstRegion().getType() == "XML_CONTENT";
    }
}

