/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.IncrementalReporter;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.search.editor.internal.Trace;
import org.eclipse.wst.xml.search.editor.validation.ValidatorUtils;

public abstract class AbstractValidator
implements IValidator,
ISourceValidator {
    private IDocument fDocument;

    private void setDocument(IDocument doc) {
        this.fDocument = doc;
    }

    protected IDocument getDocument() {
        return this.fDocument;
    }

    public void connect(IDocument document) {
        this.setDocument(document);
    }

    public void disconnect(IDocument document) {
        this.setDocument(null);
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        if (this.getDocument() == null) {
            return;
        }
        if (!(reporter instanceof IncrementalReporter)) {
            return;
        }
        if (!(this.getDocument() instanceof IStructuredDocument)) {
            return;
        }
        reporter.removeAllMessages((IValidator)this);
        IFile file = null;
        String[] delta = helper.getURIs();
        if (delta.length > 0) {
            file = ValidatorUtils.getFile(delta[0]);
        }
        IStructuredDocumentRegion[] regions = ((IStructuredDocument)this.fDocument).getStructuredDocumentRegions();
        this.validate(reporter, file, regions);
    }

    public void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter) {
        if (this.getDocument() == null) {
            return;
        }
        if (!(reporter instanceof IncrementalReporter)) {
            return;
        }
        if (!(this.getDocument() instanceof IStructuredDocument)) {
            return;
        }
        reporter.removeAllMessages((IValidator)this);
        IFile file = null;
        String[] delta = helper.getURIs();
        if (delta.length > 0) {
            file = ValidatorUtils.getFile(delta[0]);
        }
        IStructuredDocumentRegion[] regions = ((IStructuredDocument)this.fDocument).getStructuredDocumentRegions(dirtyRegion.getOffset(), dirtyRegion.getLength());
        this.validate(reporter, file, regions);
    }

    private void validate(IReporter reporter, IFile file, IStructuredDocumentRegion[] regions) {
        IStructuredModel model = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getExistingModelForRead(file);
                if (model == null) {
                    model = StructuredModelManager.getModelManager().getModelForRead(file);
                }
                if (model != null) {
                    int i = 0;
                    while (i < regions.length) {
                        this.validate(regions[i], reporter, file, model);
                        ++i;
                    }
                }
            }
            catch (Throwable e) {
                Trace.trace((byte)3, e.getMessage(), e);
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private void validate(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter, IFile file, IStructuredModel model) {
        if (structuredDocumentRegion == null) {
            return;
        }
        this.doValidate(structuredDocumentRegion, reporter, file, model);
    }

    protected abstract void doValidate(IStructuredDocumentRegion var1, IReporter var2, IFile var3, IStructuredModel var4);
}

