/*
 * Decompiled with CFR 0.152.
 */
package tern.repository;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tern.TernException;
import tern.metadata.TernModuleMetadata;
import tern.metadata.TernModuleMetadataManager;
import tern.repository.ITernRepository;
import tern.server.ITernModule;
import tern.server.ITernPlugin;
import tern.server.ModuleType;
import tern.utils.TernModuleHelper;
import tern.utils.ZipUtils;

public class TernRepository
implements ITernRepository {
    private static final String DEFS_FOLDER = "defs";
    private static final String PLUGIN_FOLDER = "plugin";
    private static final List<String> IGNORE_PLUGINS = Arrays.asList("commonjs", "modules", "node_resolve");
    private final String name;
    private File baseDir;
    private File nodeModulesDir;
    private File ternBaseDir;
    private final boolean defaultRepository;
    private Map<String, ITernModule> modules;
    private Map<String, ITernModule> modulesByOrigin;
    private ITernPlugin[] linters;
    private final TernModuleMetadataManager metadataManager;

    public TernRepository(String name, File baseDir) {
        this(name, baseDir, false);
    }

    public TernRepository(String name, File baseDir, boolean defaultRepository) {
        this.name = name;
        this.setBaseDir(baseDir);
        this.defaultRepository = defaultRepository;
        this.metadataManager = new TernModuleMetadataManager(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ITernModule[] getModules() throws TernException {
        this.intializeIfNeeded();
        return this.modules.values().toArray(ITernModule.EMPTY_MODULE);
    }

    @Override
    public ITernModule getModule(String name) {
        try {
            this.intializeIfNeeded();
            return this.modules.get(name);
        }
        catch (TernException ternException) {
            return null;
        }
    }

    @Override
    public ITernModule getModuleByOrigin(String origin) {
        try {
            this.intializeIfNeeded();
            return this.modulesByOrigin.get(origin);
        }
        catch (TernException ternException) {
            return null;
        }
    }

    private void intializeIfNeeded() throws TernException {
        if (this.modules == null) {
            HashMap<String, ITernModule> modules = new HashMap<String, ITernModule>();
            HashMap<String, ITernModule> modulesByOrigin = new HashMap<String, ITernModule>();
            this.loadModules(modules, modulesByOrigin);
            this.modules = modules;
            this.modulesByOrigin = modulesByOrigin;
            this.linters = this.searchLinters(modules.values());
        }
    }

    private ITernPlugin[] searchLinters(Collection<ITernModule> values) {
        ArrayList<ITernPlugin> linters = new ArrayList<ITernPlugin>();
        for (ITernModule module : values) {
            if (module.getModuleType() != ModuleType.Plugin || !((ITernPlugin)module).isLinter()) continue;
            linters.add((ITernPlugin)module);
        }
        return linters.toArray(ITernPlugin.EMPTY_PLUGIN);
    }

    private void loadModules(Map<String, ITernModule> modules, Map<String, ITernModule> modulesByOrigin) throws TernException {
        this.loadModules(modules, modulesByOrigin, new File(this.getTernBaseDir(), DEFS_FOLDER), null);
        this.loadModules(modules, modulesByOrigin, new File(this.getTernBaseDir(), PLUGIN_FOLDER), IGNORE_PLUGINS);
        this.loadModules(modules, modulesByOrigin, this.getNodeModulesDir(), null);
    }

    private void loadModules(Map<String, ITernModule> modules, Map<String, ITernModule> modulesByOrigin, File baseDir, List<String> ignoreModules) throws TernException {
        if (baseDir.exists()) {
            File[] files = baseDir.listFiles();
            File file = null;
            ITernModule module = null;
            int i = 0;
            while (i < files.length) {
                file = files[i];
                module = TernModuleHelper.createModule(file, (ITernRepository)this, null);
                if (module != null && !this.isIgnoreModule(module, ignoreModules)) {
                    modules.put(module.getName(), module);
                    modulesByOrigin.put(module.getOrigin(), module);
                }
                ++i;
            }
        }
    }

    private boolean isIgnoreModule(ITernModule module, List<String> ignoreModules) {
        if (ignoreModules == null) {
            return false;
        }
        return ignoreModules.contains(module.getName());
    }

    @Override
    public void refresh() {
        this.modules = null;
    }

    @Override
    public File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
        this.nodeModulesDir = new File(baseDir, "node_modules");
        this.ternBaseDir = new File(this.nodeModulesDir, "tern");
    }

    @Override
    public File getNodeModulesDir() {
        return this.nodeModulesDir;
    }

    @Override
    public File getTernBaseDir() {
        return this.ternBaseDir;
    }

    @Override
    public String getTernBaseDirAsString() {
        return TernModuleHelper.getPath(this.getTernBaseDir());
    }

    @Override
    public boolean isDefault() {
        return this.defaultRepository;
    }

    @Override
    public File getFile(ITernModule module) {
        String fileName = TernModuleHelper.getFileName(module);
        File moduleFile = null;
        switch (module.getModuleType()) {
            case Plugin: 
            case Configurable: {
                moduleFile = new File(this.ternBaseDir, PLUGIN_FOLDER + '/' + fileName);
                break;
            }
            case Def: {
                moduleFile = new File(this.ternBaseDir, DEFS_FOLDER + '/' + fileName);
            }
        }
        if (moduleFile.exists()) {
            return moduleFile;
        }
        moduleFile = new File(this.getNodeModulesDir(), "tern-" + module.getName() + '/' + fileName);
        if (moduleFile.exists()) {
            return moduleFile;
        }
        return null;
    }

    @Override
    public ITernPlugin[] getLinters() {
        try {
            this.intializeIfNeeded();
        }
        catch (TernException e) {
            e.printStackTrace();
            return ITernPlugin.EMPTY_PLUGIN;
        }
        return this.linters;
    }

    @Override
    public void install(File moduleFile) throws IOException, TernException {
        if (!moduleFile.exists()) {
            throw new TernException("Cannot install module file <" + TernModuleHelper.getPath(moduleFile) + ">. It doesn't exists.");
        }
        File baseDir = this.getNodeModulesDir();
        if (!baseDir.exists()) {
            throw new TernException("Cannot install module file <" + TernModuleHelper.getPath(moduleFile) + ">. Tern repository <" + TernModuleHelper.getPath(baseDir) + "> doesn't exists.");
        }
        if (!ZipUtils.isZipFile(moduleFile) && !ZipUtils.isJarFile(moduleFile)) {
            if (moduleFile.isDirectory()) {
                throw new TernException("TODO!");
            }
            throw new TernException("Cannot install module file <" + TernModuleHelper.getPath(moduleFile) + ">. It must be a folder or a zip/jar file.");
        }
        ZipUtils.extract(moduleFile, baseDir);
    }

    @Override
    public TernModuleMetadata getDefaultMetadata(String moduleName) {
        return this.metadataManager.getMetadata(moduleName);
    }
}

