/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.StringBufferOutputStream;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.BladeCLIException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Java;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class BladeCLI {
    static IPath cachedBladeCLIPath;
    static String[] projectTemplateNames;
    static File settingsDir;
    static File repoCache;
    static String repoUrl;

    static {
        settingsDir = LiferayCore.GLOBAL_SETTINGS_PATH.toFile();
        repoCache = new File(settingsDir, "repoCache");
        repoUrl = "https://liferay-test-01.ci.cloudbees.com/job/blade.tools/lastSuccessfulBuild/artifact/p2_build/generated/p2/index.xml.gz";
    }

    public static String checkForErrors(String[] lines) {
        boolean hasErrors = false;
        StringBuilder errors = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith("Error")) {
                hasErrors = true;
            } else if (hasErrors) {
                errors.append(line);
            }
            ++n2;
        }
        return errors.toString();
    }

    public static String[] execute(String args) throws BladeCLIException {
        IPath bladeCLIPath = BladeCLI.getBladeCLIPath();
        if (bladeCLIPath == null || !bladeCLIPath.toFile().exists()) {
            throw new BladeCLIException("Could not get blade cli jar.");
        }
        Project project = new Project();
        Java javaTask = new Java();
        javaTask.setProject(project);
        javaTask.setFork(true);
        javaTask.setFailonerror(true);
        javaTask.setJar(bladeCLIPath.toFile());
        javaTask.setArgs(args);
        DefaultLogger logger = new DefaultLogger();
        project.addBuildListener((BuildListener)logger);
        StringBufferOutputStream out = new StringBufferOutputStream();
        logger.setOutputPrintStream(new PrintStream((OutputStream)out));
        logger.setMessageOutputLevel(2);
        javaTask.executeJava();
        ArrayList<String> lines = new ArrayList<String>();
        Scanner scanner = new Scanner(out.toString());
        while (scanner.hasNextLine()) {
            lines.add(scanner.nextLine().replaceAll(".*\\[null\\] ", ""));
        }
        scanner.close();
        return lines.toArray(new String[0]);
    }

    public static synchronized IPath getBladeCLIPath() throws BladeCLIException {
        if (cachedBladeCLIPath == null) {
            try {
                URL url = ProjectCore.getDefault().getBundle().getEntry("lib/com.liferay.blade.cli.jar");
                cachedBladeCLIPath = new Path(FileLocator.toFileURL((URL)url).getFile());
            }
            catch (Exception e) {
                throw new BladeCLIException("Could not get blade cli jar from installation", e);
            }
        }
        return cachedBladeCLIPath;
    }

    public static String[] getProjectTemplates() throws BladeCLIException {
        if (projectTemplateNames == null) {
            HashSet<String> templateNames = new HashSet<String>();
            IPath bladeJarPath = BladeCLI.getBladeCLIPath();
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (ZipFile zip = new ZipFile(bladeJarPath.toFile());){
                    File temp = File.createTempFile("templates", ".zip");
                    FileUtil.writeFileFromStream((File)temp, (InputStream)zip.getInputStream(zip.getEntry("templates.zip")));
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (ZipFile templatesZipFile = new ZipFile(temp);){
                        Enumeration<? extends ZipEntry> entries = templatesZipFile.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry entry = entries.nextElement();
                            Path entryPath = new Path(entry.getName());
                            if (entryPath.segmentCount() <= 1) continue;
                            templateNames.add(entryPath.segment(1));
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new BladeCLIException("Unable to open blade cli jar.", e);
            }
            projectTemplateNames = templateNames.toArray(new String[0]);
        }
        return projectTemplateNames;
    }

    public static void main(String[] args) throws Exception {
        String[] output;
        String[] stringArray = output = BladeCLI.execute("help");
        int n = output.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            System.out.println(s);
            ++n2;
        }
    }
}

