/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.upgrade;

import com.liferay.ide.project.core.ProjectCore;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.core.runtime.IPath;

public class UpgradeAssistantSettingsUtil {
    private static final IPath storageLocation = ProjectCore.getDefault().getStateLocation();

    public static Object[] getAllObjectFromStore(Class clazz) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        final String pattern = String.valueOf(clazz.getSimpleName()) + ".*\\.json";
        File[] files = storageLocation.toFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(pattern);
            }
        });
        try {
            if (files != null && files.length > 0) {
                Object[] o = new Object[files.length];
                int i = 0;
                while (i < files.length) {
                    o[i] = mapper.readValue(files[i], clazz);
                    ++i;
                }
                return o;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
        return null;
    }

    public static <T> T getObjectFromStore(Class<T> clazz) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(storageLocation.append(String.valueOf(clazz.getSimpleName()) + ".json").toFile(), clazz);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static <T> void setObjectToStore(Class<T> clazz, String suffix, T object) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        File storageFile = storageLocation.append(String.valueOf(clazz.getSimpleName()) + "-" + suffix + ".json").toFile();
        mapper.writeValue(storageFile, object);
    }

    public static <T> void setObjectToStore(Class<T> clazz, T object) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        File storageFile = storageLocation.append(String.valueOf(clazz.getSimpleName()) + ".json").toFile();
        mapper.writeValue(storageFile, object);
    }
}

