/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.util;

import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.project.core.IPortletFramework;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.ProjectRecord;
import com.liferay.ide.project.core.facet.IPluginFacetConstants;
import com.liferay.ide.project.core.facet.PluginFacetProjectCreationDataModelProvider;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.PluginType;
import com.liferay.ide.project.core.util.SDKPluginFacetUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.server.util.ServerUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.WordUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;

public class ProjectUtil {
    public static final String METADATA_FOLDER = ".metadata";

    public static boolean collectProjectsFromDirectory(Collection<File> eclipseProjectFiles, Collection<File> liferayProjectDirs, File directory, Set<String> directoriesVisited, boolean recurse, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)Msgs.checking, (Object)directory.getPath()));
        File[] contents = directory.listFiles();
        if (contents == null) {
            return false;
        }
        if (directoriesVisited == null) {
            directoriesVisited = new HashSet<String>();
            try {
                directoriesVisited.add(directory.getCanonicalPath());
            }
            catch (IOException exception) {
                ProjectCore.logError(exception.getLocalizedMessage(), exception);
            }
        }
        int i = 0;
        while (i < contents.length) {
            File file = contents[i];
            if (ProjectUtil.isLiferaySDKProjectDir(file)) {
                int currentSize = eclipseProjectFiles.size();
                ProjectUtil.collectProjectsFromDirectory(eclipseProjectFiles, liferayProjectDirs, contents[i], directoriesVisited, false, monitor);
                int newSize = eclipseProjectFiles.size();
                if (newSize == currentSize) {
                    liferayProjectDirs.add(file);
                }
            } else if (file.isFile() && file.getName().equals(".project") && !eclipseProjectFiles.contains(file) && ProjectUtil.isLiferaySDKProjectDir(file.getParentFile())) {
                eclipseProjectFiles.add(file);
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < contents.length) {
            block16: {
                if (contents[i].isDirectory() && !contents[i].getName().equals(METADATA_FOLDER)) {
                    block15: {
                        try {
                            String canonicalPath = contents[i].getCanonicalPath();
                            if (directoriesVisited.add(canonicalPath)) break block15;
                            break block16;
                        }
                        catch (IOException exception) {
                            ProjectCore.logError(exception.getLocalizedMessage(), exception);
                        }
                    }
                    if (!liferayProjectDirs.contains(contents[i]) && recurse) {
                        ProjectUtil.collectProjectsFromDirectory(eclipseProjectFiles, liferayProjectDirs, contents[i], directoriesVisited, recurse, monitor);
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public static String convertToDisplayName(String name) {
        if (CoreUtil.isNullOrEmpty((String)name)) {
            return "";
        }
        String displayName = ProjectUtil.removePluginSuffix(name);
        displayName = displayName.replaceAll("-", " ").replaceAll("_", " ");
        displayName = WordUtils.capitalize((String)displayName);
        return displayName;
    }

    public static void createDefaultWebXml(File webxmlFile, String expectedContainingProjectName) {
        try {
            FileUtil.writeFile((File)webxmlFile, (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-app id=\"WebApp_ID\" version=\"2.5\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd\">\n</web-app>", (String)expectedContainingProjectName);
        }
        catch (Exception e) {
            ProjectCore.logError("Unable to create default web xml", e);
        }
    }

    public static IFile createEmptyProjectFile(String fileName, IFolder folder) throws CoreException {
        IFile emptyFile = folder.getFile(fileName);
        if (emptyFile.exists()) {
            return emptyFile;
        }
        emptyFile.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        return emptyFile;
    }

    public static IProject createExistingProject(ProjectRecord record, IRuntime runtime, String sdkLocation, IProgressMonitor monitor) throws CoreException {
        String projectName = record.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (record.description == null) {
            record.description = workspace.newProjectDescription(projectName);
            Path locationPath = new Path(record.projectSystemFile.getAbsolutePath());
            if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                record.description.setLocation(null);
            } else {
                record.description.setLocation((IPath)locationPath);
            }
        } else {
            record.description.setName(projectName);
        }
        monitor.beginTask(Msgs.importingProject, 100);
        project.create(record.description, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
        project.open(1, (IProgressMonitor)new SubProgressMonitor(monitor, 70));
        if (project.getName().endsWith("-ext")) {
            ProjectUtil.fixExtProjectClasspathEntries(project);
        }
        IFacetedProject fProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        FacetedProjectWorkingCopy fpwc = new FacetedProjectWorkingCopy(fProject);
        String pluginType = ProjectUtil.guessPluginType((IFacetedProjectWorkingCopy)fpwc);
        SDKPluginFacetUtil.configureProjectAsRuntimeProject((IFacetedProjectWorkingCopy)fpwc, runtime, pluginType, sdkLocation, record);
        fpwc.commitChanges(monitor);
        final IJavaProject javaProject = JavaCore.create((IProject)fProject.getProject());
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 5 && entry.getPath().segment(0).equals("com.liferay.ide.eclipse.server.plugin.container")) {
                        JavaCore.getClasspathContainerInitializer((String)"com.liferay.ide.eclipse.server.plugin.container").initialize(entry.getPath(), javaProject);
                        break;
                    }
                    ++n2;
                }
                monitor.done();
            }
        }, monitor);
        return project;
    }

    public static IProject createNewSDKProject(ProjectRecord projectRecord, final IPath sdkLocation, IProgressMonitor monitor, NewLiferayPluginProjectOp op) throws CoreException {
        IDataModel newProjectDataModel = DataModelFactory.createDataModel((IDataModelProvider)new PluginFacetProjectCreationDataModelProvider());
        newProjectDataModel.setBooleanProperty("IPluginProjectDataModelProperties.CREATE_PROJECT_OPERATION", false);
        IDataModel nestedModel = newProjectDataModel.getNestedModel("IFacetProjectCreationDataModelProperties.NESTED_PROJECT_DM");
        nestedModel.setBooleanProperty("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION", true);
        newProjectDataModel.setBooleanProperty("IPluginProjectDataModelProperties.LIFERAY_USE_SDK_LOCATION", false);
        newProjectDataModel.setBooleanProperty("IPluginProjectDataModelProperties.LIFERAY_USE_WORKSPACE_LOCATION", true);
        ProjectUtil.setGenerateDD(newProjectDataModel, false);
        IPath webXmlPath = projectRecord.getProjectLocation().append("docroot/WEB-INF/web.xml");
        if (projectRecord.getProjectName().endsWith("-portlet")) {
            newProjectDataModel.setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET", (Object)true);
            if (!webXmlPath.toFile().exists()) {
                ProjectUtil.createDefaultWebXml(webXmlPath.toFile(), projectRecord.getProjectName());
            }
        } else if (projectRecord.getProjectName().endsWith("-hook")) {
            newProjectDataModel.setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_HOOK", (Object)true);
            if (!webXmlPath.toFile().exists()) {
                ProjectUtil.createDefaultWebXml(webXmlPath.toFile(), projectRecord.getProjectName());
            }
        } else if (projectRecord.getProjectName().endsWith("-ext")) {
            webXmlPath = webXmlPath.removeLastSegments(3).append((IPath)new Path("docroot/WEB-INF/ext-web/docroot/WEB-INF/web.xml"));
            newProjectDataModel.setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_EXT", (Object)true);
            if (!webXmlPath.toFile().exists()) {
                ProjectUtil.createDefaultWebXml(webXmlPath.toFile(), projectRecord.getProjectName());
            }
        } else if (projectRecord.getProjectName().endsWith("-layouttpl")) {
            newProjectDataModel.setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_LAYOUTTPL", (Object)true);
        } else if (projectRecord.getProjectName().endsWith("-theme")) {
            newProjectDataModel.setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_THEME", (Object)true);
        } else if (projectRecord.getProjectName().endsWith("-web")) {
            newProjectDataModel.setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_WEB", (Object)true);
        }
        IFacetedProjectWorkingCopy fpwc = (IFacetedProjectWorkingCopy)newProjectDataModel.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        fpwc.setProjectName(projectRecord.getProjectName());
        IPath projectLocation = projectRecord.getProjectLocation();
        String projectDirName = projectLocation.lastSegment();
        fpwc.setProjectLocation(projectRecord.getProjectLocation());
        String pluginType = null;
        if (op != null) {
            pluginType = ((PluginType)((Object)op.getPluginType().content())).name();
            if (PluginType.theme.name().equals(pluginType)) {
                newProjectDataModel.setProperty("IPluginProjectDataModelProperties.THEME_PARENT", op.getThemeParent().content(true));
                newProjectDataModel.setProperty("IPluginProjectDataModelProperties.THEME_TEMPLATE_FRAMEWORK", op.getThemeFramework().content(true));
            }
        } else {
            pluginType = ProjectUtil.guessPluginType(fpwc);
        }
        SDKPluginFacetUtil.configureProjectAsSDKProject(fpwc, pluginType, sdkLocation.toPortableString(), projectRecord);
        if (op != null && PluginType.portlet.name().equals(pluginType)) {
            IPortletFramework portletFramework = (IPortletFramework)op.getPortletFramework().content(true);
            portletFramework.configureNewProject(newProjectDataModel, fpwc);
        }
        if (CoreUtil.getWorkspaceRoot().getLocation().append(projectDirName).equals((Object)projectLocation)) {
            fpwc.setProjectLocation(null);
        }
        fpwc.commitChanges(monitor);
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                SDK sdk = SDKUtil.createSDKFromLocation((IPath)sdkLocation);
                SDKUtil.openAsProject((SDK)sdk);
            }
        }, monitor);
        return fpwc.getProject();
    }

    public static IProject createNewSDKProject(ProjectRecord projectRecord, IRuntime runtime, String sdkLocation, NewLiferayPluginProjectOp op, IProgressMonitor monitor) throws CoreException {
        IDataModel newProjectDataModel = DataModelFactory.createDataModel((IDataModelProvider)new PluginFacetProjectCreationDataModelProvider());
        newProjectDataModel.setBooleanProperty("IPluginProjectDataModelProperties.CREATE_PROJECT_OPERATION", false);
        IDataModel nestedModel = newProjectDataModel.getNestedModel("IFacetProjectCreationDataModelProperties.NESTED_PROJECT_DM");
        if (op != null) {
            if (((Boolean)op.getUseDefaultLocation().content(true)).booleanValue()) {
                nestedModel.setBooleanProperty("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION", true);
                newProjectDataModel.setBooleanProperty("IPluginProjectDataModelProperties.LIFERAY_USE_SDK_LOCATION", false);
                newProjectDataModel.setBooleanProperty("IPluginProjectDataModelProperties.LIFERAY_USE_WORKSPACE_LOCATION", true);
            } else {
                nestedModel.setBooleanProperty("IProjectCreationPropertiesNew.USE_DEFAULT_LOCATION", false);
                nestedModel.setStringProperty("IProjectCreationPropertiesNew.USER_DEFINED_LOCATION", ((org.eclipse.sapphire.modeling.Path)op.getLocation().content(true)).toOSString());
                if (!((Boolean)op.getUseDefaultLocation().content(true)).booleanValue()) {
                    newProjectDataModel.setBooleanProperty("IPluginProjectDataModelProperties.LIFERAY_USE_CUSTOM_LOCATION", true);
                }
            }
        }
        ProjectUtil.setGenerateDD(newProjectDataModel, false);
        IPath webXmlPath = projectRecord.getProjectLocation().append("docroot/WEB-INF/web.xml");
        if (projectRecord.getProjectName().endsWith("-portlet")) {
            newProjectDataModel.setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_PORTLET", (Object)true);
            if (!webXmlPath.toFile().exists()) {
                ProjectUtil.createDefaultWebXml(webXmlPath.toFile(), projectRecord.getProjectName());
            }
        } else if (projectRecord.getProjectName().endsWith("-hook")) {
            newProjectDataModel.setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_HOOK", (Object)true);
            if (!webXmlPath.toFile().exists()) {
                ProjectUtil.createDefaultWebXml(webXmlPath.toFile(), projectRecord.getProjectName());
            }
        } else if (projectRecord.getProjectName().endsWith("-ext")) {
            webXmlPath = webXmlPath.removeLastSegments(3).append((IPath)new Path("docroot/WEB-INF/ext-web/docroot/WEB-INF/web.xml"));
            newProjectDataModel.setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_EXT", (Object)true);
            if (!webXmlPath.toFile().exists()) {
                ProjectUtil.createDefaultWebXml(webXmlPath.toFile(), projectRecord.getProjectName());
            }
        } else if (projectRecord.getProjectName().endsWith("-layouttpl")) {
            newProjectDataModel.setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_LAYOUTTPL", (Object)true);
        } else if (projectRecord.getProjectName().endsWith("-theme")) {
            newProjectDataModel.setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_THEME", (Object)true);
        } else if (projectRecord.getProjectName().endsWith("-web")) {
            newProjectDataModel.setProperty("IPluginProjectDataModelProperties.PLUGIN_TYPE_WEB", (Object)true);
        }
        IFacetedProjectWorkingCopy fpwc = (IFacetedProjectWorkingCopy)newProjectDataModel.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        fpwc.setProjectName(projectRecord.getProjectName());
        IPath projectLocation = projectRecord.getProjectLocation();
        String projectDirName = projectLocation.lastSegment();
        fpwc.setProjectLocation(projectRecord.getProjectLocation());
        String pluginType = null;
        if (op != null) {
            pluginType = ((PluginType)((Object)op.getPluginType().content())).name();
            if (PluginType.theme.name().equals(pluginType)) {
                newProjectDataModel.setProperty("IPluginProjectDataModelProperties.THEME_PARENT", op.getThemeParent().content(true));
                newProjectDataModel.setProperty("IPluginProjectDataModelProperties.THEME_TEMPLATE_FRAMEWORK", op.getThemeFramework().content(true));
            }
        } else {
            pluginType = ProjectUtil.guessPluginType(fpwc);
        }
        SDKPluginFacetUtil.configureProjectAsRuntimeProject(fpwc, runtime, pluginType, sdkLocation, projectRecord);
        if (op != null && PluginType.portlet.name().equals(pluginType)) {
            IPortletFramework portletFramework = (IPortletFramework)op.getPortletFramework().content(true);
            portletFramework.configureNewProject(newProjectDataModel, fpwc);
        }
        if (CoreUtil.getWorkspaceRoot().getLocation().append(projectDirName).equals((Object)projectLocation)) {
            fpwc.setProjectLocation(null);
        }
        fpwc.commitChanges(monitor);
        return fpwc.getProject();
    }

    public static IProject createExistingProject(ProjectRecord record, final IPath sdkLocation, IProgressMonitor monitor) throws CoreException {
        String projectName = record.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (record.description == null) {
            record.description = workspace.newProjectDescription(projectName);
            Path locationPath = new Path(record.projectSystemFile.getAbsolutePath());
            if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                record.description.setLocation(null);
            } else {
                record.description.setLocation((IPath)locationPath);
            }
        } else {
            record.description.setName(projectName);
        }
        project.create(record.description, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
        project.open(1, (IProgressMonitor)new SubProgressMonitor(monitor, 70));
        if (project.getName().endsWith("-ext")) {
            ProjectUtil.fixExtProjectClasspathEntries(project);
        }
        IFacetedProject fProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        FacetedProjectWorkingCopy fpwc = new FacetedProjectWorkingCopy(fProject);
        String pluginType = ProjectUtil.guessPluginType((IFacetedProjectWorkingCopy)fpwc);
        SDKPluginFacetUtil.configureProjectAsSDKProject((IFacetedProjectWorkingCopy)fpwc, pluginType, sdkLocation.toPortableString(), record);
        fpwc.commitChanges(monitor);
        final IJavaProject javaProject = JavaCore.create((IProject)fProject.getProject());
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ArrayList<IClasspathEntry> rawClasspaths = new ArrayList<IClasspathEntry>();
                IPath containerPath = null;
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 5 && entry.getPath().segment(0).equals("com.liferay.ide.sdk.container")) {
                        containerPath = entry.getPath();
                        break;
                    }
                    if (!ProjectUtil.isLiferayRuntimePluginClassPath(entry)) {
                        rawClasspaths.add(entry);
                    }
                    ++n2;
                }
                if (containerPath != null) {
                    JavaCore.getClasspathContainerInitializer((String)"com.liferay.ide.sdk.container").initialize(containerPath, javaProject);
                } else {
                    IClasspathEntry[] entries;
                    javaProject.setRawClasspath(rawClasspaths.toArray(new IClasspathEntry[rawClasspaths.size()]), (IProgressMonitor)new NullProgressMonitor());
                    javaProject.setRawClasspath(rawClasspaths.toArray(new IClasspathEntry[rawClasspaths.size()]), (IProgressMonitor)new NullProgressMonitor());
                    IAccessRule[] accessRules = new IAccessRule[]{};
                    IClasspathAttribute[] attributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.nondependency", (String)"")};
                    Path cpePath = new Path("com.liferay.ide.sdk.container");
                    IClasspathEntry newEntry = JavaCore.newContainerEntry((IPath)cpePath, (IAccessRule[])accessRules, (IClasspathAttribute[])attributes, (boolean)false);
                    IClasspathEntry[] iClasspathEntryArray2 = entries = javaProject.getRawClasspath();
                    int n3 = entries.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathEntry entry = iClasspathEntryArray2[n4];
                        if (entry.getPath().equals((Object)cpePath)) {
                            return;
                        }
                        ++n4;
                    }
                    IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
                    System.arraycopy(entries, 0, newEntries, 0, entries.length);
                    newEntries[entries.length] = newEntry;
                    javaProject.setRawClasspath(newEntries, monitor);
                }
                monitor.done();
                SDK sdk = SDKUtil.createSDKFromLocation((IPath)sdkLocation);
                SDKUtil.openAsProject((SDK)sdk);
            }
        }, monitor);
        return project;
    }

    private static boolean isLiferayRuntimePluginClassPath(IClasspathEntry entry) {
        boolean retval = false;
        if (entry.getEntryKind() == 5) {
            String[] stringArray = entry.getPath().segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if (path.equals("com.liferay.ide.eclipse.server.plugin.container") || path.equals("com.liferay.studio.server.tomcat.runtimeClasspathProvider") || path.equals("com.liferay.ide.eclipse.server.tomcat.runtimeClasspathProvider")) {
                    retval = true;
                    break;
                }
                ++n2;
            }
        }
        return retval;
    }

    private static void fixExtProjectClasspathEntries(IProject project) {
        try {
            IClasspathEntry[] entries;
            boolean fixedAttr = false;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                IClasspathEntry newEntry = null;
                if (entry.getEntryKind() == 3) {
                    ArrayList<Object> newAttrs = new ArrayList<Object>();
                    Object[] attrs = entry.getExtraAttributes();
                    if (!CoreUtil.isNullOrEmpty((Object[])attrs)) {
                        Object[] objectArray = attrs;
                        int n3 = attrs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object attr = objectArray[n4];
                            Object newAttr = null;
                            if ("owner.project.facets".equals(attr.getName()) && "liferay.plugin".equals(attr.getValue())) {
                                newAttr = JavaCore.newClasspathAttribute((String)attr.getName(), (String)"liferay.ext");
                                fixedAttr = true;
                            } else {
                                newAttr = attr;
                            }
                            newAttrs.add(newAttr);
                            ++n4;
                        }
                        newEntry = JavaCore.newSourceEntry((IPath)entry.getPath(), (IPath[])entry.getInclusionPatterns(), (IPath[])entry.getExclusionPatterns(), (IPath)entry.getOutputLocation(), (IClasspathAttribute[])newAttrs.toArray(new IClasspathAttribute[0]));
                    }
                }
                if (newEntry == null) {
                    newEntry = entry;
                }
                newEntries.add(newEntry);
                ++n2;
            }
            if (fixedAttr) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[0]), (IProgressMonitor)monitor);
                try {
                    javaProject.getProject().refreshLocal(2, (IProgressMonitor)monitor);
                }
                catch (Exception e) {
                    ProjectCore.logError(e);
                }
            }
            ProjectUtil.fixExtProjectSrcFolderLinks(project);
        }
        catch (Exception ex) {
            ProjectCore.logError("Exception trying to fix Ext project classpath entries.", ex);
        }
    }

    public static void fixExtProjectSrcFolderLinks(IProject extProject) throws JavaModelException {
        IVirtualFolder jsrc;
        IVirtualComponent c;
        IJavaProject javaProject;
        if (extProject != null && (javaProject = JavaCore.create((IProject)extProject)) != null && (c = ComponentCore.createComponent((IProject)extProject, (boolean)false)) != null && (jsrc = c.getRootFolder().getFolder("/WEB-INF/classes")) != null) {
            IClasspathEntry[] cp = javaProject.getRawClasspath();
            int i = 0;
            while (i < cp.length) {
                IClasspathEntry cpe = cp[i];
                if (cpe.getEntryKind() == 3 && cpe.getPath().removeFirstSegments(1).segmentCount() > 0) {
                    try {
                        IFolder srcFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(cpe.getPath());
                        IVirtualResource[] virtualResource = ComponentCore.createResources((IResource)srcFolder);
                        if (virtualResource.length == 0) {
                            jsrc.createLink(cpe.getPath().removeFirstSegments(1), 0, null);
                        }
                    }
                    catch (Exception e) {
                        ProjectCore.logError(e);
                    }
                }
                ++i;
            }
        }
    }

    public static IFacetedProject getFacetedProject(IProject project) {
        try {
            return ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static Set<IProjectFacetVersion> getFacetsForPreset(String presetId) {
        IPreset preset = ProjectFacetsManager.getPreset((String)presetId);
        return preset.getProjectFacets();
    }

    public static IProjectFacet getLiferayFacet(IFacetedProject facetedProject) {
        for (IProjectFacetVersion projectFacet : facetedProject.getProjectFacets()) {
            if (!ProjectUtil.isLiferayFacet(projectFacet.getProjectFacet())) continue;
            return projectFacet.getProjectFacet();
        }
        return null;
    }

    public static String getLiferayPluginType(String projectLocation) {
        if (ProjectUtil.isLiferaySDKProjectDir(new File(projectLocation))) {
            String suffix = "";
            if (projectLocation.endsWith("-portlet")) {
                suffix = "-portlet";
            } else if (projectLocation.endsWith("-hook")) {
                suffix = "-hook";
            } else if (projectLocation.endsWith("-ext")) {
                suffix = "-ext";
            } else if (projectLocation.endsWith("-layouttpl")) {
                suffix = "-layouttpl";
            } else if (projectLocation.endsWith("-theme")) {
                suffix = "-theme";
            } else if (projectLocation.endsWith("-web")) {
                suffix = "-web";
            }
            return suffix.replace("-", "");
        }
        return null;
    }

    public static IFile getPortletXmlFile(IProject project) {
        IFile portletXml;
        IFolder defaultDocrootFolder;
        IWebProject webProject;
        if (project != null && ProjectUtil.isLiferayFacetedProject(project) && (webProject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)project)) != null && (defaultDocrootFolder = webProject.getDefaultDocrootFolder()) != null && (portletXml = defaultDocrootFolder.getFile((IPath)new Path("WEB-INF/portlet.xml"))) != null && portletXml.exists()) {
            return portletXml;
        }
        return null;
    }

    public static IProject getProject(IDataModel model) {
        if (model != null) {
            String projectName = model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
            return CoreUtil.getProject((String)projectName);
        }
        return null;
    }

    public static IProject getProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static ProjectRecord getProjectRecordForDir(String dir) {
        ProjectRecord projectRecord = null;
        File projectDir = new File(dir);
        if (ProjectUtil.isLiferaySDKProjectDir(projectDir)) {
            String[] files;
            String[] stringArray = files = projectDir.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                if (".project".equals(file)) {
                    projectRecord = new ProjectRecord(new File(projectDir, file));
                }
                ++n2;
            }
            if (projectRecord == null) {
                projectRecord = new ProjectRecord(projectDir);
            }
        }
        return projectRecord;
    }

    public static String getRelativePathFromDocroot(IWebProject lrproject, String path) {
        Path pathValue = new Path(path);
        IFolder docroot = lrproject.getDefaultDocrootFolder();
        IPath relativePath = pathValue.makeRelativeTo(docroot.getFullPath());
        String retval = relativePath.toPortableString();
        return retval.startsWith("/") ? retval : "/" + retval;
    }

    public static String getRequiredSuffix(IProject project) {
        String requiredSuffix = null;
        if (ProjectUtil.isPortletProject(project)) {
            requiredSuffix = "-portlet";
        } else if (ProjectUtil.isHookProject(project)) {
            requiredSuffix = "-hook";
        } else if (ProjectUtil.isExtProject(project)) {
            requiredSuffix = "-ext";
        } else if (ProjectUtil.isLayoutTplProject(project)) {
            requiredSuffix = "-layouttpl";
        } else if (ProjectUtil.isThemeProject(project)) {
            requiredSuffix = "-theme";
        }
        return requiredSuffix;
    }

    public static String guessPluginType(IFacetedProjectWorkingCopy fpwc) {
        String pluginType = null;
        String projName = fpwc.getProjectName();
        IPath location = fpwc.getProjectLocation();
        String directoryName = "";
        if (location != null) {
            directoryName = location.lastSegment();
        }
        if (projName.endsWith("-portlet") || directoryName.endsWith("-portlet")) {
            pluginType = "portlet";
        } else if (projName.endsWith("-hook") || directoryName.endsWith("-hook")) {
            pluginType = "hook";
        } else if (projName.endsWith("-ext") || directoryName.endsWith("-ext")) {
            pluginType = "ext";
        } else if (projName.endsWith("-layouttpl") || directoryName.endsWith("-layouttpl")) {
            pluginType = "layouttpl";
        } else if (projName.endsWith("-theme") || directoryName.endsWith("-theme")) {
            pluginType = "theme";
        } else if (projName.endsWith("-web") || directoryName.endsWith("-web")) {
            pluginType = "web";
        }
        return pluginType;
    }

    public static IProject[] getAllPluginsSDKProjects() {
        IProject[] projects;
        ArrayList<IProject> sdkProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (ProjectUtil.isLiferayFacetedProject(project) && SDKUtil.isSDKProject((IProject)project)) {
                sdkProjects.add(project);
            }
            ++n2;
        }
        return sdkProjects.toArray(new IProject[sdkProjects.size()]);
    }

    public static boolean hasFacet(IProject project, IProjectFacet checkProjectFacet) {
        boolean retval;
        block4: {
            retval = false;
            if (project == null || checkProjectFacet == null) {
                return retval;
            }
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject == null || checkProjectFacet == null) break block4;
                for (IProjectFacetVersion facet : facetedProject.getProjectFacets()) {
                    IProjectFacet projectFacet = facet.getProjectFacet();
                    if (!checkProjectFacet.equals(projectFacet)) continue;
                    retval = true;
                    break;
                }
            }
            catch (CoreException coreException) {}
        }
        return retval;
    }

    public static boolean hasFacet(IProject project, String facetId) {
        return ProjectUtil.hasFacet(project, ProjectFacetsManager.getProjectFacet((String)facetId));
    }

    public static boolean hasProperty(IDataModel model, String propertyName) {
        boolean retval = false;
        if (model == null || CoreUtil.isNullOrEmpty((String)propertyName)) {
            return retval;
        }
        for (Object property : model.getAllProperties()) {
            if (!propertyName.equals(property)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    public static boolean isDynamicWebFacet(IProjectFacet facet) {
        return facet != null && facet.getId().equals("jst.web");
    }

    public static boolean isDynamicWebFacet(IProjectFacetVersion facetVersion) {
        return facetVersion != null && ProjectUtil.isDynamicWebFacet(facetVersion.getProjectFacet());
    }

    public static boolean isExtProject(IProject project) {
        return ProjectUtil.hasFacet(project, IPluginFacetConstants.LIFERAY_EXT_PROJECT_FACET);
    }

    public static boolean isHookProject(IProject project) {
        return ProjectUtil.hasFacet(project, IPluginFacetConstants.LIFERAY_HOOK_PROJECT_FACET);
    }

    public static boolean isJavaFacet(IProjectFacet facet) {
        return facet != null && (facet.getId().equals("java") || facet.getId().equals("jst.java"));
    }

    public static boolean isJavaFacet(IProjectFacetVersion facetVersion) {
        return facetVersion != null && ProjectUtil.isJavaFacet(facetVersion.getProjectFacet());
    }

    public static boolean isLayoutTplProject(IProject project) {
        return ProjectUtil.hasFacet(project, "liferay.layouttpl");
    }

    public static boolean isLiferayFacet(IProjectFacet projectFacet) {
        return projectFacet != null && projectFacet.getId().startsWith("liferay.");
    }

    public static boolean isLiferayFacet(IProjectFacetVersion projectFacetVersion) {
        return projectFacetVersion != null && ProjectUtil.isLiferayFacet(projectFacetVersion.getProjectFacet());
    }

    public static boolean isLiferayFacetedProject(IProject project) {
        boolean retval;
        block4: {
            retval = false;
            if (project == null) {
                return retval;
            }
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject == null) break block4;
                for (IProjectFacetVersion facet : facetedProject.getProjectFacets()) {
                    IProjectFacet projectFacet = facet.getProjectFacet();
                    if (!ProjectUtil.isLiferayFacet(projectFacet)) continue;
                    retval = true;
                    break;
                }
            }
            catch (Exception exception) {}
        }
        return retval;
    }

    public static boolean isLiferayPluginType(String type) {
        return type != null && ("-portlet".endsWith(type) || "-hook".endsWith(type) || "-ext".endsWith(type) || "-layouttpl".endsWith(type) || "-theme".endsWith(type) || "-web".endsWith(type));
    }

    public static boolean isLiferaySDKProject(IFolder folder) {
        return folder != null && folder.exists() && folder.getRawLocation() != null && ProjectUtil.isLiferaySDKProjectDir(folder.getRawLocation().toFile());
    }

    public static boolean isLiferaySDKProjectDir(File file) {
        if (file != null && file.isDirectory() && ProjectUtil.isValidLiferayProjectDir(file)) {
            File[] contents = file.listFiles();
            boolean hasBuildXml = false;
            boolean hasDocroot = false;
            File[] fileArray = contents;
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                File content = fileArray[n2];
                if (content.getName().equals("build.xml")) {
                    hasBuildXml = true;
                } else if (content.getName().equals("docroot")) {
                    hasDocroot = true;
                }
                ++n2;
            }
            if (hasBuildXml && hasDocroot) {
                return true;
            }
        }
        return false;
    }

    public static boolean isMavenProject(IProject project) {
        boolean retval = false;
        try {
            if (project != null) {
                retval = project.hasNature("org.eclipse.m2e.core.maven2Nature") && project.getFile("pom.xml").exists();
            }
        }
        catch (Exception exception) {}
        return retval;
    }

    public static boolean isParent(IFolder folder, IResource resource) {
        if (folder == null || resource == null) {
            return false;
        }
        if (resource.getParent() != null && resource.getParent().equals((Object)folder)) {
            return true;
        }
        boolean retval = ProjectUtil.isParent(folder, (IResource)resource.getParent());
        return retval;
    }

    public static boolean isPortletProject(IProject project) {
        return ProjectUtil.hasFacet(project, IPluginFacetConstants.LIFERAY_PORTLET_PROJECT_FACET);
    }

    public static boolean isThemeProject(IProject project) {
        return ProjectUtil.hasFacet(project, "liferay.theme");
    }

    public static boolean isWebProject(IProject project) {
        return ProjectUtil.hasFacet(project, "liferay.web");
    }

    public static boolean isValidLiferayProjectDir(File dir) {
        String name = dir.getName();
        return name.endsWith("-portlet") || name.endsWith("-ext") || name.endsWith("-hook") || name.endsWith("-theme") || name.endsWith("-layouttpl") || name.endsWith("-web");
    }

    public static String removePluginSuffix(String string) {
        if (string == null) {
            return null;
        }
        String regex = null;
        if (string.endsWith("-portlet")) {
            regex = "-portlet$";
        } else if (string.endsWith("-hook")) {
            regex = "-hook$";
        } else if (string.endsWith("-ext")) {
            regex = "-ext$";
        } else if (string.endsWith("-layouttpl")) {
            regex = "-layouttpl$";
        } else if (string.endsWith("-theme")) {
            regex = "-theme$";
        } else if (string.endsWith("-web")) {
            regex = "-web$";
        } else {
            return string;
        }
        return string.replaceFirst(regex, "");
    }

    public static void setDefaultRuntime(IDataModel dataModel) {
        DataModelPropertyDescriptor[] validDescriptors;
        DataModelPropertyDescriptor[] dataModelPropertyDescriptorArray = validDescriptors = dataModel.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        int n = validDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            DataModelPropertyDescriptor desc = dataModelPropertyDescriptorArray[n2];
            Object runtime = desc.getPropertyValue();
            if (runtime instanceof BridgedRuntime && ServerUtil.isLiferayRuntime((BridgedRuntime)((BridgedRuntime)runtime))) {
                dataModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", runtime);
                break;
            }
            ++n2;
        }
    }

    public static void setGenerateDD(IDataModel model, boolean generateDD) {
        IDataModel ddModel = null;
        if (ProjectUtil.hasProperty(model, "IJ2EEFacetInstallDataModelProperties.GENERATE_DD")) {
            ddModel = model;
        } else if (ProjectUtil.hasProperty(model, "IFacetProjectCreationDataModelProperties.FACET_DM_MAP")) {
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            ddModel = map.getFacetDataModel(IJ2EEFacetConstants.DYNAMIC_WEB_FACET.getId());
        }
        if (ddModel != null) {
            ddModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", generateDD);
        }
    }

    private static class Msgs
    extends NLS {
        public static String checking;
        public static String importingProject;

        static {
            Msgs.initializeMessages((String)ProjectUtil.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

