/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.service.ui.editor;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class ServiceMethodHyperlink
implements IHyperlink {
    private final IMethod serviceMethod;
    private final SelectionDispatchAction openAction;
    private final boolean qualify;
    private final IRegion word;

    public ServiceMethodHyperlink(IRegion word, SelectionDispatchAction openAction, IMethod serviceMethod, boolean qualify) {
        this.word = word;
        this.openAction = openAction;
        this.serviceMethod = serviceMethod;
        this.qualify = qualify;
    }

    public IRegion getHyperlinkRegion() {
        return this.word;
    }

    public String getHyperlinkText() {
        String methodLabel = JavaElementLabels.getElementLabel((IJavaElement)this.serviceMethod, (long)JavaElementLabels.ALL_FULLY_QUALIFIED);
        return String.valueOf(this.getStaticText()) + (this.qualify ? " " + methodLabel : "");
    }

    protected String getStaticText() {
        return "Open Service";
    }

    public String getTypeLabel() {
        return null;
    }

    public IMethod method() {
        return this.serviceMethod;
    }

    public void open() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ServiceMethodHyperlink.this.openAction.run((IStructuredSelection)new StructuredSelection((Object)ServiceMethodHyperlink.this.serviceMethod));
            }
        };
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)runnable);
    }

    public IRegion wordRegion() {
        return this.word;
    }
}

