/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.IBundleProject;
import com.liferay.ide.maven.core.FacetedMavenProject;
import com.liferay.ide.maven.core.MavenBundlePluginProject;
import com.liferay.ide.maven.core.MavenProjectBuilder;
import com.liferay.ide.maven.core.MavenUtil;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.project.IMavenProjectFacade;

public class FacetedMavenBundleProject
extends FacetedMavenProject
implements IBundleProject {
    private final MavenBundlePluginProject bundleProject;

    public FacetedMavenBundleProject(IProject project) {
        super(project);
        this.bundleProject = new MavenBundlePluginProject(project);
    }

    public boolean filterResource(IPath resourcePath) {
        return this.bundleProject.filterResource(resourcePath);
    }

    public IPath getOutputBundle(boolean buildIfNeeded, IProgressMonitor monitor) throws CoreException {
        IPath targetFile;
        IPath outputJar = null;
        if (buildIfNeeded) {
            MavenProjectBuilder mavenProjectBuilder = new MavenProjectBuilder(this.getProject());
            List<String> goals = Arrays.asList("package");
            mavenProjectBuilder.execGoals(goals, monitor);
        }
        IMavenProjectFacade projectFacade = MavenUtil.getProjectFacade(this.getProject(), monitor);
        MavenProject mavenProject = projectFacade.getMavenProject(monitor);
        String targetName = String.valueOf(mavenProject.getBuild().getFinalName()) + ".war";
        IFolder targetFolder = this.getProject().getFolder("target");
        if (targetFolder.exists() && (targetFile = targetFolder.getRawLocation().append(targetName)).toFile().exists()) {
            outputJar = targetFile;
        }
        return outputJar;
    }

    public String getSymbolicName() throws CoreException {
        return this.bundleProject.getSymbolicName();
    }
}

