/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.LiferayMavenProjectProvider;
import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.project.core.IPortletFramework;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOpMethods;
import com.liferay.ide.project.core.model.NewLiferayProfile;
import com.liferay.ide.project.core.model.PluginType;
import com.liferay.ide.project.core.model.ProfileLocation;
import com.liferay.ide.project.core.model.ProjectName;
import com.liferay.ide.theme.core.util.ThemeUtil;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.cli.configuration.SettingsXmlConfigurationProcessor;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.archetype.ArchetypeManager;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class NewMavenPluginProjectProvider
extends LiferayMavenProjectProvider
implements NewLiferayProjectProvider<NewLiferayPluginProjectOp> {
    public IStatus createNewProject(NewLiferayPluginProjectOp op, IProgressMonitor monitor) throws CoreException {
        ProjectImportConfiguration configuration;
        List newProjects;
        ElementList projectNames = op.getProjectNames();
        Status retval = null;
        IMavenConfiguration mavenConfiguration = MavenPlugin.getMavenConfiguration();
        IMavenProjectRegistry mavenProjectRegistry = MavenPlugin.getMavenProjectRegistry();
        IProjectConfigurationManager projectConfigurationManager = MavenPlugin.getProjectConfigurationManager();
        String groupId = (String)op.getGroupId().content();
        String artifactId = (String)op.getProjectName().content();
        String version = (String)op.getArtifactVersion().content();
        String javaPackage = (String)op.getGroupId().content();
        String activeProfilesValue = (String)op.getActiveProfilesValue().content();
        IPortletFramework portletFramework = (IPortletFramework)op.getPortletFramework().content(true);
        String frameworkName = NewLiferayPluginProjectOpMethods.getFrameworkName((NewLiferayPluginProjectOp)op);
        IPath location = PathBridge.create((Path)((Path)op.getLocation().content()));
        if (location.lastSegment().equals(artifactId)) {
            location = location.removeLastSegments(1);
        }
        String archetypeArtifactId = (String)op.getArchetype().content(true);
        Archetype archetype = new Archetype();
        String[] gav = archetypeArtifactId.split(":");
        String archetypeVersion = gav[gav.length - 1];
        archetype.setGroupId(gav[0]);
        archetype.setArtifactId(gav[1]);
        archetype.setVersion(archetypeVersion);
        ArchetypeManager archetypeManager = MavenPluginActivator.getDefault().getArchetypeManager();
        ArtifactRepository remoteArchetypeRepository = archetypeManager.getArchetypeRepository(archetype);
        Properties properties = new Properties();
        try {
            List archProps = archetypeManager.getRequiredProperties(archetype, remoteArchetypeRepository, monitor);
            if (!CoreUtil.isNullOrEmpty((List)archProps)) {
                for (Object prop : archProps) {
                    if (!(prop instanceof RequiredProperty)) continue;
                    RequiredProperty rProp = (RequiredProperty)prop;
                    if (((PluginType)op.getPluginType().content()).equals((Object)PluginType.theme)) {
                        String key = rProp.getKey();
                        if (key.equals("themeParent")) {
                            properties.put(key, op.getThemeParent().content(true));
                            continue;
                        }
                        if (!key.equals("themeType")) continue;
                        properties.put(key, ThemeUtil.getTemplateExtension((String)((String)op.getThemeFramework().content(true))));
                        continue;
                    }
                    properties.put(rProp.getKey(), rProp.getDefaultValue());
                }
            }
        }
        catch (UnknownArchetype e1) {
            LiferayMavenCore.logError("Unable to find archetype required properties", e1);
        }
        ResolverConfiguration resolverConfig = new ResolverConfiguration();
        if (!CoreUtil.isNullOrEmpty((String)activeProfilesValue)) {
            resolverConfig.setSelectedProfiles(activeProfilesValue);
        }
        if (!CoreUtil.isNullOrEmpty((List)(newProjects = projectConfigurationManager.createArchetypeProjects(location, archetype, groupId, artifactId, version, javaPackage, properties, configuration = new ProjectImportConfiguration(resolverConfig), monitor)))) {
            for (IProject project : newProjects) {
                ((ProjectName)projectNames.insert()).setName(project.getName());
            }
        }
        if (CoreUtil.isNullOrEmpty((List)newProjects)) {
            retval = LiferayMavenCore.createErrorStatus("New project was not created due to unknown error");
        } else {
            IProject firstProject = (IProject)newProjects.get(0);
            if (!CoreUtil.isNullOrEmpty((String)activeProfilesValue)) {
                String[] activeProfiles;
                block31: {
                    activeProfiles = activeProfilesValue.split(",");
                    List<NewLiferayProfile> newUserSettingsProfiles = this.getNewProfilesToSave(activeProfiles, (List<NewLiferayProfile>)op.getNewLiferayProfiles(), ProfileLocation.userSettings);
                    if (newUserSettingsProfiles.size() > 0) {
                        String userSettingsFile = mavenConfiguration.getUserSettingsFile();
                        String userSettingsPath = null;
                        userSettingsPath = CoreUtil.isNullOrEmpty((String)userSettingsFile) ? SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE.getAbsolutePath() : userSettingsFile;
                        try {
                            File settingsXmlFile = new File(userSettingsPath);
                            File backupFile = this.getBackupFile(settingsXmlFile);
                            FileUtils.copyFile((File)settingsXmlFile, (File)backupFile);
                            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                            Iterator docBuilder = docFactory.newDocumentBuilder();
                            Document pomDocument = ((DocumentBuilder)((Object)docBuilder)).parse(settingsXmlFile.getCanonicalPath());
                            for (NewLiferayProfile newProfile : newUserSettingsProfiles) {
                                MavenUtil.createNewLiferayProfileNode(pomDocument, newProfile);
                            }
                            TransformerFactory transformerFactory = TransformerFactory.newInstance();
                            Transformer transformer = transformerFactory.newTransformer();
                            DOMSource source = new DOMSource(pomDocument);
                            StreamResult result = new StreamResult(settingsXmlFile);
                            transformer.transform(source, result);
                        }
                        catch (Exception e) {
                            LiferayMavenCore.logError("Unable to save new Liferay profile to user settings.xml.", e);
                        }
                    }
                    List<NewLiferayProfile> newProjectPomProfiles = this.getNewProfilesToSave(activeProfiles, (List<NewLiferayProfile>)op.getNewLiferayProfiles(), ProfileLocation.projectPom);
                    IMavenProjectFacade newMavenProject = mavenProjectRegistry.getProject(firstProject);
                    IFile pomFile = newMavenProject.getPom();
                    IDOMModel domModel = null;
                    try {
                        try {
                            domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(pomFile);
                            for (NewLiferayProfile newProfile : newProjectPomProfiles) {
                                MavenUtil.createNewLiferayProfileNode((Document)domModel.getDocument(), newProfile);
                            }
                            domModel.save();
                        }
                        catch (IOException e) {
                            LiferayMavenCore.logError("Unable to save new Liferay profiles to project pom.", e);
                            if (domModel != null) {
                                domModel.releaseFromEdit();
                            }
                            break block31;
                        }
                    }
                    catch (Throwable pomDocument) {
                        if (domModel != null) {
                            domModel.releaseFromEdit();
                        }
                        throw pomDocument;
                    }
                    if (domModel != null) {
                        domModel.releaseFromEdit();
                    }
                }
                for (IProject project : newProjects) {
                    try {
                        projectConfigurationManager.updateProjectConfiguration(new MavenUpdateRequest(project, mavenConfiguration.isOffline(), true), monitor);
                    }
                    catch (Exception e) {
                        LiferayMavenCore.logError("Unable to update configuration for " + project.getName(), e);
                    }
                }
                String pluginVersion = this.getNewLiferayProfilesPluginVersion(activeProfiles, (List<NewLiferayProfile>)op.getNewLiferayProfiles(), archetypeVersion);
                String archVersion = MavenUtil.getMajorMinorVersionOnly(archetypeVersion);
                this.updateDtdVersion(firstProject, pluginVersion, archVersion);
            }
            if (((PluginType)op.getPluginType().content()).equals((Object)PluginType.portlet)) {
                String portletName = (String)op.getPortletName().content(false);
                retval = portletFramework.postProjectCreated(firstProject, frameworkName, portletName, monitor);
            }
        }
        if (retval == null) {
            retval = Status.OK_STATUS;
        }
        return retval;
    }

    private File getBackupFile(File file) {
        String suffix = new SimpleDateFormat("yyyyMMddhhmmss").format(Calendar.getInstance().getTime());
        return new File(file.getParentFile(), String.valueOf(file.getName()) + "." + suffix);
    }

    public IStatus validateProjectLocation(String projectName, IPath path) {
        IStatus retval;
        block9: {
            retval = Status.OK_STATUS;
            if (CoreUtil.isNullOrEmpty((String)projectName)) {
                return retval;
            }
            File dir = path.toFile();
            if (dir.exists()) {
                File pomFile = path.append("pom.xml").toFile();
                if (pomFile.exists()) {
                    IMaven maven = MavenPlugin.getMaven();
                    try {
                        Model result = maven.readModel(pomFile);
                        if (!"pom".equals(result.getPackaging())) {
                            retval = LiferayMavenCore.createErrorStatus("\"" + pomFile.getParent() + "\" contains a non-parent maven project.");
                            break block9;
                        }
                        String name = result.getName();
                        if (projectName.equals(name)) {
                            retval = LiferayMavenCore.createErrorStatus("The project name \"" + projectName + "\" can't be the same as the parent.");
                            break block9;
                        }
                        IPath newProjectPath = path.append(projectName);
                        retval = this.validateProjectLocation(projectName, newProjectPath);
                    }
                    catch (CoreException e) {
                        retval = LiferayMavenCore.createErrorStatus("Invalid project location.", e);
                        LiferayMavenCore.log(retval);
                    }
                } else {
                    File[] files = dir.listFiles();
                    if (files.length > 0) {
                        retval = LiferayMavenCore.createErrorStatus("Project location is not empty or a parent pom.");
                    }
                }
            }
        }
        return retval;
    }
}

