/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core.aether;

import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.maven.core.aether.ConsoleRepositoryListener;
import com.liferay.ide.maven.core.aether.ConsoleTransferListener;
import java.util.List;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.version.Version;
import org.eclipse.m2e.core.internal.MavenPluginActivator;

public class AetherUtil {
    public static Artifact getLatestAvailableArtifact(String gavCoords) {
        Artifact retval = null;
        RepositorySystem system = AetherUtil.newRepositorySystem();
        DefaultRepositorySystemSession session = AetherUtil.newRepositorySystemSession(system);
        String latestVersion = AetherUtil.getLatestVersion(gavCoords, system, (RepositorySystemSession)session);
        String[] gav = gavCoords.split(":");
        DefaultArtifact defaultArtifact = new DefaultArtifact(String.valueOf(gav[0]) + ":" + gav[1] + ":" + latestVersion);
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)defaultArtifact);
        artifactRequest.addRepository(AetherUtil.newCentralRepository());
        try {
            ArtifactResult artifactResult = system.resolveArtifact((RepositorySystemSession)session, artifactRequest);
            retval = artifactResult.getArtifact();
        }
        catch (ArtifactResolutionException e) {
            LiferayMavenCore.logError("Unable to get latest Liferay archetype", e);
            artifactRequest.setArtifact((Artifact)new DefaultArtifact(gavCoords));
            try {
                retval = system.resolveArtifact((RepositorySystemSession)session, artifactRequest).getArtifact();
            }
            catch (ArtifactResolutionException e1) {
                LiferayMavenCore.logError("Unable to get default Liferay archetype", e1);
            }
        }
        if (retval == null) {
            retval = defaultArtifact;
        }
        return retval;
    }

    public static String getLatestVersion(String gavCoords, RepositorySystem system, RepositorySystemSession session) {
        String retval = null;
        String[] gav = gavCoords.split(":");
        if (gav == null || gav.length != 3) {
            throw new IllegalArgumentException("gavCoords should be group:artifactId:version");
        }
        DefaultArtifact artifact = new DefaultArtifact(String.valueOf(gav[0]) + ":" + gav[1] + ":[" + gav[2] + ",)");
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact((Artifact)artifact);
        rangeRequest.addRepository(AetherUtil.newCentralRepository());
        try {
            VersionRangeResult rangeResult = system.resolveVersionRange(session, rangeRequest);
            Version newestVersion = rangeResult.getHighestVersion();
            List versions = rangeResult.getVersions();
            if (versions.size() > 1 && newestVersion.toString().endsWith("-SNAPSHOT")) {
                retval = ((Version)versions.get(versions.size() - 2)).toString();
            } else if (newestVersion != null) {
                retval = newestVersion.toString();
            }
        }
        catch (VersionRangeResolutionException e) {
            LiferayMavenCore.logError("Unable to get latest artifact version.", e);
        }
        if (retval == null) {
            retval = gav[2];
        }
        return retval;
    }

    public static RemoteRepository newCentralRepository() {
        return new RemoteRepository.Builder("central", "default", "http://repo1.maven.org/maven2/").build();
    }

    public static RemoteRepository newLiferayRepository() {
        return new RemoteRepository.Builder("liferay", "default", "https://repository.liferay.com/nexus/content/groups/public/").build();
    }

    public static RepositorySystem newRepositorySystem() {
        return MavenPluginActivator.getDefault().getRepositorySystem();
    }

    public static DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(MavenUtil.getLocalRepositoryDir());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setTransferListener((TransferListener)new ConsoleTransferListener());
        session.setRepositoryListener((RepositoryListener)new ConsoleRepositoryListener());
        return session;
    }
}

