/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import com.liferay.ide.server.ui.LiferayServerUI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.commons.notifications.core.AbstractNotification;
import org.eclipse.mylyn.commons.notifications.ui.AbstractUiNotification;
import org.eclipse.mylyn.commons.notifications.ui.NotificationsUi;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Base;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.IStartup;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.Runtime;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.XMLMemento;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.osgi.service.prefs.BackingStoreException;

public class ServerStartup
implements IStartup {
    private static final String GLOBAL_SETTINGS_CHECKED = "global-settings-checked";

    private AbstractNotification createImportGlobalSettingsNotification() {
        final Date date = new Date();
        return new AbstractUiNotification("com.liferay.ide.server.ui.importglobalsettings"){

            public Object getAdapter(Class adapter) {
                return null;
            }

            public Date getDate() {
                return date;
            }

            public String getDescription() {
                return "Click above to learn more about importing those settings.";
            }

            public String getLabel() {
                return "Previous Liferay IDE settings have been detected";
            }

            public Image getNotificationImage() {
                return LiferayServerUI.getDefault().getImageRegistry().get("imgNotification");
            }

            public Image getNotificationKindImage() {
                return null;
            }

            public void open() {
                boolean importSettings = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Previous Liferay IDE Settings Detected", (String)"Settings from a previous Liferay IDE workspace have been detected such as: Plugins SDKS, Liferay runtimes, or Liferay servers. Do you want to import these settings now?");
                if (importSettings) {
                    ServerStartup.this.importGlobalSettings();
                }
            }
        };
    }

    private SDK createSDKfromMemento(IMemento memento) {
        SDK sdk = new SDK();
        sdk.setName(memento.getString("name"));
        sdk.setLocation(Path.fromPortableString((String)memento.getString("location")).makeAbsolute());
        return sdk;
    }

    private boolean hasGlobalSettings() {
        File globalSettingsDir = LiferayCore.GLOBAL_SETTINGS_PATH.toFile();
        if (globalSettingsDir.exists()) {
            File[] settings = globalSettingsDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".xml");
                }
            });
            return settings != null && settings.length > 0;
        }
        return false;
    }

    private void importGlobalRuntimes(File runtimesFile) {
        block7: {
            try {
                IMemento runtimesMemento = XMLMemento.loadMemento((InputStream)new FileInputStream(runtimesFile));
                if (runtimesMemento == null) break block7;
                ResourceManager resourceManager = ResourceManager.getInstance();
                Object[] mementos = runtimesMemento.getChildren("runtime");
                if (CoreUtil.isNullOrEmpty((Object[])mementos)) break block7;
                Object[] objectArray = mementos;
                int n = mementos.length;
                int n2 = 0;
                while (n2 < n) {
                    Object memento = objectArray[n2];
                    Runtime runtime = new Runtime(null);
                    try {
                        Method loadFromMemento = Base.class.getDeclaredMethod("loadFromMemento", IMemento.class, IProgressMonitor.class);
                        if (loadFromMemento != null) {
                            Method addRuntime;
                            loadFromMemento.setAccessible(true);
                            loadFromMemento.invoke((Object)runtime, memento, null);
                            if (ServerCore.findRuntime((String)runtime.getId()) == null && (addRuntime = ResourceManager.class.getDeclaredMethod("addRuntime", IRuntime.class)) != null) {
                                addRuntime.setAccessible(true);
                                addRuntime.invoke((Object)resourceManager, runtime);
                            }
                        }
                    }
                    catch (Exception e) {
                        LiferayServerUI.logError("Unable to load runtime from memento", e);
                    }
                    ++n2;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
    }

    private void importGlobalSDKs(File sdksFile) {
        try {
            Object[] sdks;
            SDKManager manager = SDKManager.getInstance();
            IMemento sdksMemento = XMLMemento.loadMemento((InputStream)new FileInputStream(sdksFile));
            if (sdksMemento != null && !CoreUtil.isNullOrEmpty((Object[])(sdks = sdksMemento.getChildren("sdk")))) {
                Object[] objectArray = sdks;
                int n = sdks.length;
                int n2 = 0;
                while (n2 < n) {
                    SDK existingSDK;
                    Object sdkMemento = objectArray[n2];
                    SDK newSDK = this.createSDKfromMemento((IMemento)sdkMemento);
                    if (newSDK != null && (existingSDK = manager.getSDK(newSDK.getName())) == null) {
                        manager.addSDK(newSDK);
                    }
                    ++n2;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    private void importGlobalServers(File serversFile) {
        block7: {
            try {
                IMemento serversMemento = XMLMemento.loadMemento((InputStream)new FileInputStream(serversFile));
                if (serversMemento == null) break block7;
                ResourceManager resourceManager = ResourceManager.getInstance();
                Object[] mementos = serversMemento.getChildren("server");
                if (CoreUtil.isNullOrEmpty((Object[])mementos)) break block7;
                Object[] objectArray = mementos;
                int n = mementos.length;
                int n2 = 0;
                while (n2 < n) {
                    Object memento = objectArray[n2];
                    Server server = new Server(null);
                    try {
                        Method loadFromMemento = Base.class.getDeclaredMethod("loadFromMemento", IMemento.class, IProgressMonitor.class);
                        if (loadFromMemento != null) {
                            Method addServer;
                            loadFromMemento.setAccessible(true);
                            loadFromMemento.invoke((Object)server, memento, null);
                            if (ServerCore.findServer((String)server.getId()) == null && (addServer = ResourceManager.class.getDeclaredMethod("addServer", IServer.class)) != null) {
                                addServer.setAccessible(true);
                                addServer.invoke((Object)resourceManager, server);
                                IServerWorkingCopy wc = server.createWorkingCopy();
                                ServerDelegate delegate = (ServerDelegate)wc.loadAdapter(ServerDelegate.class, null);
                                delegate.importRuntimeConfiguration(wc.getRuntime(), null);
                                wc.save(true, null);
                            }
                        }
                    }
                    catch (Exception e) {
                        LiferayServerUI.logError("Unable to load server from memento", e);
                    }
                    ++n2;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
    }

    private void importGlobalSettings() {
        File settingsDir = LiferayCore.GLOBAL_SETTINGS_PATH.toFile();
        if (settingsDir.exists()) {
            File servers;
            File runtimes;
            File sdks = new File(settingsDir, "sdks.xml");
            if (sdks.exists()) {
                this.importGlobalSDKs(sdks);
            }
            if ((runtimes = new File(settingsDir, "runtimes.xml")).exists()) {
                this.importGlobalRuntimes(runtimes);
            }
            if ((servers = new File(settingsDir, "servers.xml")).exists()) {
                this.importGlobalServers(servers);
            }
        }
    }

    private boolean shouldCheckForGlobalSettings() {
        return false;
    }

    public void startup() {
        if (this.shouldCheckForGlobalSettings() && this.hasGlobalSettings()) {
            NotificationsUi.getService().notify(Collections.singletonList(this.createImportGlobalSettingsNotification()));
            try {
                IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.liferay.ide.server.ui");
                prefs.putBoolean(GLOBAL_SETTINGS_CHECKED, true);
                prefs.flush();
            }
            catch (BackingStoreException e) {
                LiferayServerUI.logError("Unable to persist global-setting-checked pref", (Exception)((Object)e));
            }
        }
    }
}

