/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.editor;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.StringUtil;
import com.liferay.ide.server.core.portal.PortalServer;
import com.liferay.ide.server.core.portal.PortalServerConstants;
import com.liferay.ide.server.ui.cmd.SetDeveloperModeCommand;
import com.liferay.ide.server.ui.cmd.SetExternalPropertiesCommand;
import com.liferay.ide.server.ui.cmd.SetLaunchSettingsCommand;
import com.liferay.ide.server.ui.cmd.SetMemoryArgsCommand;
import com.liferay.ide.server.util.ServerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.util.PublishAdapter;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class PortalServerLaunchEditorSection
extends ServerEditorSection {
    protected Section section;
    protected PortalServer portalServer;
    protected Hyperlink setDefault;
    protected boolean defaultDeployDirIsSet;
    protected Text memoryArgs;
    protected Text externalProperties;
    protected Button developerMode;
    protected Button externalPropertiesBrowse;
    protected Button defaultLaunchSettings;
    protected Button customLaunchSettings;
    protected boolean updating;
    protected PropertyChangeListener listener;
    protected IPublishListener publishListener;
    protected IPath workspacePath;
    protected IPath defaultDeployPath;
    protected boolean allowRestrictedEditing;
    protected IPath tempDirPath;
    protected IPath installDirPath;

    protected void addChangeListeners() {
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (PortalServerLaunchEditorSection.this.updating) {
                    return;
                }
                PortalServerLaunchEditorSection.this.updating = true;
                if ("memoryArgs".equals(event.getPropertyName())) {
                    String s = (String)event.getNewValue();
                    PortalServerLaunchEditorSection.this.memoryArgs.setText(s);
                } else if ("externalProperties".equals(event.getPropertyName())) {
                    String s = (String)event.getNewValue();
                    PortalServerLaunchEditorSection.this.externalProperties.setText(s);
                } else if ("developerMode".equals(event.getPropertyName())) {
                    boolean s = (Boolean)event.getNewValue();
                    PortalServerLaunchEditorSection.this.developerMode.setSelection(s);
                } else if ("launchSettings".equals(event.getPropertyName())) {
                    boolean s = (Boolean)event.getNewValue();
                    PortalServerLaunchEditorSection.this.defaultLaunchSettings.setSelection(s);
                    PortalServerLaunchEditorSection.this.customLaunchSettings.setSelection(!s);
                }
                PortalServerLaunchEditorSection.this.validate();
                PortalServerLaunchEditorSection.this.updating = false;
            }
        };
        this.server.addPropertyChangeListener(this.listener);
        this.publishListener = new PublishAdapter(){

            public void publishFinished(IServer server2, IStatus status) {
                boolean flag = false;
                if (status.isOK() && server2.getModules().length == 0) {
                    flag = true;
                }
                if (flag != PortalServerLaunchEditorSection.this.allowRestrictedEditing) {
                    PortalServerLaunchEditorSection.this.allowRestrictedEditing = flag;
                }
            }
        };
        this.server.getOriginal().addPublishListener(this.publishListener);
    }

    private void applyDefaultPortalServerSetting(boolean useDefaultPortalSeverSetting) {
        if (useDefaultPortalSeverSetting) {
            this.developerMode.setEnabled(false);
            this.externalProperties.setEnabled(false);
            this.externalPropertiesBrowse.setEnabled(false);
            this.memoryArgs.setEnabled(false);
        } else {
            this.developerMode.setEnabled(true);
            this.externalProperties.setEnabled(true);
            this.externalPropertiesBrowse.setEnabled(true);
            this.memoryArgs.setEnabled(true);
        }
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        this.section = toolkit.createSection(parent, 458);
        this.section.setText(Msgs.liferayLaunch);
        this.section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)this.section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.wst.server.ui.seop0002");
        whs.setHelp((Control)this.section, "org.eclipse.wst.server.ui.seop0002");
        toolkit.paintBordersFor(composite);
        this.section.setClient((Control)composite);
        GridData data = new GridData(1, 0x1000000, false, false);
        this.defaultLaunchSettings = new Button(composite, 16);
        this.defaultLaunchSettings.setText(Msgs.defaultLaunchSettings);
        data = new GridData(1, 0x1000000, true, false, 3, 1);
        this.defaultLaunchSettings.setLayoutData((Object)data);
        this.defaultLaunchSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PortalServerLaunchEditorSection.this.updating = true;
                PortalServerLaunchEditorSection.this.execute((IUndoableOperation)new SetLaunchSettingsCommand(PortalServerLaunchEditorSection.this.server, PortalServerLaunchEditorSection.this.defaultLaunchSettings.getSelection()));
                PortalServerLaunchEditorSection.this.updating = false;
                PortalServerLaunchEditorSection.this.applyDefaultPortalServerSetting(PortalServerLaunchEditorSection.this.defaultLaunchSettings.getSelection());
                PortalServerLaunchEditorSection.this.customLaunchSettings.setSelection(!PortalServerLaunchEditorSection.this.defaultLaunchSettings.getSelection());
                PortalServerLaunchEditorSection.this.validate();
            }
        });
        this.customLaunchSettings = new Button(composite, 16);
        this.customLaunchSettings.setText(Msgs.customLaunchSettings);
        data = new GridData(1, 0x1000000, true, false, 3, 1);
        this.customLaunchSettings.setLayoutData((Object)data);
        this.customLaunchSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PortalServerLaunchEditorSection.this.updating = true;
                PortalServerLaunchEditorSection.this.execute((IUndoableOperation)new SetLaunchSettingsCommand(PortalServerLaunchEditorSection.this.server, !PortalServerLaunchEditorSection.this.customLaunchSettings.getSelection()));
                PortalServerLaunchEditorSection.this.updating = false;
                PortalServerLaunchEditorSection.this.applyDefaultPortalServerSetting(!PortalServerLaunchEditorSection.this.customLaunchSettings.getSelection());
                PortalServerLaunchEditorSection.this.defaultLaunchSettings.setSelection(!PortalServerLaunchEditorSection.this.customLaunchSettings.getSelection());
                PortalServerLaunchEditorSection.this.validate();
            }
        });
        Label label = this.createLabel(toolkit, composite, Msgs.memoryArgsLabel);
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.memoryArgs = toolkit.createText(composite, null);
        data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 300;
        this.memoryArgs.setLayoutData((Object)data);
        this.memoryArgs.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PortalServerLaunchEditorSection.this.updating) {
                    return;
                }
                PortalServerLaunchEditorSection.this.updating = true;
                PortalServerLaunchEditorSection.this.execute((IUndoableOperation)new SetMemoryArgsCommand(PortalServerLaunchEditorSection.this.server, PortalServerLaunchEditorSection.this.memoryArgs.getText().trim()));
                PortalServerLaunchEditorSection.this.updating = false;
                PortalServerLaunchEditorSection.this.validate();
            }
        });
        label = this.createLabel(toolkit, composite, "");
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        label = this.createLabel(toolkit, composite, Msgs.externalPropertiesLabel);
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.externalProperties = toolkit.createText(composite, null);
        data = new GridData(4, 0x1000000, false, false);
        data.widthHint = 150;
        this.externalProperties.setLayoutData((Object)data);
        this.externalProperties.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PortalServerLaunchEditorSection.this.updating) {
                    return;
                }
                PortalServerLaunchEditorSection.this.updating = true;
                PortalServerLaunchEditorSection.this.execute((IUndoableOperation)new SetExternalPropertiesCommand(PortalServerLaunchEditorSection.this.server, PortalServerLaunchEditorSection.this.externalProperties.getText().trim()));
                PortalServerLaunchEditorSection.this.updating = false;
                PortalServerLaunchEditorSection.this.validate();
            }
        });
        this.externalPropertiesBrowse = toolkit.createButton(composite, Msgs.editorBrowse, 8);
        this.externalPropertiesBrowse.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.externalPropertiesBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                FileDialog dialog = new FileDialog(PortalServerLaunchEditorSection.this.externalPropertiesBrowse.getShell());
                dialog.setFilterPath(PortalServerLaunchEditorSection.this.externalPropertiesBrowse.getText());
                String selectedFile = dialog.open();
                if (selectedFile != null && !selectedFile.equals(PortalServerLaunchEditorSection.this.externalPropertiesBrowse.getText())) {
                    PortalServerLaunchEditorSection.this.updating = true;
                    PortalServerLaunchEditorSection.this.execute((IUndoableOperation)new SetExternalPropertiesCommand(PortalServerLaunchEditorSection.this.server, selectedFile));
                    PortalServerLaunchEditorSection.this.externalProperties.setText(selectedFile);
                    PortalServerLaunchEditorSection.this.updating = false;
                    PortalServerLaunchEditorSection.this.validate();
                }
            }
        });
        label = this.createLabel(toolkit, composite, "");
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.developerMode = new Button(composite, 32);
        this.developerMode.setText(Msgs.useDeveloperMode);
        data = new GridData(4, 0x1000000, true, false);
        this.developerMode.setLayoutData((Object)data);
        this.developerMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PortalServerLaunchEditorSection.this.updating) {
                    return;
                }
                PortalServerLaunchEditorSection.this.updating = true;
                PortalServerLaunchEditorSection.this.execute((IUndoableOperation)new SetDeveloperModeCommand(PortalServerLaunchEditorSection.this.server, PortalServerLaunchEditorSection.this.developerMode.getSelection()));
                PortalServerLaunchEditorSection.this.updating = false;
                PortalServerLaunchEditorSection.this.validate();
            }
        });
        label = this.createLabel(toolkit, composite, "");
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.setDefault = toolkit.createHyperlink(composite, Msgs.restoreDefaultsLink, 64);
        this.setDefault.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                PortalServerLaunchEditorSection.this.updating = true;
                PortalServerLaunchEditorSection.this.execute((IUndoableOperation)new SetMemoryArgsCommand(PortalServerLaunchEditorSection.this.server, PortalServerConstants.DEFAULT_MEMORY_ARGS));
                PortalServerLaunchEditorSection.this.memoryArgs.setText(PortalServerConstants.DEFAULT_MEMORY_ARGS);
                PortalServerLaunchEditorSection.this.execute((IUndoableOperation)new SetExternalPropertiesCommand(PortalServerLaunchEditorSection.this.server, ""));
                PortalServerLaunchEditorSection.this.externalProperties.setText("");
                PortalServerLaunchEditorSection.this.execute((IUndoableOperation)new SetDeveloperModeCommand(PortalServerLaunchEditorSection.this.server, false));
                PortalServerLaunchEditorSection.this.developerMode.setSelection(false);
                PortalServerLaunchEditorSection.this.execute((IUndoableOperation)new SetLaunchSettingsCommand(PortalServerLaunchEditorSection.this.server, true));
                PortalServerLaunchEditorSection.this.defaultLaunchSettings.setSelection(true);
                PortalServerLaunchEditorSection.this.customLaunchSettings.setSelection(false);
                PortalServerLaunchEditorSection.this.applyDefaultPortalServerSetting(true);
                PortalServerLaunchEditorSection.this.updating = false;
                PortalServerLaunchEditorSection.this.validate();
            }
        });
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 3;
        this.setDefault.setLayoutData((Object)data);
        this.initialize();
    }

    protected Label createLabel(FormToolkit toolkit, Composite parent, String text) {
        Label label = toolkit.createLabel(parent, text);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        return label;
    }

    public void dispose() {
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.listener);
            if (this.server.getOriginal() != null) {
                this.server.getOriginal().removePublishListener(this.publishListener);
            }
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.workspacePath = root.getLocation();
        if (this.server != null) {
            this.portalServer = (PortalServer)this.server.loadAdapter(PortalServer.class, null);
            this.addChangeListeners();
        }
    }

    protected void initialize() {
        if (this.portalServer == null) {
            return;
        }
        this.updating = true;
        this.applyDefaultPortalServerSetting(this.portalServer.getLaunchSettings());
        this.customLaunchSettings.setSelection(!this.portalServer.getLaunchSettings());
        this.defaultLaunchSettings.setSelection(this.portalServer.getLaunchSettings());
        this.developerMode.setSelection(this.portalServer.getDeveloperMode());
        this.externalProperties.setText(this.portalServer.getExternalProperties());
        this.memoryArgs.setText(StringUtil.merge((String[])this.portalServer.getMemoryArgs(), (String)" "));
        this.server.setAttribute("auto-publish-time", this.portalServer.getAutoPublishTime());
        this.updating = false;
        this.validate();
    }

    public IStatus[] getSaveStatus() {
        File externalPropertiesFile;
        String externalPropetiesValue = this.portalServer.getExternalProperties();
        if (!(CoreUtil.isNullOrEmpty((String)externalPropetiesValue) || (externalPropertiesFile = new File(externalPropetiesValue)).exists() && ServerUtil.isValidPropertiesFile((File)externalPropertiesFile))) {
            return new IStatus[]{new Status(4, "com.liferay.ide.server.ui", Msgs.invalidExternalPropertiesFile)};
        }
        return super.getSaveStatus();
    }

    protected void validate() {
        if (this.portalServer != null) {
            File externalPropertiesFile;
            String externalPropetiesValue = this.portalServer.getExternalProperties();
            if (!(CoreUtil.isNullOrEmpty((String)externalPropetiesValue) || (externalPropertiesFile = new File(externalPropetiesValue)).exists() && ServerUtil.isValidPropertiesFile((File)externalPropertiesFile))) {
                this.setErrorMessage(Msgs.invalidExternalPropertiesFile);
                return;
            }
            this.setErrorMessage(null);
        }
    }

    private static class Msgs
    extends NLS {
        public static String customLaunchSettings;
        public static String defaultLaunchSettings;
        public static String editorBrowse;
        public static String externalPropertiesLabel;
        public static String invalidExternalPropertiesFile;
        public static String liferayLaunch;
        public static String memoryArgsLabel;
        public static String restoreDefaultsLink;
        public static String useDeveloperMode;

        static {
            Msgs.initializeMessages((String)PortalServerLaunchEditorSection.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

