/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.wizard;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.core.ILiferayRuntimeStub;
import com.liferay.ide.server.core.LiferayRuntimeStubDelegate;
import com.liferay.ide.server.core.LiferayServerCore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class LiferayRuntimeStubComposite
extends Composite {
    protected Combo comboRuntimeStubType;
    protected boolean ignoreModifyEvent = false;
    protected ILiferayRuntime liferayRuntime;
    protected IRuntimeWorkingCopy runtimeWC;
    protected Text textInstallDir;
    protected Text textName;
    protected IWizardHandle wizard;

    public LiferayRuntimeStubComposite(Composite parent, IWizardHandle wizard) {
        super(parent, 0);
        this.wizard = wizard;
        this.createControl();
        this.initialize();
        this.validate();
    }

    public void setRuntime(IRuntimeWorkingCopy newRuntime) {
        if (newRuntime == null) {
            this.runtimeWC = null;
            this.liferayRuntime = null;
        } else {
            this.runtimeWC = newRuntime;
            this.liferayRuntime = (ILiferayRuntime)newRuntime.loadAdapter(ILiferayRuntime.class, null);
        }
        this.initialize();
        this.validate();
    }

    protected void createControl() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(1808));
        Label lblName = new Label((Composite)this, 0);
        lblName.setText(Msgs.name);
        new Label((Composite)this, 0);
        this.textName = new Text((Composite)this, 2048);
        this.textName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LiferayRuntimeStubComposite.this.runtimeWC.setName(LiferayRuntimeStubComposite.this.textName.getText());
                LiferayRuntimeStubComposite.this.validate();
            }
        });
        this.createSpacer();
        Label lblRuntimeStubType = new Label((Composite)this, 0);
        lblRuntimeStubType.setText(Msgs.liferayBundleType);
        this.createSpacer();
        this.comboRuntimeStubType = new Combo((Composite)this, 8);
        this.comboRuntimeStubType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.createSpacer();
        Label lblInstall = new Label((Composite)this, 64);
        lblInstall.setText(Msgs.liferayBundleDirectory);
        new Label((Composite)this, 0);
        this.textInstallDir = new Text((Composite)this, 2048);
        this.textInstallDir.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboRuntimeStubType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = LiferayRuntimeStubComposite.this.comboRuntimeStubType.getSelectionIndex();
                ILiferayRuntimeStub selectedStub = LiferayServerCore.getRuntimeStubs()[index];
                LiferayRuntimeStubDelegate delegate = LiferayRuntimeStubComposite.this.getStubDelegate();
                delegate.setRuntimeStubTypeId(selectedStub.getRuntimeStubTypeId());
                String stubTypeId = selectedStub.getRuntimeStubTypeId();
                IRuntimeType runtimeType = ServerCore.findRuntimeType((String)stubTypeId);
                IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
                int n = iRuntimeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IRuntime runtime = iRuntimeArray[n2];
                    if (runtime.getRuntimeType().equals(runtimeType)) {
                        LiferayRuntimeStubComposite.this.textInstallDir.setText(runtime.getLocation().toOSString());
                    }
                    ++n2;
                }
                LiferayRuntimeStubComposite.this.validate();
            }
        });
        this.textInstallDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LiferayRuntimeStubComposite.this.textInstallDirChanged(LiferayRuntimeStubComposite.this.textInstallDir.getText());
            }
        });
        Button btnBrowse = new Button((Composite)this, 0);
        btnBrowse.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        btnBrowse.setText(Msgs.browse);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dialog = new DirectoryDialog(LiferayRuntimeStubComposite.this.getShell());
                dialog.setMessage(Msgs.selectRuntimeStubDirectory);
                dialog.setFilterPath(LiferayRuntimeStubComposite.this.textInstallDir.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    LiferayRuntimeStubComposite.this.textInstallDir.setText(selectedDirectory);
                }
            }
        });
        new Label((Composite)this, 0);
        Dialog.applyDialogFont((Control)this);
        this.textName.forceFocus();
    }

    protected Label createLabel(String text) {
        Label label = new Label((Composite)this, 0);
        label.setText(text);
        GridDataFactory.generate((Control)label, (int)2, (int)1);
        return label;
    }

    protected void createSpacer() {
        new Label((Composite)this, 0);
    }

    protected Text createTextField(String labelText) {
        this.createLabel(labelText);
        Text text = new Text((Composite)this, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    protected ILiferayRuntime getLiferayRuntime() {
        return this.liferayRuntime;
    }

    protected IRuntimeWorkingCopy getRuntime() {
        return this.runtimeWC;
    }

    protected LiferayRuntimeStubDelegate getStubDelegate() {
        return (LiferayRuntimeStubDelegate)this.runtimeWC.loadAdapter(LiferayRuntimeStubDelegate.class, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void initialize() {
        if (this.textName == null || this.liferayRuntime == null) {
            return;
        }
        this.ignoreModifyEvent = true;
        if (this.runtimeWC.getName() != null) {
            this.textName.setText(this.runtimeWC.getName());
        } else {
            this.textName.setText("");
        }
        if (this.runtimeWC.getLocation() != null) {
            this.textInstallDir.setText(this.runtimeWC.getLocation().toOSString());
        } else {
            this.textInstallDir.setText("");
        }
        this.updateStubs();
        this.ignoreModifyEvent = false;
    }

    protected void textInstallDirChanged(String text) {
        if (this.ignoreModifyEvent) {
            return;
        }
        this.runtimeWC.setLocation((IPath)new Path(text));
        this.validate();
    }

    protected void updateStubs() {
        Object[] stubs = LiferayServerCore.getRuntimeStubs();
        if (CoreUtil.isNullOrEmpty((Object[])stubs)) {
            return;
        }
        String[] names = new String[stubs.length];
        LiferayRuntimeStubDelegate delegate = this.getStubDelegate();
        String stubId = delegate.getRuntimeStubTypeId();
        int stubIndex = -1;
        int i = 0;
        while (i < stubs.length) {
            names[i] = stubs[i].getName();
            if (stubs[i].getRuntimeStubTypeId().equals(stubId)) {
                stubIndex = i;
            }
            ++i;
        }
        this.comboRuntimeStubType.setItems(names);
        if (stubIndex >= 0) {
            this.comboRuntimeStubType.select(stubIndex);
        }
    }

    protected IStatus validate() {
        if (this.liferayRuntime == null) {
            this.wizard.setMessage("", 3);
            return Status.OK_STATUS;
        }
        IStatus status = this.runtimeWC.validate(null);
        if (status == null || status.isOK()) {
            this.wizard.setMessage(null, 0);
        } else if (status.getSeverity() == 2) {
            this.wizard.setMessage(status.getMessage(), 2);
        } else {
            this.wizard.setMessage(status.getMessage(), 3);
        }
        this.wizard.update();
        return status;
    }

    private static class Msgs
    extends NLS {
        public static String browse;
        public static String liferayBundleDirectory;
        public static String liferayBundleType;
        public static String name;
        public static String selectRuntimeStubDirectory;

        static {
            Msgs.initializeMessages((String)LiferayRuntimeStubComposite.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

