/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui.editor;

import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.properties.PortalPropertiesConfiguration;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.util.ServerUtil;
import com.liferay.ide.ui.LiferayUIPlugin;
import com.liferay.ide.ui.editor.LiferayPropertiesContentAssistProcessor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfigurationLayout;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileSourceViewerConfiguration;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class LiferayPropertiesSourceViewerConfiguration
extends PropertiesFileSourceViewerConfiguration {
    private IContentAssistant assitant;
    private LiferayPropertiesContentAssistProcessor.PropKey[] propKeys;

    public LiferayPropertiesSourceViewerConfiguration(ITextEditor editor) {
        super(JavaPlugin.getDefault().getJavaTextTools().getColorManager(), JavaPlugin.getDefault().getCombinedPreferenceStore(), editor, "___pf_partitioning");
    }

    private IPath getAppServerPortalDir(IEditorInput input) {
        IPath retval = null;
        IFile ifile = (IFile)input.getAdapter(IFile.class);
        if (ifile != null) {
            ILiferayPortal portal;
            ILiferayProject project = LiferayCore.create((Object)ifile.getProject());
            if (project != null && (portal = (ILiferayPortal)project.adapt(ILiferayPortal.class)) != null) {
                retval = portal.getAppServerPortalDir();
            }
        } else {
            File file = (File)input.getAdapter(File.class);
            if (file == null && input instanceof FileStoreEditorInput) {
                FileStoreEditorInput fInput = (FileStoreEditorInput)input;
                file = new File(fInput.getURI().getPath());
            }
            if (file != null && file.exists()) {
                try {
                    Path propsParentPath = new Path(file.getParentFile().getCanonicalPath());
                    IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
                    int n = iRuntimeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IRuntime runtime = iRuntimeArray[n2];
                        if (propsParentPath.equals((Object)runtime.getLocation()) || propsParentPath.isPrefixOf(runtime.getLocation())) {
                            ILiferayRuntime lr = ServerUtil.getLiferayRuntime((IRuntime)runtime);
                            retval = lr.getAppServerPortalDir();
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    LiferayUIPlugin.logError("Unable to get portal language properties file", e);
                }
            }
        }
        return retval;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.propKeys == null) {
            ILiferayProject liferayProject;
            ILiferayPortal portal;
            IEditorInput input = this.getEditor().getEditorInput();
            IPath appServerPortalDir = this.getAppServerPortalDir(input);
            String propertiesEntry = this.getPropertiesEntry(input);
            LiferayPropertiesContentAssistProcessor.PropKey[] keys = null;
            if (appServerPortalDir != null && appServerPortalDir.toFile().exists()) {
                try {
                    JarFile jar = new JarFile(appServerPortalDir.append("WEB-INF/lib/portal-impl.jar").toFile());
                    ZipEntry lang = jar.getEntry(propertiesEntry);
                    keys = this.parseKeys(jar.getInputStream(lang));
                    jar.close();
                }
                catch (Exception e) {
                    LiferayUIPlugin.logError("Unable to get portal properties file", e);
                }
            } else {
                return this.assitant;
            }
            Object adapter = input.getAdapter(IFile.class);
            if (adapter instanceof IFile && this.isHookProject(((IFile)adapter).getProject()) && (portal = (ILiferayPortal)(liferayProject = LiferayCore.create((Object)((IFile)adapter).getProject())).adapt(ILiferayPortal.class)) != null) {
                HashSet hookProps = new HashSet();
                Collections.addAll(hookProps, portal.getHookSupportedProperties());
                ArrayList<LiferayPropertiesContentAssistProcessor.PropKey> filtered = new ArrayList<LiferayPropertiesContentAssistProcessor.PropKey>();
                LiferayPropertiesContentAssistProcessor.PropKey[] propKeyArray = keys;
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    LiferayPropertiesContentAssistProcessor.PropKey pk = propKeyArray[n2];
                    if (hookProps.contains(pk.getKey())) {
                        filtered.add(pk);
                    }
                    ++n2;
                }
                keys = filtered.toArray(new LiferayPropertiesContentAssistProcessor.PropKey[0]);
            }
            this.propKeys = keys;
        }
        if (this.propKeys != null && this.assitant == null) {
            ContentAssistant ca = new ContentAssistant(){

                public IContentAssistProcessor getContentAssistProcessor(String contentType) {
                    return new LiferayPropertiesContentAssistProcessor(LiferayPropertiesSourceViewerConfiguration.this.propKeys, contentType);
                }
            };
            ca.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            this.assitant = ca;
        }
        return this.assitant;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    private String getPropertiesEntry(IEditorInput input) {
        String retval = null;
        retval = input.getName().equals("system-ext.properties") ? "system.properties" : "portal.properties";
        return retval;
    }

    private boolean isHookProject(IProject project) {
        ILiferayProject lr = LiferayCore.create((Object)project);
        return lr != null && lr.getDescriptorFile("liferay-hook.xml") != null;
    }

    private LiferayPropertiesContentAssistProcessor.PropKey[] parseKeys(InputStream inputStream) throws ConfigurationException, IOException {
        ArrayList<LiferayPropertiesContentAssistProcessor.PropKey> parsed = new ArrayList<LiferayPropertiesContentAssistProcessor.PropKey>();
        PortalPropertiesConfiguration config = new PortalPropertiesConfiguration();
        config.load(inputStream);
        inputStream.close();
        Iterator keys = config.getKeys();
        PropertiesConfigurationLayout layout = config.getLayout();
        while (keys.hasNext()) {
            String key;
            String comment = layout.getComment(key = keys.next().toString());
            parsed.add(new LiferayPropertiesContentAssistProcessor.PropKey(key, comment == null ? null : comment.replaceAll("\n", "\n<br/>")));
        }
        LiferayPropertiesContentAssistProcessor.PropKey[] parsedKeys = parsed.toArray(new LiferayPropertiesContentAssistProcessor.PropKey[0]);
        Arrays.sort(parsedKeys, new Comparator<LiferayPropertiesContentAssistProcessor.PropKey>(){

            @Override
            public int compare(LiferayPropertiesContentAssistProcessor.PropKey o1, LiferayPropertiesContentAssistProcessor.PropKey o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return parsedKeys;
    }
}

