/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui.wizard;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.FilteredElementTreeSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ExternalFileSelectionDialog
extends FilteredElementTreeSelectionDialog {
    public ExternalFileSelectionDialog(Shell parent, ViewerFilter filter, boolean multiSelect, boolean acceptFolders) {
        super(parent, (ILabelProvider)new FileLabelProvider(), (ITreeContentProvider)new FileContentProvider(), true);
        this.setComparator(new FileViewerComparator());
        this.addFilter(filter);
        this.setValidator(new FileSelectionValidator(multiSelect, acceptFolders));
        this.setHelpAvailable(false);
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        TreeViewer viewer = super.doCreateTreeViewer(parent, style);
        viewer.setAutoExpandLevel(5);
        return viewer;
    }

    protected static class FileContentProvider
    implements ITreeContentProvider {
        private final Object[] EMPTY = new Object[0];

        protected FileContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children;
            if (parentElement instanceof File && (children = ((File)parentElement).listFiles()) != null) {
                return children;
            }
            return this.EMPTY;
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public Object getParent(Object element) {
            if (element instanceof File) {
                return ((File)element).getParentFile();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected static class FileLabelProvider
    extends LabelProvider {
        private final Image IMG_FILE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        private final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");

        protected FileLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof File) {
                File curr = (File)element;
                if (curr.isDirectory()) {
                    return this.IMG_FOLDER;
                }
                return this.IMG_FILE;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof File) {
                return BasicElementLabels.getResourceName((String)((File)element).getName());
            }
            return super.getText(element);
        }
    }

    protected static class FileSelectionValidator
    implements ISelectionStatusValidator {
        protected boolean fAcceptFolders;
        protected boolean fMultiSelect;

        public FileSelectionValidator(boolean multiSelect, boolean acceptFolders) {
            this.fMultiSelect = multiSelect;
            this.fAcceptFolders = acceptFolders;
        }

        public IStatus validate(Object[] selection) {
            int nSelected = selection.length;
            if (nSelected == 0 || nSelected > 1 && !this.fMultiSelect) {
                return new StatusInfo(4, "");
            }
            int i = 0;
            while (i < selection.length) {
                Object curr = selection[i];
                if (curr instanceof File) {
                    File file = (File)curr;
                    if (!this.fAcceptFolders && !file.isFile()) {
                        return new StatusInfo(4, "");
                    }
                }
                ++i;
            }
            return new StatusInfo();
        }
    }

    protected static class FileViewerComparator
    extends ViewerComparator {
        protected FileViewerComparator() {
        }

        public int category(Object element) {
            if (element instanceof File && ((File)element).isFile()) {
                return 1;
            }
            return 0;
        }
    }
}

