/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;

public class PathUtils {
    private static final String STAR = "*";
    private static final String STAR_STAR = "**";

    public static int countPatternSegmentsThatMatchParent(IPath pattern, IPath parent) {
        int matchingSegments = 0;
        if (pattern.segmentCount() != 1 || !pattern.segment(0).equals(STAR_STAR) && !pattern.segment(0).equals(STAR)) {
            int patternSegmentIndex = 0;
            int parentSegmentIndex = 0;
            boolean starStarMode = false;
            block0: while (patternSegmentIndex < pattern.segmentCount() && parentSegmentIndex < parent.segmentCount()) {
                String patternSegment = pattern.segment(patternSegmentIndex);
                String parentSegment = parent.segment(parentSegmentIndex);
                if (starStarMode) {
                    if (PathUtils.pathSegmentMatchesPattern(patternSegment, parentSegment)) {
                        starStarMode = false;
                        ++matchingSegments;
                        ++patternSegmentIndex;
                        ++parentSegmentIndex;
                        continue;
                    }
                    ++parentSegmentIndex;
                    continue;
                }
                if (patternSegment.equals(STAR_STAR)) {
                    starStarMode = true;
                    ++matchingSegments;
                    ++parentSegmentIndex;
                    int i = patternSegmentIndex + 1;
                    while (i < pattern.segmentCount()) {
                        if (!pattern.segment(i).equals(STAR_STAR) && !pattern.segment(i).equals(STAR)) {
                            patternSegmentIndex = i;
                            continue block0;
                        }
                        ++i;
                    }
                    continue;
                }
                if (!patternSegment.equals(STAR) && !PathUtils.pathSegmentMatchesPattern(patternSegment, parentSegment)) break;
                ++matchingSegments;
                ++patternSegmentIndex;
                ++parentSegmentIndex;
            }
        }
        return matchingSegments;
    }

    public static IPath makePatternRelativeToParent(IPath pattern, IPath parent) {
        int matchedSegments = PathUtils.countPatternSegmentsThatMatchParent(pattern, parent);
        IPath relativePattern = null;
        if (matchedSegments != 0) {
            relativePattern = pattern.removeFirstSegments(matchedSegments);
            if (relativePattern.segmentCount() == 0) {
                relativePattern = null;
            } else {
                relativePattern.makeRelative();
            }
        }
        return relativePattern;
    }

    private static boolean pathSegmentMatchesPattern(String patternSegment, String segment) {
        return CharOperation.pathMatch((char[])patternSegment.toCharArray(), (char[])segment.toCharArray(), (boolean)false, (char)File.separatorChar);
    }
}

