/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.ui.internal.participant;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.search.ui.internal.XMLSearchUIPlugin;
import org.eclipse.wst.xml.search.ui.internal.participant.SearchParticipantDescriptor;

public class SearchParticipantsExtensionPoint {
    public static final String PARTICIPANT_EXTENSION_POINT = "org.eclipse.wst.xml.search.ui.queryParticipants";
    private Set<SearchParticipantDescriptor> fActiveParticipants = null;
    private static SearchParticipantsExtensionPoint fgInstance;

    public boolean hasAnyParticipants() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(PARTICIPANT_EXTENSION_POINT).length > 0;
    }

    private synchronized Set<SearchParticipantDescriptor> getAllParticipants() {
        if (this.fActiveParticipants != null) {
            return this.fActiveParticipants;
        }
        IConfigurationElement[] allParticipants = Platform.getExtensionRegistry().getConfigurationElementsFor(PARTICIPANT_EXTENSION_POINT);
        this.fActiveParticipants = new HashSet<SearchParticipantDescriptor>(allParticipants.length);
        int i = 0;
        while (i < allParticipants.length) {
            SearchParticipantDescriptor descriptor = new SearchParticipantDescriptor(allParticipants[i]);
            IStatus status = descriptor.checkSyntax();
            if (status.isOK()) {
                this.fActiveParticipants.add(descriptor);
            } else {
                XMLSearchUIPlugin.log(status);
            }
            ++i;
        }
        return this.fActiveParticipants;
    }

    private void collectParticipants(Set<SearchParticipantDescriptor> participants, Object selectedNode) {
        for (SearchParticipantDescriptor participant : this.getAllParticipants()) {
            if (!participant.isEnabled() || !participant.isEnabledFor(selectedNode)) continue;
            participants.add(participant);
        }
    }

    public Set<SearchParticipantDescriptor> getSearchParticipants() {
        return this.getAllParticipants();
    }

    public SearchParticipantDescriptor[] getSearchParticipants(Object selectedNode) {
        HashSet<SearchParticipantDescriptor> participantSet = new HashSet<SearchParticipantDescriptor>();
        this.collectParticipants(participantSet, selectedNode);
        SearchParticipantDescriptor[] participants = new SearchParticipantDescriptor[participantSet.size()];
        return participantSet.toArray(participants);
    }

    public static SearchParticipantsExtensionPoint getInstance() {
        if (fgInstance == null) {
            fgInstance = new SearchParticipantsExtensionPoint();
        }
        return fgInstance;
    }

    public static void debugSetInstance(SearchParticipantsExtensionPoint instance) {
        fgInstance = instance;
    }
}

