/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.utils;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.codeassist.InternalCompletionProposal;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.recommenders.utils.LogMessages;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Reflections;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.VmMethodName;

public final class ProposalUtils {
    private static final IMethodName OBJECT_CLONE = VmMethodName.get((String)"Ljava/lang/Object.clone()Ljava/lang/Object;");
    private static final char[] INIT = "<init>".toCharArray();
    private static final char[] JAVA_LANG_OBJECT = "Ljava.lang.Object;".toCharArray();
    private static final Field ORIGINAL_SIGNATURE = (Field)Reflections.getDeclaredField(InternalCompletionProposal.class, (String)"originalSignature").orNull();

    private ProposalUtils() {
    }

    public static Optional<IMethodName> toMethodName(CompletionProposal proposal) {
        char[][] parameterTypes;
        Preconditions.checkArgument((boolean)ProposalUtils.isKindSupported(proposal));
        if (ProposalUtils.isArrayCloneMethod(proposal)) {
            return Optional.of((Object)OBJECT_CLONE);
        }
        StringBuilder builder = new StringBuilder();
        char[] declarationSignature = proposal.getDeclarationSignature();
        char[] binaryTypeSignature = ProposalUtils.getBinaryTypeSignatureCopy(declarationSignature);
        char[] erasedBinaryTypeSignature = Signature.getTypeErasure((char[])binaryTypeSignature);
        CharOperation.replace((char[])erasedBinaryTypeSignature, (char)'.', (char)'/');
        builder.append(erasedBinaryTypeSignature, 0, erasedBinaryTypeSignature.length - 1);
        builder.append('.');
        builder.append(proposal.isConstructor() ? INIT : proposal.getName());
        builder.append('(');
        char[] signature = ProposalUtils.getSignature(proposal);
        char[][] typeParameters = Signature.getTypeParameters((char[])declarationSignature);
        char[][] cArray = parameterTypes = Signature.getParameterTypes((char[])signature);
        int n = parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            char[] parameterType = cArray[n2];
            ProposalUtils.appendType(builder, parameterType, typeParameters);
            ++n2;
        }
        builder.append(')');
        ProposalUtils.appendType(builder, Signature.getReturnType((char[])signature), typeParameters);
        String methodName = builder.toString();
        try {
            return Optional.of((Object)VmMethodName.get((String)methodName));
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)org.eclipse.recommenders.internal.completion.rcp.l10n.LogMessages.ERROR_SYNTATICALLY_INCORRECT_METHOD_NAME, (Throwable)e, (Object[])new Object[]{methodName, ProposalUtils.toLogString(proposal)});
            return Optional.absent();
        }
    }

    private static char[] getBinaryTypeSignatureCopy(char[] parameterizedTypeSignature) {
        char[] binaryTypeSignature = Arrays.copyOf(parameterizedTypeSignature, parameterizedTypeSignature.length);
        int nextDot = -1;
        while ((nextDot = CharOperation.indexOf((char)'.', (char[])binaryTypeSignature, (int)(nextDot + 1))) > 0) {
            if (binaryTypeSignature[nextDot - 1] != '>') continue;
            binaryTypeSignature[nextDot] = 36;
        }
        return binaryTypeSignature;
    }

    private static void appendType(StringBuilder builder, char[] type, char[][] typeParameters) {
        switch (Signature.getTypeSignatureKind((char[])type)) {
            case 3: {
                char[] typeVariableName = CharOperation.subarray((char[])type, (int)1, (int)(type.length - 1));
                char[] resolvedTypeVariable = ProposalUtils.resolveTypeVariable(typeVariableName, typeParameters);
                builder.append(CharOperation.replaceOnCopy((char[])resolvedTypeVariable, (char)'.', (char)'/'));
                break;
            }
            case 4: {
                int dimensions = Signature.getArrayCount((char[])type);
                builder.append(type, 0, dimensions);
                ProposalUtils.appendType(builder, Signature.getElementType((char[])type), typeParameters);
                break;
            }
            default: {
                char[] erasedParameterType = Signature.getTypeErasure((char[])type);
                builder.append(CharOperation.replaceOnCopy((char[])erasedParameterType, (char)'.', (char)'/'));
            }
        }
    }

    private static char[] resolveTypeVariable(char[] typeVariableName, char[][] typeParameters) {
        char[][] cArray = typeParameters;
        int n = typeParameters.length;
        int n2 = 0;
        while (n2 < n) {
            char[] typeParameter = cArray[n2];
            if (CharOperation.equals((char[])typeVariableName, (char[])Signature.getTypeVariable((char[])typeParameter))) {
                char[][] typeParameterBounds = Signature.getTypeParameterBounds((char[])typeParameter);
                if (typeParameterBounds.length > 0) {
                    return typeParameterBounds[0];
                }
                return JAVA_LANG_OBJECT;
            }
            ++n2;
        }
        return JAVA_LANG_OBJECT;
    }

    private static String toLogString(CompletionProposal proposal) {
        if (proposal == null) {
            return "null proposal";
        }
        return "" + (char[])Objects.firstNonNull((Object)proposal.getDeclarationSignature(), (Object)CharOperation.NO_CHAR) + '#' + (char[])Objects.firstNonNull((Object)proposal.getName(), (Object)CharOperation.NO_CHAR) + '#' + (char[])Objects.firstNonNull((Object)proposal.getSignature(), (Object)CharOperation.NO_CHAR);
    }

    private static boolean isKindSupported(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 6: {
                return true;
            }
            case 24: {
                return true;
            }
            case 7: {
                return true;
            }
            case 26: {
                return true;
            }
        }
        return false;
    }

    private static boolean isArrayCloneMethod(CompletionProposal proposal) {
        if (proposal.isConstructor()) {
            return false;
        }
        char[] declarationSignature = proposal.getDeclarationSignature();
        if (declarationSignature[0] != '[') {
            return false;
        }
        if (!CharOperation.equals((char[])TypeConstants.CLONE, (char[])proposal.getName())) {
            return false;
        }
        char[] signature = proposal.getSignature();
        if (signature.length != declarationSignature.length + 2 || signature[0] != '(' || signature[1] != ')') {
            return false;
        }
        return CharOperation.endsWith((char[])signature, (char[])declarationSignature);
    }

    private static char[] getSignature(CompletionProposal proposal) {
        char[] signature = null;
        if (ProposalUtils.canUseReflection(proposal)) {
            try {
                signature = (char[])ORIGINAL_SIGNATURE.get(proposal);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_REFLECTION_FAILED, (Throwable)e, (Object[])new Object[]{ORIGINAL_SIGNATURE});
            }
        }
        return signature != null ? signature : proposal.getSignature();
    }

    private static boolean canUseReflection(CompletionProposal proposal) {
        return proposal instanceof InternalCompletionProposal && ORIGINAL_SIGNATURE != null && ORIGINAL_SIGNATURE.isAccessible();
    }
}

