/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ui.model.PreferenceInitializer;
import org.eclipse.epp.internal.logging.aeri.ui.model.SendAction;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Browsers;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final Point TOOLTIP_DISPLACEMENT = new Point(5, 20);
    private static int TOOLTIP_MS_HIDE_DELAY = 20000;

    public PreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.epp.logging.aeri.ui"));
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new StringFieldEditor(PreferenceInitializer.PROP_SERVER, Messages.FIELD_LABEL_SERVER, this.getFieldEditorParent()));
        this.addField((FieldEditor)this.createStringFieldEditorAndToolTip(PreferenceInitializer.PROP_NAME, Messages.FIELD_LABEL_NAME, Messages.FIELD_MESSAGE_NAME));
        this.addField((FieldEditor)this.createStringFieldEditorAndToolTip(PreferenceInitializer.PROP_EMAIL, Messages.FIELD_LABEL_EMAIL, String.valueOf(Messages.FIELD_MESSAGE_EMAIL) + " \n" + Messages.FIELD_DESC_EMAIL));
        this.addField((FieldEditor)new ComboFieldEditor(PreferenceInitializer.PROP_SEND_ACTION, Messages.FIELD_LABEL_ACTION, PreferencePage.createModeLabelAndValues(), this.getFieldEditorParent()));
        this.addField((FieldEditor)this.createBooleanFieldEditorAndToolTip(PreferenceInitializer.PROP_SKIP_SIMILAR_ERRORS, Messages.FIELD_LABEL_SKIP_SIMILAR_ERRORS, Messages.TOOLTIP_SKIP_SIMILAR));
        this.addField((FieldEditor)this.createBooleanFieldEditorAndToolTip(PreferenceInitializer.PROP_ANONYMIZE_STACKTRACES, Messages.FIELD_LABEL_ANONYMIZE_STACKTRACES, Messages.TOOLTIP_MAKE_STACKTRACE_ANONYMOUS));
        this.addField((FieldEditor)this.createBooleanFieldEditorAndToolTip(PreferenceInitializer.PROP_ANONYMIZE_MESSAGES, Messages.FIELD_LABEL_ANONYMIZE_MESSAGES, Messages.TOOLTIP_MAKE_MESSAGES_ANONYMOUS));
        this.addLinks(this.getFieldEditorParent());
        Dialog.applyDialogFont((Control)this.getFieldEditorParent());
    }

    private StringFieldEditor createStringFieldEditorAndToolTip(String name, String labelText, String toolTipText) {
        StringFieldEditor stringFieldEditor = new StringFieldEditor(name, labelText, this.getFieldEditorParent());
        DefaultToolTip toolTip = new DefaultToolTip((Control)stringFieldEditor.getLabelControl(this.getFieldEditorParent()));
        this.calibrateTooltip(toolTip, toolTipText);
        return stringFieldEditor;
    }

    private BooleanFieldEditor createBooleanFieldEditorAndToolTip(String fieldEditorName, String fieldEditorLabel, String toolTipText) {
        BooleanFieldEditor booleanFieldEditor = new BooleanFieldEditor(fieldEditorName, fieldEditorLabel, this.getFieldEditorParent());
        DefaultToolTip toolTip = new DefaultToolTip(booleanFieldEditor.getDescriptionControl(this.getFieldEditorParent()));
        this.calibrateTooltip(toolTip, toolTipText);
        return booleanFieldEditor;
    }

    private void calibrateTooltip(DefaultToolTip toolTip, String toolTipText) {
        toolTip.setText(toolTipText);
        toolTip.setFont(JFaceResources.getDialogFont());
        toolTip.setShift(TOOLTIP_DISPLACEMENT);
        toolTip.setHideDelay(TOOLTIP_MS_HIDE_DELAY);
    }

    private void addLinks(Composite parent) {
        Composite links = new Composite(parent, 0);
        links.setLayout((Layout)new RowLayout(512));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)links);
        this.createNotificationsLabelAndLink(links);
        new Label(links, 0);
        this.createAndConfigureLink(links, Messages.LINK_LEARN_MORE, "https://dev.eclipse.org/recommenders/community/confess/");
        this.createAndConfigureLink(links, Messages.LINK_PROVIDE_FEEDBACK, "https://docs.google.com/a/codetrails.com/forms/d/1wd9AzydLv_TMa7ZBXHO7zQIhZjZCJRNMed-6J4fVNsc/viewform");
    }

    private void createNotificationsLabelAndLink(Composite links) {
        Link link = new Link(links, 0);
        link.setText("Notifications are configured on the <a>Notifications</a> preference page.");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)PreferencePage.this.getShell(), (String)"org.eclipse.mylyn.commons.notifications.preferencePages.Notifications", null, null);
            }
        });
    }

    private Link createAndConfigureLink(Composite parent, String text, final String url) {
        Link link = new Link(parent, 0);
        link.setText(text);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Browsers.openInExternalBrowser(url);
            }
        });
        return link;
    }

    private static String[][] createModeLabelAndValues() {
        SendAction[] modes = SendAction.values();
        String[][] labelAndValues = new String[modes.length][2];
        int i = 0;
        while (i < modes.length) {
            SendAction mode = modes[i];
            labelAndValues[i][0] = PreferencePage.descriptionForMode(mode);
            labelAndValues[i][1] = mode.name();
            ++i;
        }
        return labelAndValues;
    }

    private static String descriptionForMode(SendAction mode) {
        switch (mode) {
            case ASK: {
                return Messages.PREFERENCEPAGE_ASK_LABEL;
            }
            case IGNORE: {
                return Messages.FIELD_LABEL_ACTION_REPORT_NEVER;
            }
            case SILENT: {
                return Messages.FIELD_LABEL_ACTION_REPORT_ALWAYS;
            }
        }
        return mode.name();
    }

    public boolean performOk() {
        PreferenceInitializer.getDefault().setConfigured(true);
        return super.performOk();
    }
}

