/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui;

import com.google.common.eventbus.EventBus;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CancellationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.logging.aeri.ui.Events;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.Reports;
import org.eclipse.epp.internal.logging.aeri.ui.model.ServerResponse;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;
import org.eclipse.epp.internal.logging.aeri.ui.v2.AeriServer;
import org.eclipse.epp.internal.logging.aeri.ui.v2.ServerConfiguration;

public class UploadJob
extends Job {
    private Set<ErrorReport> events;
    private Settings settings;
    private EventBus bus;
    private AeriServer server;
    private ServerConfiguration configuration;

    public UploadJob(Set<ErrorReport> events, Settings settings, ServerConfiguration configuration, AeriServer server, EventBus bus) {
        super(MessageFormat.format(Messages.UPLOADJOB_NAME, server.getConfiguration().getSubmitUrl()));
        this.events = events;
        this.settings = settings;
        this.configuration = configuration;
        this.server = server;
        this.bus = bus;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(Messages.UPLOADJOB_TASKNAME, 1);
        try {
            while (!this.events.isEmpty()) {
                ErrorReport event = this.poll(this.events);
                ErrorReport reportToSend = Reports.createAnonymizedSendCopy(event, this.settings, this.configuration);
                ServerResponse result = this.server.upload(reportToSend, monitor);
                this.bus.post((Object)new Events.ServerResponseShowRequest(result));
            }
            Status status = new Status(0, "org.eclipse.epp.logging.aeri.ui", Messages.UPLOADJOB_THANK_YOU);
            return status;
        }
        catch (CancellationException cancellationException) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            Status status = new Status(2, "org.eclipse.epp.logging.aeri.ui", Messages.UPLOADJOB_FAILED, (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    private ErrorReport poll(Set<ErrorReport> events) {
        Iterator<ErrorReport> iterator = events.iterator();
        ErrorReport event = iterator.next();
        iterator.remove();
        return event;
    }
}

