/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.log;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.Reports;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ReportHistory
extends AbstractIdleService {
    private static final String F_VERSION = "version";
    private static final String F_IDENTITY = "identity";
    private static final String F_IDENTITY_TRACE = "identity-trace";
    private Directory index;
    protected IndexWriter writer;
    protected IndexReader reader;
    protected IndexSearcher searcher;

    protected String getIndexDirectoryName() {
        return "history";
    }

    public boolean seen(ErrorReport report) {
        return this.seen((Query)new TermQuery(new Term(F_IDENTITY, Reports.exactIdentityHash(report))));
    }

    public boolean seenSimilar(ErrorReport report) {
        return this.seen((Query)new TermQuery(new Term(F_IDENTITY_TRACE, Reports.traceIdentityHash(report))));
    }

    private boolean seen(Query q) {
        try {
            this.renewReaderAndSearcher();
            TopDocs results = this.searcher.search(q, 1);
            boolean foundIdenticalReport = results.totalHits > 0;
            return foundIdenticalReport;
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_HISTORY_NOT_AVAILABLE, e);
            return false;
        }
    }

    public void remember(Iterable<ErrorReport> reports) {
        for (ErrorReport report : reports) {
            this.remember(report);
        }
    }

    public void remember(ErrorReport report) {
        if (this.seen(report)) {
            return;
        }
        Document doc = new Document();
        Field field = new Field(F_IDENTITY, Reports.exactIdentityHash(report), Field.Store.NO, Field.Index.NOT_ANALYZED);
        doc.add((Fieldable)field);
        if (report.isIgnoreSimilar()) {
            field = new Field(F_IDENTITY_TRACE, Reports.traceIdentityHash(report), Field.Store.NO, Field.Index.NOT_ANALYZED);
            doc.add((Fieldable)field);
        }
        try {
            this.writer.addDocument(doc);
            this.writer.commit();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_HISTORY_NOT_AVAILABLE, e);
        }
    }

    @VisibleForTesting
    protected Directory createIndexDirectory() throws IOException {
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
        File indexdir = new File(stateLocation.toFile(), this.getIndexDirectoryName());
        indexdir.mkdirs();
        return FSDirectory.open((File)indexdir);
    }

    protected void startUp() throws Exception {
        this.index = this.createIndexDirectory();
        this.createWriter();
        this.createReaderAndSearcher();
    }

    private void createWriter() throws CorruptIndexException, LockObtainFailedException, IOException {
        IndexWriterConfig conf = new IndexWriterConfig(Version.LUCENE_35, (Analyzer)new KeywordAnalyzer());
        conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        this.writer = new IndexWriter(this.index, conf);
        if (this.writer.numDocs() == 0) {
            this.buildInitialIndex();
        }
    }

    private void buildInitialIndex() throws CorruptIndexException, IOException {
        Document meta = new Document();
        meta.add((Fieldable)new Field(F_VERSION, "0.6", Field.Store.YES, Field.Index.NO));
        this.writer.addDocument(meta);
        this.writer.commit();
    }

    private void createReaderAndSearcher() throws CorruptIndexException, IOException {
        this.reader = IndexReader.open((Directory)this.index);
        this.searcher = new IndexSearcher(this.reader);
    }

    protected void renewReaderAndSearcher() throws IOException {
        IndexReader tmp = IndexReader.openIfChanged((IndexReader)this.reader);
        if (tmp != null) {
            IOUtils.close((Closeable[])new Closeable[]{this.reader, this.searcher});
            this.searcher = new IndexSearcher(tmp);
            this.reader = tmp;
        }
    }

    protected void shutDown() throws Exception {
        IOUtils.close((Closeable[])new Closeable[]{this.searcher, this.reader, this.writer, this.index});
    }
}

