/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.utils;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.epp.internal.logging.aeri.ui.utils.UuidTypeAdapter;

public class Json {
    public static final Type T_LIST_STRING = new TypeToken<List<String>>(){}.getType();
    private static Gson gson;

    static synchronized Gson getInstance() {
        if (gson == null) {
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapter(UUID.class, (Object)new UuidTypeAdapter());
            builder.enableComplexMapKeySerialization();
            builder.setPrettyPrinting();
            gson = builder.create();
        }
        return gson;
    }

    public static <T> T deserialize(CharSequence json, Type classOfT) {
        return Json.deserialize(json.toString(), classOfT);
    }

    public static <T> T deserialize(String json, Type classOfT) {
        try {
            return (T)Json.getInstance().fromJson(json, classOfT);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static <T> T deserialize(InputStream jsonStream, Type classOfT) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStreamReader reader = new InputStreamReader(jsonStream, Charsets.UTF_8);){
                return (T)Json.getInstance().fromJson((Reader)reader, classOfT);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static <T> T deserialize(File jsonFile, Type classOfT) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(jsonFile));){
                return Json.deserialize(in, classOfT);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String serialize(Object obj) {
        StringBuilder sb = new StringBuilder();
        Json.serialize(obj, sb);
        return sb.toString();
    }

    public static void serialize(Object obj, Appendable writer) {
        try {
            Json.getInstance().toJson(obj, writer);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void serialize(Object obj, File jsonFile) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(jsonFile));){
                Json.serialize(obj, out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void serialize(Object obj, OutputStream out) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter(out, Charsets.UTF_8);){
                Json.getInstance().toJson(obj, (Appendable)writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static <T> List<T> deserializeZip(File zip, Class<T> classOfT) throws IOException {
        LinkedList res = Lists.newLinkedList();
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            InputSupplier fis = Files.newInputStreamSupplier((File)zip);
            zis = new ZipInputStream((InputStream)fis.getInput());
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                res.add(Json.deserialize(zis, classOfT));
            }
        }
        catch (Throwable throwable) {
            Closeables.close(zis, (boolean)true);
            throw throwable;
        }
        Closeables.close((Closeable)zis, (boolean)true);
        return res;
    }
}

