/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotatedElement;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTPackage;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedPackage;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourcePackage
extends SourceAnnotatedElement<AnnotatedPackage>
implements JavaResourcePackage {
    private String name;

    public static JavaResourcePackage newInstance(JavaResourceCompilationUnit parent, PackageDeclaration declaringPackage) {
        JDTPackage pack = new JDTPackage(declaringPackage, parent.getCompilationUnit(), parent.getModifySharedDocumentCommandContext(), parent.getAnnotationEditFormatter());
        SourcePackage jrpp = new SourcePackage(parent, pack);
        jrpp.initialize(declaringPackage);
        return jrpp;
    }

    private SourcePackage(JavaResourceCompilationUnit parent, AnnotatedPackage pack) {
        super(parent, pack);
    }

    protected void initialize(PackageDeclaration packageDeclaration) {
        super.initialize((ASTNode)packageDeclaration, packageDeclaration.getName());
        this.initialize(packageDeclaration.resolveBinding());
    }

    protected void initialize(IPackageBinding packageBinding) {
        this.name = this.buildName(packageBinding);
    }

    @Override
    public JavaResourceAnnotatedElement.AstNodeType getAstNodeType() {
        return JavaResourceAnnotatedElement.AstNodeType.PACKAGE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void syncName(String astName) {
        if (ObjectTools.notEquals((Object)astName, (Object)this.name)) {
            String old = this.name;
            this.name = astName;
            this.firePropertyChanged("name", old, astName);
        }
    }

    private String buildName(IPackageBinding binding) {
        return binding == null ? null : binding.getName();
    }

    @Override
    public void synchronizeWith(PackageDeclaration packageDeclaration) {
        super.synchronizeWith((ASTNode)packageDeclaration, packageDeclaration.getName());
        this.synchronizeWith(packageDeclaration.resolveBinding());
    }

    protected void synchronizeWith(IPackageBinding packageBinding) {
        this.syncName(this.buildName(packageBinding));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }
}

