/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.PropertiesUtil;
import com.liferay.ide.portlet.core.dd.PortletDescriptorHelper;
import com.liferay.ide.project.core.ValidationPreferences;
import com.liferay.ide.xml.search.ui.AddJSRPortletActionMethodMarkerResolution;
import com.liferay.ide.xml.search.ui.AddMVCPortletActionMethodMarkerResolution;
import com.liferay.ide.xml.search.ui.AddResourceBundleFileMarkerResolution;
import com.liferay.ide.xml.search.ui.AddResourceKeyMarkerResolution;
import com.liferay.ide.xml.search.ui.markerResolutions.DecreaseInstanceScopeXmlValidationLevel;
import com.liferay.ide.xml.search.ui.markerResolutions.DecreaseProjectScopeXmlValidationLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class JSPMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private void collectPortletActionMethodResolutions(IMarker marker, List<IMarkerResolution> resolutions, IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        List<IType> mvcPortlets = this.findTypes(javaProject, "com.liferay.util.bridges.mvc.MVCPortlet");
        for (IType mvcPortlet : mvcPortlets) {
            resolutions.add((IMarkerResolution)new AddMVCPortletActionMethodMarkerResolution(marker, mvcPortlet));
        }
        List<IType> jsrPortlets = this.findTypes(javaProject, "javax.portlet.GenericPortlet");
        for (IType jsrPortlet : jsrPortlets) {
            if (mvcPortlets.contains(jsrPortlet)) continue;
            resolutions.add((IMarkerResolution)new AddJSRPortletActionMethodMarkerResolution(marker, jsrPortlet));
        }
    }

    private void collectResourceBundleResolutions(IMarker marker, List<IMarkerResolution> resolutions, IProject project) {
        block3: {
            List files;
            block2: {
                files = PropertiesUtil.getDefaultLanguagePropertiesFromProject((IProject)project);
                if (!CoreUtil.isNullOrEmpty((List)files)) break block2;
                Object[] portletNames = new PortletDescriptorHelper(project).getAllPortletNames();
                if (CoreUtil.isNullOrEmpty((Object[])portletNames)) break block3;
                Object[] objectArray = portletNames;
                int n = portletNames.length;
                int n2 = 0;
                while (n2 < n) {
                    Object portletName = objectArray[n2];
                    resolutions.add((IMarkerResolution)new AddResourceBundleFileMarkerResolution(marker, (String)portletName));
                    ++n2;
                }
                break block3;
            }
            for (IFile file : files) {
                resolutions.add((IMarkerResolution)new AddResourceKeyMarkerResolution(marker, file));
            }
        }
    }

    private void collectDecreaseValidationLevelResolutions(IMarker marker, List<IMarkerResolution> resolutions, IProject project) {
        resolutions.add((IMarkerResolution)new DecreaseProjectScopeXmlValidationLevel());
        resolutions.add((IMarkerResolution)new DecreaseInstanceScopeXmlValidationLevel());
    }

    private List<IType> findTypes(IJavaProject javaProject, String typeName) {
        List<IType> retval = Collections.emptyList();
        try {
            IType type = javaProject.findType(typeName);
            if (type != null) {
                TypeInProjectRequestor requestor = new TypeInProjectRequestor();
                IJavaSearchScope scope = SearchEngine.createStrictHierarchyScope((IJavaProject)javaProject, (IType)type, (boolean)true, (boolean)false, null);
                SearchPattern search = SearchPattern.createPattern((String)"*", (int)5, (int)0, (int)0);
                new SearchEngine().search(search, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
                retval = requestor.getResults();
            }
        }
        catch (Exception exception) {}
        return retval;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        IMarkerResolution[] retval = new IMarkerResolution[]{};
        if (this.hasResolutions(marker)) {
            ArrayList<IMarkerResolution> resolutions = new ArrayList<IMarkerResolution>();
            IProject project = marker.getResource().getProject();
            if (this.isResourceBundleQuery(marker)) {
                this.collectResourceBundleResolutions(marker, resolutions, project);
            } else if (this.isPortletActionMethodQuery(marker)) {
                this.collectPortletActionMethodResolutions(marker, resolutions, project);
            }
            this.collectDecreaseValidationLevelResolutions(marker, resolutions, project);
            retval = resolutions.toArray(new IMarkerResolution[0]);
        }
        return retval;
    }

    public boolean hasResolutions(IMarker marker) {
        block4: {
            try {
                if (!this.isJSPMarker(marker) || !this.isSupportedQuery(marker)) break block4;
                return true;
            }
            catch (CoreException coreException) {}
        }
        String valKey = marker.getAttribute("liferayPluginValidationType", null);
        if (valKey != null && ValidationPreferences.containsKey((String)valKey)) {
            return true;
        }
        return false;
    }

    private boolean isJSPMarker(IMarker marker) throws CoreException {
        return "org.eclipse.jst.jsp.core.validationMarker".equals(marker.getType());
    }

    private boolean isPortletActionMethodQuery(IMarker marker) {
        return "com.liferay.ide.xml.search.ui.portletActionMethodQuery".equals(marker.getAttribute("querySpecificationId", ""));
    }

    private boolean isResourceBundleQuery(IMarker marker) {
        return "portlet.language.properties.querySpecification".equals(marker.getAttribute("querySpecificationId", ""));
    }

    private boolean isSupportedQuery(IMarker marker) {
        return this.isResourceBundleQuery(marker) || this.isPortletActionMethodQuery(marker);
    }

    public class TypeInProjectRequestor
    extends SearchRequestor {
        private final List<IType> results = new ArrayList<IType>();

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            IType type;
            Object element = match.getElement();
            if (element instanceof IType && (type = (IType)element).getCompilationUnit() != null) {
                this.results.add(type);
            }
        }

        public List<IType> getResults() {
            return this.results;
        }
    }
}

